/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.carrot2.core.Controller;
import org.carrot2.core.ControllerFactory;
import org.carrot2.core.IDocumentSource;
import org.carrot2.core.ProcessingComponentDescriptor;
import org.carrot2.core.ProcessingComponentSuite;
import org.carrot2.util.attribute.BindableDescriptor;
import org.carrot2.util.resource.DirLocator;
import org.carrot2.util.resource.IResource;
import org.carrot2.util.resource.IResourceLocator;
import org.carrot2.util.resource.PrefixDecoratorLocator;
import org.carrot2.util.resource.ResourceLookup;
import org.carrot2.workbench.core.BundleResourceLocator;
import org.carrot2.workbench.core.helpers.Utils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkbenchCorePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.carrot2.workbench.core";
    public static final String COMPONENT_SUITE_EXTENSION_ID = "org.carrot2.core.componentSuite";
    private static WorkbenchCorePlugin plugin;
    private Controller controller;
    private ProcessingComponentSuite componentSuite;
    private HashMap<String, BindableDescriptor> bindableDescriptors = Maps.newHashMap();
    private HashMap<String, ProcessingComponentDescriptor> processingDescriptors = Maps.newHashMap();
    private HashMap<String, ImageDescriptor> componentImages = Maps.newHashMap();
    private List<ProcessingComponentDescriptor> failed = Lists.newArrayList();
    private IResourceLocator workspaceLocator;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        this.fixInstanceLocation();
        this.workspaceLocator = this.getWorkspaceResourceLocator();
        this.scanSuites();
        ArrayList arrayList = Lists.newArrayList();
        if (this.workspaceLocator != null) {
            arrayList.add(this.workspaceLocator);
        }
        arrayList.add(ResourceLookup.Location.CONTEXT_CLASS_LOADER.locator);
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("resource-lookup", new ResourceLookup((List)arrayList));
        this.controller = ControllerFactory.createCachingPooling((Class[])new Class[]{IDocumentSource.class});
        this.controller.init((Map)hashMap, this.componentSuite.getComponentConfigurations());
    }

    private void fixInstanceLocation() {
        Logger logger = LoggerFactory.getLogger(WorkbenchCorePlugin.class);
        Location location = Platform.getInstanceLocation();
        if (!location.isSet()) {
            Location location2 = Platform.getInstallLocation();
            if (location2.isSet()) {
                try {
                    location.set(location2.getDataArea("workspace"), true);
                    logger.info("Changed instanceLocation to: " + location.getURL());
                }
                catch (Exception exception) {
                    logger.error("Unable to set instanceLocation to: " + location.getURL());
                }
            } else {
                logger.error("Could not determine install location.");
            }
        } else {
            logger.info("Instance location already set to: " + location.getURL());
        }
        logger.debug("User location: " + Platform.getUserLocation().getURL());
        logger.debug("Install location: " + Platform.getInstallLocation().getURL());
        logger.debug("Instance location: " + Platform.getInstanceLocation().getURL());
        logger.debug("Platform working location: " + Platform.getLocation());
        logger.debug("Configuration location: " + Platform.getConfigurationLocation().getURL());
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        this.controller.dispose();
        this.controller = null;
        super.stop(bundleContext);
    }

    public Controller getController() {
        return this.controller;
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        return WorkbenchCorePlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)string);
    }

    public ProcessingComponentSuite getComponentSuite() {
        return this.componentSuite;
    }

    public BindableDescriptor getComponentDescriptor(String string) {
        return this.bindableDescriptors.get(string);
    }

    public ProcessingComponentDescriptor getComponent(String string) {
        return this.processingDescriptors.get(string);
    }

    public ImageDescriptor getComponentImageDescriptor(String string) {
        ImageDescriptor imageDescriptor = this.componentImages.get(string);
        if (imageDescriptor == null) {
            imageDescriptor = WorkbenchCorePlugin.getImageDescriptor("icons/missing-component.png");
        }
        return imageDescriptor;
    }

    public static WorkbenchCorePlugin getDefault() {
        return plugin;
    }

    private void scanSuites() {
        String string;
        Object object;
        ArrayList arrayList;
        ArrayList arrayList2 = Lists.newArrayList();
        IExtension[] iExtensionArray = Platform.getExtensionRegistry().getExtensionPoint(COMPONENT_SUITE_EXTENSION_ID).getExtensions();
        IExtension[] iExtensionArray2 = iExtensionArray;
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            block21: {
                arrayList = iExtensionArray2[n2];
                object = arrayList.getConfigurationElements();
                if (((IConfigurationElement[])object).length == 1 && "suite".equals(object[0].getName())) {
                    String string2;
                    string = object[0].getAttribute("resourceRoot");
                    if (StringUtils.isEmpty((String)string)) {
                        string = "";
                    }
                    if (!StringUtils.isEmpty((String)(string2 = object[0].getAttribute("resource")))) {
                        IContributor iContributor;
                        String string3 = object[0].getAttribute("bundleId");
                        if (StringUtils.isEmpty((String)string3)) {
                            iContributor = arrayList.getContributor();
                            string3 = iContributor.getName();
                        }
                        if ((iContributor = Platform.getBundle((String)string3)) == null) {
                            Utils.logError("Suite's bundle not found: " + string3, false);
                        } else {
                            Object object2;
                            ResourceLookup resourceLookup;
                            IResource iResource;
                            if (iContributor.getState() != 32) {
                                try {
                                    iContributor.start();
                                }
                                catch (BundleException bundleException) {
                                    Utils.logError("Bundle inactive: " + string3, false);
                                    break block21;
                                }
                            }
                            if ((iResource = (resourceLookup = new ResourceLookup(new IResourceLocator[]{this.workspaceLocator, new PrefixDecoratorLocator((IResourceLocator)new BundleResourceLocator((Bundle)iContributor), string)})).getFirst(string2)) == null) {
                                object2 = "Suite extension resource not found in " + iContributor.getSymbolicName() + ": " + string3;
                                Utils.logError((String)object2, false);
                            } else {
                                try {
                                    object2 = ProcessingComponentSuite.deserialize((IResource)iResource, (ResourceLookup)resourceLookup);
                                    this.failed.addAll(object2.removeUnavailableComponents());
                                    for (ProcessingComponentDescriptor processingComponentDescriptor : object2.getComponents()) {
                                        String string4 = processingComponentDescriptor.getIconPath();
                                        if (StringUtils.isEmpty((String)string4)) continue;
                                        this.componentImages.put(processingComponentDescriptor.getId(), WorkbenchCorePlugin.imageDescriptorFromPlugin((String)string3, (String)string4));
                                    }
                                    arrayList2.add(object2);
                                }
                                catch (Exception exception) {
                                    Utils.logError("Failed to load suite extension.", exception, false);
                                }
                            }
                        }
                    }
                }
            }
            ++n2;
        }
        arrayList = Lists.newArrayList();
        ArrayList arrayList3 = Lists.newArrayList();
        for (ProcessingComponentSuite processingComponentSuite : arrayList2) {
            arrayList.addAll(processingComponentSuite.getSources());
            arrayList3.addAll(processingComponentSuite.getAlgorithms());
        }
        this.componentSuite = new ProcessingComponentSuite(arrayList, arrayList3);
        for (ProcessingComponentDescriptor processingComponentDescriptor : this.componentSuite.getComponents()) {
            try {
                object = processingComponentDescriptor.getId();
                string = processingComponentDescriptor.getBindableDescriptor();
                this.bindableDescriptors.put((String)object, (BindableDescriptor)string);
                this.processingDescriptors.put((String)object, processingComponentDescriptor);
            }
            catch (Exception exception) {
                Utils.logError("Failed to extract descriptor from: " + processingComponentDescriptor.getId(), exception, false);
            }
        }
        if (!this.failed.isEmpty()) {
            for (ProcessingComponentDescriptor processingComponentDescriptor : this.failed) {
                this.getLog().log((IStatus)new Status(4, PLUGIN_ID, "Plugin loading failure: " + processingComponentDescriptor.getId() + " (" + processingComponentDescriptor.getTitle() + ")" + "\n" + StringUtils.defaultIfEmpty((String)processingComponentDescriptor.getInitializationFailure().getMessage(), (String)"(no message)"), processingComponentDescriptor.getInitializationFailure()));
            }
        }
    }

    public List<ProcessingComponentDescriptor> getFailed() {
        return this.failed;
    }

    private IResourceLocator getWorkspaceResourceLocator() {
        File file;
        URL uRL = Platform.getInstanceLocation().getURL();
        if (uRL == null) {
            Utils.logError("Instance location not available.", false);
            return null;
        }
        if (!"file".equalsIgnoreCase(uRL.getProtocol())) {
            Utils.logError("Instance location not a file URL: " + uRL, false);
            return null;
        }
        try {
            file = URIUtil.toFile((URI)uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(uRL.getFile());
        }
        file = file.getAbsoluteFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.exists()) {
            Utils.logError("Instance location does not exist: " + file, false);
            return null;
        }
        return new DirLocator(file.getAbsoluteFile());
    }

    public static IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode(PLUGIN_ID);
    }
}

