/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.helpers;

import org.carrot2.workbench.core.helpers.Utils;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;

public abstract class ActiveEditorActionDelegate
extends ActionDelegate
implements IWorkbenchWindowActionDelegate {
    private IEditorPart editor;
    private IWorkbenchWindow window;
    private IAction action;
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
            this.react(iWorkbenchPart);
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
            this.react(iWorkbenchPart);
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
            this.react(iWorkbenchPart);
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
            this.react(iWorkbenchPart);
        }

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
            this.react(iWorkbenchPart);
        }

        private void react(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart instanceof IEditorPart) {
                ActiveEditorActionDelegate.this.updateActiveEditor();
            }
        }
    };

    public void init(IAction iAction) {
        this.action = iAction;
        this.updateActionState(iAction, null);
        this.updateActiveEditor();
    }

    public void dispose() {
        if (this.window != null) {
            this.window.getPartService().removePartListener(this.partListener);
        }
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        iWorkbenchWindow.getPartService().addPartListener(this.partListener);
        this.window = iWorkbenchWindow;
    }

    private void updateActiveEditor() {
        IEditorPart iEditorPart = this.editor;
        IEditorPart iEditorPart2 = Utils.getActiveEditor();
        if (iEditorPart == iEditorPart2) {
            return;
        }
        this.editor = iEditorPart2 != null && this.isEditorRelevant(iEditorPart2) ? iEditorPart2 : null;
        this.switchingEditors(iEditorPart, this.editor);
        this.updateActionState(this.action, this.editor);
    }

    protected void switchingEditors(IEditorPart iEditorPart, IEditorPart iEditorPart2) {
    }

    protected void updateActionState(IAction iAction, IEditorPart iEditorPart) {
        iAction.setEnabled(this.editor != null && this.isEnabled(this.editor));
    }

    protected boolean isEnabled(IEditorPart iEditorPart) {
        return true;
    }

    protected abstract boolean isEditorRelevant(IEditorPart var1);

    protected IEditorPart getEditor() {
        return this.editor;
    }

    protected IAction getAction() {
        return this.action;
    }
}

