/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.helpers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import org.carrot2.workbench.editors.IAttributeEventProvider;
import org.carrot2.workbench.editors.IAttributeListener;
import org.eclipse.core.commands.operations.OperationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;

public final class DisposeBin {
    private final HashMap<Object, Disposer<?>> resources = new HashMap();
    private final ArrayList<ListenerPair> listeners = Lists.newArrayList();
    private final Plugin plugin;

    public DisposeBin() {
        this(null);
    }

    public DisposeBin(Plugin plugin) {
        this.plugin = plugin;
    }

    public void add(Resource ... resourceArray) {
        Resource[] resourceArray2 = resourceArray;
        int n = resourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray2[n2];
            this.resources.put(resource, new ResourceDisposer(resource));
            ++n2;
        }
    }

    public void add(FormToolkit formToolkit) {
        this.resources.put(formToolkit, new FormToolkitDisposer(formToolkit));
    }

    public void add(Widget widget) {
        this.resources.put(widget, new WidgetDisposer(widget));
    }

    public void add(ActionFactory.IWorkbenchAction iWorkbenchAction) {
        this.resources.put(iWorkbenchAction, new ActionDisposer(iWorkbenchAction));
    }

    public void dispose() {
        OperationStatus operationStatus;
        for (Disposer<?> object : this.resources.values()) {
            try {
                object.dispose();
            }
            catch (Throwable throwable) {
                if (this.plugin == null) continue;
                operationStatus = new OperationStatus(4, this.plugin.getBundle().getSymbolicName(), -1, "Resource disposal failed.", throwable);
                this.plugin.getLog().log((IStatus)operationStatus);
            }
        }
        this.resources.clear();
        for (ListenerPair listenerPair : this.listeners) {
            try {
                if (listenerPair.registrar instanceof IPreferenceStore) {
                    ((IPreferenceStore)listenerPair.registrar).removePropertyChangeListener((IPropertyChangeListener)listenerPair.listener);
                    continue;
                }
                if (listenerPair.registrar instanceof IAttributeEventProvider) {
                    ((IAttributeEventProvider)listenerPair.registrar).removeAttributeListener((IAttributeListener)listenerPair.listener);
                    continue;
                }
                if (listenerPair.registrar instanceof IPostSelectionProvider) {
                    ((IPostSelectionProvider)listenerPair.registrar).removePostSelectionChangedListener((ISelectionChangedListener)listenerPair.listener);
                    continue;
                }
                throw new RuntimeException("Unhandled registrar: " + listenerPair.registrar);
            }
            catch (Throwable throwable) {
                if (this.plugin == null) continue;
                operationStatus = new OperationStatus(4, this.plugin.getBundle().getSymbolicName(), -1, "Listener disposal failed.", throwable);
                this.plugin.getLog().log((IStatus)operationStatus);
            }
        }
        this.listeners.clear();
    }

    public void registerPropertyChangeListener(IPreferenceStore iPreferenceStore, IPropertyChangeListener iPropertyChangeListener) {
        iPreferenceStore.addPropertyChangeListener(iPropertyChangeListener);
        this.listeners.add(new ListenerPair(iPreferenceStore, iPropertyChangeListener));
    }

    public void registerAttributeChangeListener(IAttributeEventProvider iAttributeEventProvider, IAttributeListener iAttributeListener) {
        iAttributeEventProvider.addAttributeListener(iAttributeListener);
        this.listeners.add(new ListenerPair(iAttributeEventProvider, iAttributeListener));
    }

    public void registerPostSelectionChangedListener(IPostSelectionProvider iPostSelectionProvider, ISelectionChangedListener iSelectionChangedListener) {
        iPostSelectionProvider.addPostSelectionChangedListener(iSelectionChangedListener);
    }

    private static class ActionDisposer
    extends Disposer<ActionFactory.IWorkbenchAction> {
        public ActionDisposer(ActionFactory.IWorkbenchAction iWorkbenchAction) {
            super(iWorkbenchAction);
        }

        @Override
        public void dispose() {
            ((ActionFactory.IWorkbenchAction)this.t).dispose();
        }
    }

    private static abstract class Disposer<T> {
        protected final T t;

        Disposer(T t) {
            this.t = t;
        }

        public abstract void dispose();
    }

    private static class FormToolkitDisposer
    extends Disposer<FormToolkit> {
        public FormToolkitDisposer(FormToolkit formToolkit) {
            super(formToolkit);
        }

        @Override
        public void dispose() {
            ((FormToolkit)this.t).dispose();
        }
    }

    private static class ListenerPair {
        public final Object registrar;
        public final Object listener;

        public ListenerPair(Object object, Object object2) {
            this.registrar = object;
            this.listener = object2;
        }
    }

    private static class ResourceDisposer
    extends Disposer<Resource> {
        public ResourceDisposer(Resource resource) {
            super(resource);
        }

        @Override
        public void dispose() {
            ((Resource)this.t).dispose();
        }
    }

    private static class WidgetDisposer
    extends Disposer<Widget> {
        public WidgetDisposer(Widget widget) {
            super(widget);
        }

        @Override
        public void dispose() {
            ((Widget)this.t).dispose();
        }
    }
}

