/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.helpers;

import java.beans.Introspector;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang.StringUtils;
import org.carrot2.util.ExceptionUtils;
import org.carrot2.workbench.core.WorkbenchCorePlugin;
import org.carrot2.workbench.core.helpers.Utils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

public final class SimpleXmlMemento {
    static IMemento toMemento(Object object) throws IOException {
        try {
            StringWriter stringWriter = new StringWriter();
            new Persister().write(object, (Writer)stringWriter);
            XMLMemento xMLMemento = XMLMemento.createReadRoot((Reader)new StringReader(stringWriter.toString()));
            return xMLMemento;
        }
        catch (Exception exception) {
            throw (IOException)ExceptionUtils.wrapAs(IOException.class, (Throwable)exception);
        }
    }

    static <T> T fromMemento(Class<T> clazz, IMemento iMemento) throws IOException {
        try {
            StringWriter stringWriter = new StringWriter();
            XMLMemento xMLMemento = XMLMemento.createWriteRoot((String)iMemento.getType());
            xMLMemento.putMemento(iMemento);
            xMLMemento.save((Writer)stringWriter);
            return (T)new Persister().read(clazz, (Reader)new StringReader(stringWriter.toString()));
        }
        catch (Exception exception) {
            throw (IOException)ExceptionUtils.wrapAs(IOException.class, (Throwable)exception);
        }
    }

    static <T> T fromMemento(Class<T> clazz, IMemento iMemento, String string) throws IOException {
        IMemento[] iMementoArray = iMemento.getChildren(string);
        if (iMementoArray.length != 1) {
            throw new IOException("Expected a single node named '" + string + "' under memento '" + iMemento.getType() + "'.");
        }
        return SimpleXmlMemento.fromMemento(clazz, iMementoArray[0]);
    }

    public static String toString(IMemento iMemento) {
        Object object;
        if (!(iMemento instanceof XMLMemento)) {
            object = XMLMemento.createWriteRoot((String)iMemento.getType());
            object.putMemento(iMemento);
            iMemento = object;
        }
        try {
            object = new StringWriter();
            ((XMLMemento)iMemento).save((Writer)object);
            return ((StringWriter)object).toString();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static String toString(Object object) throws IOException {
        SimpleXmlMemento.checkObject(object);
        try {
            StringWriter stringWriter = new StringWriter();
            new Persister().write(object, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            throw (IOException)ExceptionUtils.wrapAs(IOException.class, (Throwable)exception);
        }
    }

    public static <T> T fromString(Class<T> clazz, String string) throws IOException {
        try {
            StringReader stringReader = new StringReader(string);
            return (T)new Persister().read(clazz, (Reader)stringReader);
        }
        catch (Exception exception) {
            throw (IOException)ExceptionUtils.wrapAs(IOException.class, (Throwable)exception);
        }
    }

    public static void addChild(IMemento iMemento, Object object) throws IOException {
        SimpleXmlMemento.checkObject(object);
        IMemento iMemento2 = SimpleXmlMemento.toMemento(object);
        iMemento.createChild(iMemento2.getType()).putMemento(iMemento2);
    }

    public static <T> T getChild(Class<T> clazz, IMemento iMemento) throws IOException {
        IMemento[] iMementoArray;
        Root root = clazz.getAnnotation(Root.class);
        if (root == null) {
            throw new IllegalArgumentException("Missing @Root annotation on: " + clazz.getName());
        }
        String string = root.name();
        if (StringUtils.isEmpty((String)string)) {
            string = SimpleXmlMemento.getClassName(clazz);
        }
        if ((iMementoArray = iMemento.getChildren(string)).length == 0) {
            return null;
        }
        if (iMementoArray.length != 1) {
            throw new IOException("More than one child named '" + string + "':" + iMementoArray.length);
        }
        return SimpleXmlMemento.fromMemento(clazz, iMementoArray[0]);
    }

    public static void toPreferenceStore(String string, Object object) {
        IPreferenceStore iPreferenceStore = WorkbenchCorePlugin.getDefault().getPreferenceStore();
        try {
            iPreferenceStore.setValue(string, SimpleXmlMemento.toString(object));
        }
        catch (IOException iOException) {
            Utils.logError(iOException, false);
        }
    }

    public static <T> T fromPreferenceStore(Class<T> clazz, String string) {
        IPreferenceStore iPreferenceStore = WorkbenchCorePlugin.getDefault().getPreferenceStore();
        String string2 = iPreferenceStore.getString(string);
        if (!StringUtils.isEmpty((String)string2)) {
            try {
                return SimpleXmlMemento.fromString(clazz, string2);
            }
            catch (IOException iOException) {
                Utils.logError(iOException, false);
            }
        }
        return null;
    }

    private static void checkObject(Object object) {
        Root root = object.getClass().getAnnotation(Root.class);
        if (root == null) {
            throw new IllegalArgumentException("Missing @Root annotation on: " + object.getClass());
        }
    }

    private static String getClassName(Class<?> clazz) {
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        String string = clazz.getSimpleName();
        if (clazz.isPrimitive()) {
            return string;
        }
        return Introspector.decapitalize(string);
    }
}

