/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.helpers;

import org.carrot2.workbench.core.WorkbenchCorePlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.slf4j.LoggerFactory;

public final class Utils {
    private Utils() {
    }

    public static void showError(IStatus iStatus) {
        Utils.showError(iStatus.getMessage(), iStatus);
    }

    public static void showError(final String string, final IStatus iStatus) {
        WorkbenchCorePlugin.getDefault().getLog().log(iStatus);
        if (Display.getCurrent() != null) {
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), null, (String)string, (IStatus)iStatus);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), null, (String)string, (IStatus)iStatus);
                }
            });
        }
    }

    public static void logError(String string, Throwable throwable, boolean bl) {
        LoggerFactory.getLogger(Utils.class).error(string, throwable);
        Status status = new Status(4, "org.carrot2.workbench.core", -1, string, throwable);
        WorkbenchCorePlugin.getDefault().getLog().log((IStatus)status);
        if (bl) {
            Utils.showError((IStatus)status);
        } else {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.pde.runtime.LogView");
            }
            catch (Exception exception) {}
        }
    }

    public static void logError(String string, boolean bl) {
        Utils.logError(string, null, bl);
    }

    public static void logInfo(String string) {
        Status status = new Status(1, "org.carrot2.workbench.core", string);
        WorkbenchCorePlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void logError(Throwable throwable, boolean bl) {
        Utils.logError(throwable.getMessage(), throwable, bl);
    }

    public static void asyncExec(Runnable runnable) {
        Display.getDefault().asyncExec(runnable);
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
        return iEditorPart;
    }

    public static void adaptToFormUI(FormToolkit formToolkit, Control control) {
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            formToolkit.adapt(composite);
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                Utils.adaptToFormUI(formToolkit, controlArray[n]);
                ++n;
            }
        } else {
            formToolkit.adapt(control, true, true);
        }
    }

    public static void setBackground(Control control, int n) {
        control.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(n));
    }

    public static IViewPart showView(String string) {
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (iWorkbenchPage != null) {
            try {
                IViewPart iViewPart = iWorkbenchPage.findView(string);
                if (!iWorkbenchPage.isPartVisible((IWorkbenchPart)iViewPart)) {
                    return iWorkbenchPage.showView(string);
                }
            }
            catch (PartInitException partInitException) {}
        }
        return null;
    }
}

