/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.preferences;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import org.carrot2.util.attribute.BindableDescriptor;
import org.carrot2.workbench.core.WorkbenchCorePlugin;
import org.carrot2.workbench.core.ui.SearchEditor;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        IPreferenceStore iPreferenceStore = WorkbenchCorePlugin.getDefault().getPreferenceStore();
        EnumMap enumMap = Maps.newEnumMap(SearchEditor.PanelName.class);
        enumMap.put(SearchEditor.PanelName.CLUSTERS, PreferenceInitializer.createPanelState(1, true));
        enumMap.put(SearchEditor.PanelName.DOCUMENTS, PreferenceInitializer.createPanelState(2, true));
        enumMap.put(SearchEditor.PanelName.ATTRIBUTES, PreferenceInitializer.createPanelState(1, false));
        SearchEditor.saveGlobalPanelsState(enumMap);
        iPreferenceStore.setDefault("auto-update.enabled", true);
        iPreferenceStore.setDefault("auto-update.delay", 1000);
        iPreferenceStore.setDefault("attributes-view.layout", BindableDescriptor.GroupingMethod.GROUP.name());
        iPreferenceStore.setDefault("search-input-view.show-required", true);
        iPreferenceStore.setDefault("search-input-view.layout", BindableDescriptor.GroupingMethod.LEVEL.name());
        iPreferenceStore.setDefault("search-editor.layout", BindableDescriptor.GroupingMethod.GROUP.name());
        iPreferenceStore.setDefault("attribute-info-view.sync", true);
        iPreferenceStore.setDefault("max.field.length", 280);
    }

    private static SearchEditor.PanelState createPanelState(int n, boolean bl) {
        SearchEditor.PanelState panelState = new SearchEditor.PanelState();
        panelState.visibility = bl;
        panelState.weight = n;
        return panelState;
    }
}

