/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import org.carrot2.workbench.core.WorkbenchCorePlugin;
import org.carrot2.workbench.core.ui.SearchEditor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class WorkbenchPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.carrot2.workbench.core.preferences.WorkbenchPreferencesPage";
    private Collection<BooleanFieldEditor> editors = new ArrayList<BooleanFieldEditor>();

    public WorkbenchPreferencesPage() {
        super(1);
        this.setPreferenceStore(WorkbenchCorePlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
    }

    protected Control createContents(Composite composite) {
        BooleanFieldEditor booleanFieldEditor;
        SearchEditor.PanelName panelName2;
        Composite composite2 = WorkbenchPreferencesPage.createSpacerComposite(composite);
        Group group = this.createOptionGroup(composite2, "Visible editor panels");
        Composite composite3 = WorkbenchPreferencesPage.createSpacerComposite((Composite)group);
        for (SearchEditor.PanelName panelName2 : EnumSet.allOf(SearchEditor.PanelName.class)) {
            booleanFieldEditor = new BooleanFieldEditor(panelName2.prefKeyVisibility, panelName2.name, composite3);
            this.editors.add(booleanFieldEditor);
            this.addField((FieldEditor)booleanFieldEditor);
        }
        group = this.createOptionGroup(composite2, "Editor auto-update");
        composite3 = WorkbenchPreferencesPage.createSpacerComposite((Composite)group);
        panelName2 = new BooleanFieldEditor("auto-update.enabled", "Automatically re-process after attributes change", composite3);
        panelName2.fillIntoGrid(composite3, 2);
        this.addField((FieldEditor)panelName2);
        IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor("auto-update.delay", "Auto-update after (milliseconds)", composite3);
        integerFieldEditor.setEmptyStringAllowed(false);
        integerFieldEditor.setValidRange(0, 5000);
        integerFieldEditor.setValidateStrategy(0);
        integerFieldEditor.fillIntoGrid(composite3, 2);
        this.addField((FieldEditor)integerFieldEditor);
        group = this.createOptionGroup(composite2, "Search result display");
        composite3 = WorkbenchPreferencesPage.createSpacerComposite((Composite)group);
        booleanFieldEditor = new IntegerFieldEditor("max.field.length", "Maximum snippet/title length", composite3);
        booleanFieldEditor.setEmptyStringAllowed(false);
        booleanFieldEditor.setValidRange(0, 100000);
        booleanFieldEditor.setValidateStrategy(0);
        booleanFieldEditor.fillIntoGrid(composite3, 2);
        this.addField((FieldEditor)booleanFieldEditor);
        this.initialize();
        this.checkState();
        return composite2;
    }

    private Group createOptionGroup(Composite composite, String string) {
        Group group = new Group(composite, 16384);
        GridLayout gridLayout = new GridLayout(1, false);
        group.setLayout((Layout)gridLayout);
        group.setText(string);
        group.setFont(composite.getFont());
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        return group;
    }

    private static Composite createSpacerComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setFont(composite.getFont());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        composite2.setLayoutData((Object)gridData);
        return composite2;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if (propertyChangeEvent.getProperty().equals("field_editor_value")) {
            this.checkState();
        }
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected void checkState() {
        super.checkState();
        if (this.isValid()) {
            boolean bl = false;
            for (BooleanFieldEditor booleanFieldEditor : this.editors) {
                bl |= booleanFieldEditor.getBooleanValue();
            }
            if (!bl) {
                this.setErrorMessage("At least one panel must be visible");
                this.setValid(false);
            } else {
                this.setErrorMessage(null);
            }
        }
    }
}

