/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang.StringUtils;
import org.carrot2.core.IProcessingComponent;
import org.carrot2.core.attribute.InternalAttributePredicate;
import org.carrot2.util.attribute.AttributeDescriptor;
import org.carrot2.util.attribute.BindableDescriptor;
import org.carrot2.workbench.core.helpers.GUIFactory;
import org.carrot2.workbench.core.helpers.Utils;
import org.carrot2.workbench.core.ui.AttributeList;
import org.carrot2.workbench.editors.AttributeEvent;
import org.carrot2.workbench.editors.AttributeListenerAdapter;
import org.carrot2.workbench.editors.ForwardingAttributeListener;
import org.carrot2.workbench.editors.IAttributeEventProvider;
import org.carrot2.workbench.editors.IAttributeListener;
import org.carrot2.workbench.editors.factory.EditorFactory;
import org.carrot2.workbench.editors.factory.EditorNotFoundException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public final class AttributeGroups
extends Composite
implements IAttributeEventProvider {
    public static final int SPACE_TO_NEXT_GROUP = 10;
    private static final String UNGROUPED_ATTRIBUTES_GROUP = "Ungrouped";
    private BindableDescriptor.GroupingMethod grouping;
    private Composite mainControl;
    private final List<IAttributeListener> listeners = new CopyOnWriteArrayList<IAttributeListener>();
    private final IAttributeListener forwardListener = new ForwardingAttributeListener(this.listeners);
    private final IAttributeListener updateListener = new AttributeListenerAdapter(){

        @Override
        public void valueChanged(AttributeEvent attributeEvent) {
            AttributeGroups.this.currentValues.put(attributeEvent.key, attributeEvent.value);
        }

        @Override
        public void valueChanging(AttributeEvent attributeEvent) {
            this.valueChanged(attributeEvent);
        }
    };
    private BindableDescriptor descriptor;
    private Map<String, AttributeList> attributeEditors = Maps.newLinkedHashMap();
    private Predicate<AttributeDescriptor> filterPredicate;
    private HashMap<String, Object> currentValues;
    private Map<String, Section> attributeGroupSections = Maps.newHashMap();
    private Map<String, Boolean> attributeGroupExpansionState = Maps.newHashMap();

    public AttributeGroups(Composite composite, BindableDescriptor bindableDescriptor, BindableDescriptor.GroupingMethod groupingMethod, Predicate<AttributeDescriptor> predicate, Map<String, Object> map) {
        super(composite, 0);
        this.descriptor = bindableDescriptor;
        this.grouping = groupingMethod;
        this.filterPredicate = predicate;
        this.createComponents();
        this.currentValues = Maps.newHashMap(map);
        this.refreshUI();
    }

    private void createComponents() {
        GridLayout gridLayout = GUIFactory.zeroMarginGridLayout();
        this.setLayout((Layout)gridLayout);
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)GUIFactory.zeroMarginGridLayout());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.mainControl = composite;
    }

    public void setGrouping(BindableDescriptor.GroupingMethod groupingMethod) {
        if (groupingMethod == this.grouping) {
            return;
        }
        this.grouping = groupingMethod;
        this.refreshUI();
    }

    public void setFilter(Predicate<AttributeDescriptor> predicate) {
        if (this.filterPredicate == predicate) {
            return;
        }
        this.filterPredicate = predicate;
        this.refreshUI();
    }

    private void refreshUI() {
        this.mainControl.setRedraw(false);
        this.disposeEditors();
        this.createEditors(this.mainControl);
        this.mainControl.setRedraw(true);
        this.forceReflow();
    }

    private void forceReflow() {
        AttributeGroups attributeGroups = this;
        while (attributeGroups != null) {
            if (attributeGroups instanceof SharedScrolledComposite) {
                ((SharedScrolledComposite)attributeGroups).reflow(true);
                break;
            }
            attributeGroups = attributeGroups.getParent();
        }
    }

    public BindableDescriptor.GroupingMethod getGrouping() {
        return this.grouping;
    }

    private void createEditors(Composite composite) {
        BindableDescriptor bindableDescriptor = this.descriptor.only(Predicates.not((Predicate)new InternalAttributePredicate(Boolean.valueOf(false)))).only((Predicate)new HasEditorPredicate());
        if (this.filterPredicate != null) {
            bindableDescriptor = bindableDescriptor.only(this.filterPredicate);
        }
        if (bindableDescriptor.attributeDescriptors.isEmpty()) {
            this.createMessage(this.mainControl, this, "No attributes.");
        }
        bindableDescriptor = bindableDescriptor.group(this.grouping);
        for (Object k : bindableDescriptor.attributeGroups.keySet()) {
            String string = k instanceof Class ? ((Class)k).getSimpleName() : StringUtils.abbreviate((String)k.toString(), (int)160);
            this.createEditorGroup(this.mainControl, k.toString(), string, bindableDescriptor, (Map)bindableDescriptor.attributeGroups.get(k), this);
        }
        if (this.grouping == BindableDescriptor.GroupingMethod.NONE) {
            if (bindableDescriptor.attributeGroups.size() > 0) {
                Utils.logError("There should be no groups if grouping is NONE.", false);
            }
            if (!bindableDescriptor.attributeDescriptors.isEmpty()) {
                this.createUntitledEditorGroup(this.mainControl, bindableDescriptor, bindableDescriptor.attributeDescriptors, this);
            }
        } else if (!bindableDescriptor.attributeDescriptors.isEmpty()) {
            this.createEditorGroup(this.mainControl, UNGROUPED_ATTRIBUTES_GROUP, UNGROUPED_ATTRIBUTES_GROUP, bindableDescriptor, bindableDescriptor.attributeDescriptors, this);
        }
    }

    private void createMessage(Composite composite, AttributeGroups attributeGroups, String string) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        CLabel cLabel = new CLabel(composite, 0);
        cLabel.setLayoutData((Object)gridData);
        cLabel.setText(string);
        cLabel.setAlignment(16384);
    }

    private void createUntitledEditorGroup(Composite composite, BindableDescriptor bindableDescriptor, Map<String, AttributeDescriptor> map, IAttributeEventProvider iAttributeEventProvider) {
        GridLayout gridLayout = GUIFactory.zeroMarginGridLayout();
        gridLayout.numColumns = 1;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        composite2.setLayoutData((Object)gridData);
        AttributeList attributeList = new AttributeList(composite2, bindableDescriptor, map, iAttributeEventProvider, this.currentValues);
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.verticalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.grabExcessVerticalSpace = false;
        attributeList.setLayoutData(gridData2);
        for (String string : map.keySet()) {
            this.attributeEditors.put(string, attributeList);
        }
        attributeList.addAttributeListener(this.forwardListener);
        attributeList.addAttributeListener(this.updateListener);
    }

    private void createEditorGroup(Composite composite, final String string, String string2, BindableDescriptor bindableDescriptor, Map<String, AttributeDescriptor> map, IAttributeEventProvider iAttributeEventProvider) {
        String string32;
        final Section section = new Section(composite, 18);
        section.setText(string2);
        section.setExpanded(this.getExpansionState(string));
        section.setSeparatorControl((Control)new Label((Composite)section, 258));
        GridLayout gridLayout = GUIFactory.zeroMarginGridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginBottom = 10;
        gridLayout.marginTop = 5;
        Composite composite2 = new Composite((Composite)section, 0);
        composite2.setLayout((Layout)gridLayout);
        AttributeList attributeList = new AttributeList(composite2, bindableDescriptor, map, iAttributeEventProvider, this.currentValues);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        attributeList.setLayoutData(gridData);
        for (String string32 : map.keySet()) {
            this.attributeEditors.put(string32, attributeList);
        }
        attributeList.addAttributeListener(this.forwardListener);
        attributeList.addAttributeListener(this.updateListener);
        section.setClient((Control)composite2);
        string32 = new GridData();
        ((GridData)string32).horizontalAlignment = 4;
        ((GridData)string32).verticalAlignment = 4;
        ((GridData)string32).grabExcessHorizontalSpace = true;
        ((GridData)string32).grabExcessVerticalSpace = false;
        section.setLayoutData((Object)string32);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent expansionEvent) {
                AttributeGroups.this.forceReflow();
                AttributeGroups.this.attributeGroupExpansionState.put(string, section.isExpanded());
            }
        });
        this.attributeGroupSections.put(string, section);
    }

    private boolean getExpansionState(String string) {
        if (!this.attributeGroupExpansionState.containsKey(string)) {
            this.attributeGroupExpansionState.put(string, true);
        }
        return this.attributeGroupExpansionState.containsKey(string);
    }

    @Override
    public void addAttributeListener(IAttributeListener iAttributeListener) {
        this.listeners.add(iAttributeListener);
    }

    @Override
    public void removeAttributeListener(IAttributeListener iAttributeListener) {
        this.listeners.remove(iAttributeListener);
    }

    public void setAttribute(String string, Object object) {
        AttributeList attributeList = this.attributeEditors.get(string);
        if (attributeList != null) {
            attributeList.setAttribute(string, object);
        } else {
            this.forwardListener.valueChanged(new AttributeEvent(this, string, object));
        }
    }

    public void setAttributes(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    private void disposeEditors() {
        HashSet hashSet = Sets.newHashSet(this.attributeEditors.values());
        for (AttributeList attributeList : hashSet) {
            attributeList.removeAttributeListener(this.forwardListener);
        }
        if (!this.mainControl.isDisposed()) {
            Control[] controlArray = this.mainControl.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                AttributeList attributeList;
                attributeList = controlArray[n2];
                if (!attributeList.isDisposed()) {
                    attributeList.dispose();
                }
                ++n2;
            }
        }
        this.attributeEditors.clear();
        this.attributeGroupSections.clear();
    }

    public boolean setFocus() {
        if (this.attributeEditors.containsKey("query")) {
            return this.attributeEditors.get("query").setFocus();
        }
        return false;
    }

    public void dispose() {
        this.disposeEditors();
        this.listeners.clear();
        super.dispose();
    }

    public void setExpanded(boolean bl) {
        assert (Display.getCurrent() != null);
        for (String string : this.attributeGroupSections.keySet()) {
            this.setExpanded(string, bl);
        }
    }

    public void setExpanded(String string, boolean bl) {
        assert (Display.getCurrent() != null);
        this.attributeGroupExpansionState.put(string, bl);
        Section section = this.attributeGroupSections.get(string);
        if (section != null) {
            section.setExpanded(bl);
        }
    }

    public Map<String, Boolean> getExpansionStates() {
        assert (Display.getCurrent() != null);
        return Maps.newHashMap(this.attributeGroupExpansionState);
    }

    public void setExpanded(Map<String, Boolean> map) {
        assert (Display.getCurrent() != null);
        for (Map.Entry<String, Boolean> entry : map.entrySet()) {
            this.setExpanded(entry.getKey(), entry.getValue());
        }
    }

    private class HasEditorPredicate
    implements Predicate<AttributeDescriptor> {
        private HasEditorPredicate() {
        }

        public boolean apply(AttributeDescriptor attributeDescriptor) {
            try {
                Class clazz = ((AttributeGroups)AttributeGroups.this).descriptor.type;
                if (clazz != null && IProcessingComponent.class.isAssignableFrom(clazz)) {
                    EditorFactory.getEditorFor(clazz.asSubclass(IProcessingComponent.class), attributeDescriptor);
                } else {
                    EditorFactory.getEditorFor(null, attributeDescriptor);
                }
                return true;
            }
            catch (EditorNotFoundException editorNotFoundException) {
                return false;
            }
        }
    }
}

