/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import org.carrot2.util.attribute.AttributeDescriptor;
import org.carrot2.util.attribute.AttributeMetadata;
import org.carrot2.workbench.core.WorkbenchCorePlugin;
import org.carrot2.workbench.core.ui.AttributeInfoView;
import org.carrot2.workbench.core.ui.StyledTextContentBuilder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class AttributeInfoTooltip
extends ToolTip {
    private final AttributeDescriptor descriptor;
    private final SelectionListener listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            AttributeInfoTooltip.this.showInView();
        }
    };

    private AttributeInfoTooltip(Control control, AttributeDescriptor attributeDescriptor) {
        super(control, 2, false);
        this.descriptor = attributeDescriptor;
        this.setShift(new Point(-5, -5));
        this.setRespectDisplayBounds(true);
        this.setRespectMonitorBounds(true);
        this.setHideOnMouseDown(false);
    }

    private void showInView() {
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (iWorkbenchPage != null) {
            try {
                IViewPart iViewPart = iWorkbenchPage.findView("org.carrot2.workbench.core.views.attributeInfo");
                if (!iWorkbenchPage.isPartVisible((IWorkbenchPart)iViewPart)) {
                    iViewPart = iWorkbenchPage.showView("org.carrot2.workbench.core.views.attributeInfo");
                }
                ((AttributeInfoView)iViewPart).show(this.descriptor);
                this.hide();
            }
            catch (PartInitException partInitException) {}
        }
    }

    protected boolean shouldCreateToolTip(Event event) {
        boolean bl = super.shouldCreateToolTip(event);
        if (bl && this.isSynchronizedWithView()) {
            UIJob uIJob = new UIJob("Show attribute info"){

                public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                    AttributeInfoTooltip.this.showInView();
                    return Status.OK_STATUS;
                }
            };
            uIJob.setSystem(true);
            uIJob.setPriority(50);
            uIJob.schedule();
            bl = false;
        }
        return bl;
    }

    protected Composite createToolTipContentArea(Event event, Composite composite) {
        Display display = composite.getShell().getDisplay();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = GridLayoutFactory.fillDefaults().spacing(0, 0).margins(2, 2).create();
        composite2.setLayout((Layout)gridLayout);
        StyledText styledText = this.createStyledText(composite2);
        styledText.setBackground(display.getSystemColor(29));
        styledText.setForeground(display.getSystemColor(28));
        if (!this.isSynchronizedWithView()) {
            Label label = new Label(composite2, 258);
            label.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 1024).create());
            Link link = new Link(composite2, 0);
            link.setBackground(display.getSystemColor(29));
            link.setForeground(display.getSystemColor(28));
            link.setText("<a>Show full documentation</a>.");
            link.setLayoutData((Object)GridDataFactory.swtDefaults().align(131072, 0x1000000).create());
            link.addSelectionListener(this.listener);
        }
        composite.setBackground(display.getSystemColor(29));
        composite2.setBackground(display.getSystemColor(29));
        return composite2;
    }

    private boolean isSynchronizedWithView() {
        return WorkbenchCorePlugin.getDefault().getPreferenceStore().getBoolean("attribute-info-view.sync");
    }

    private StyledText createStyledText(Composite composite) {
        StyledText styledText = new StyledText(composite, 72);
        styledText.setLayoutData((Object)GridDataFactory.fillDefaults().minSize(250, -1).hint(300, -1).grab(true, true).create());
        StyledTextContentBuilder styledTextContentBuilder = new StyledTextContentBuilder();
        this.buildContent(styledTextContentBuilder);
        styledText.setText(styledTextContentBuilder.getText());
        styledText.setStyleRanges(styledTextContentBuilder.getStyleRanges());
        return styledText;
    }

    protected void buildContent(StyledTextContentBuilder styledTextContentBuilder) {
        AttributeMetadata attributeMetadata = this.descriptor.metadata;
        styledTextContentBuilder.println("Attribute:", 1).print("    ").println(attributeMetadata != null ? attributeMetadata.getLabelOrTitle() : this.descriptor.key).println();
        styledTextContentBuilder.println("Availability:", 1).print("    ").print(this.descriptor.requiredAttribute ? "required" : "optional");
        if (this.descriptor.defaultValue != null) {
            styledTextContentBuilder.println().println().println("Default value:", 1).print("    ").print(this.descriptor.defaultValue.toString());
        }
    }

    public static void attach(Control control, AttributeDescriptor attributeDescriptor) {
        new AttributeInfoTooltip(control, attributeDescriptor);
    }
}

