/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import com.google.common.collect.Maps;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeInstance;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Processing;
import org.carrot2.util.attribute.AttributeDescriptor;
import org.carrot2.workbench.core.WorkbenchCorePlugin;
import org.carrot2.workbench.core.helpers.ActionDelegateProxy;
import org.carrot2.workbench.core.helpers.DisposeBin;
import org.carrot2.workbench.core.helpers.Utils;
import org.carrot2.workbench.core.ui.BrowserFacade;
import org.carrot2.workbench.core.ui.actions.AttributeInfoSyncAction;
import org.carrot2.workbench.velocity.VelocityInitializer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class AttributeInfoView
extends ViewPart {
    public static final String ID = "org.carrot2.workbench.core.views.attributeInfo";
    private static final String TEMPLATES_PREFIX = "/templates/";
    private static final String TEMPLATE_ATTR_INFO = "attribute-descriptor.vm";
    private DisposeBin bin = new DisposeBin();
    private Browser browser;
    private static RuntimeInstance velocity;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeInfoView() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            if (velocity == null) {
                velocity = VelocityInitializer.createInstance("org.carrot2.workbench.core", TEMPLATES_PREFIX);
            }
        }
    }

    public void init(IViewSite iViewSite) throws PartInitException {
        super.init(iViewSite);
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.createToolbar(iActionBars.getToolBarManager());
        iActionBars.updateActionBars();
    }

    private void createToolbar(IToolBarManager iToolBarManager) {
        ActionDelegateProxy actionDelegateProxy = new ActionDelegateProxy((IActionDelegate)new AttributeInfoSyncAction(), 2);
        actionDelegateProxy.setImageDescriptor(WorkbenchCorePlugin.getImageDescriptor("icons/help-sync.gif"));
        actionDelegateProxy.setToolTipText("Update when attribute tooltip is shown.");
        iToolBarManager.add((IAction)actionDelegateProxy);
    }

    public void createPartControl(Composite composite) {
        this.browser = BrowserFacade.createNew(composite, 0);
        this.bin.add((Widget)this.browser);
        this.clear();
    }

    public void show(AttributeDescriptor attributeDescriptor) {
        VelocityContext velocityContext = VelocityInitializer.createContext();
        velocityContext.put("descriptor", (Object)attributeDescriptor);
        HashMap hashMap = Maps.newHashMap();
        this.copyFields(hashMap, "", attributeDescriptor);
        velocityContext.put("fields", (Object)hashMap);
        hashMap.put("processingAttribute", attributeDescriptor.getAnnotation(Processing.class) != null);
        hashMap.put("initAttribute", attributeDescriptor.getAnnotation(Init.class) != null);
        StringWriter stringWriter = new StringWriter();
        try {
            Template template = velocity.getTemplate(TEMPLATE_ATTR_INFO, "UTF-8");
            template.merge((Context)velocityContext, (Writer)stringWriter);
        }
        catch (Exception exception) {
            Utils.logError("Error while loading template", exception, true);
            return;
        }
        this.browser.setText(stringWriter.toString());
    }

    public void clear() {
        VelocityContext velocityContext = VelocityInitializer.createContext();
        StringWriter stringWriter = new StringWriter();
        try {
            Template template = velocity.getTemplate(TEMPLATE_ATTR_INFO, "UTF-8");
            template.merge((Context)velocityContext, (Writer)stringWriter);
        }
        catch (Exception exception) {
            Utils.logError("Error while loading template", exception, true);
            return;
        }
        this.browser.setText(stringWriter.toString());
    }

    private void copyFields(Map<String, Object> map, String string, Object object) {
        try {
            Field[] fieldArray = object.getClass().getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                map.put(field.getName(), field.get(object));
                ++n2;
            }
        }
        catch (IllegalAccessException illegalAccessException) {}
    }

    public void setFocus() {
        if (this.browser != null) {
            this.browser.setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.bin.dispose();
    }
}

