/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.carrot2.core.IProcessingComponent;
import org.carrot2.util.attribute.AttributeDescriptor;
import org.carrot2.util.attribute.BindableDescriptor;
import org.carrot2.workbench.core.helpers.GUIFactory;
import org.carrot2.workbench.core.helpers.Utils;
import org.carrot2.workbench.core.ui.AttributeInfoTooltip;
import org.carrot2.workbench.core.ui.InvalidStateDecorationListener;
import org.carrot2.workbench.editors.AttributeEditorInfo;
import org.carrot2.workbench.editors.ForwardingAttributeListener;
import org.carrot2.workbench.editors.IAttributeEditor;
import org.carrot2.workbench.editors.IAttributeEventProvider;
import org.carrot2.workbench.editors.IAttributeListener;
import org.carrot2.workbench.editors.factory.EditorFactory;
import org.carrot2.workbench.editors.factory.EditorNotFoundException;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class AttributeList
extends Composite
implements IAttributeEventProvider {
    public static final int SPACE_BEFORE_LABEL = 5;
    public static final String ENABLE_VALIDATION_OVERLAYS = "enable.validation.overlays";
    private final Map<String, AttributeDescriptor> attributeDescriptors;
    private Map<String, IAttributeEditor> editors = Maps.newHashMap();
    private Class<? extends IProcessingComponent> componentClazz;
    private final List<IAttributeListener> listeners = new CopyOnWriteArrayList<IAttributeListener>();
    private final IAttributeListener forwardListener = new ForwardingAttributeListener(this.listeners);
    private BindableDescriptor bindable;
    private IAttributeEventProvider globalEventsProvider;

    public AttributeList(Composite composite, BindableDescriptor bindableDescriptor, Map<String, AttributeDescriptor> map, IAttributeEventProvider iAttributeEventProvider, Map<String, Object> map2) {
        super(composite, 0);
        this.bindable = bindableDescriptor;
        this.globalEventsProvider = iAttributeEventProvider;
        this.attributeDescriptors = map;
        Class clazz = bindableDescriptor.type;
        if (clazz != null && IProcessingComponent.class.isAssignableFrom(clazz)) {
            this.componentClazz = clazz;
        }
        this.createComponents(map2);
    }

    public void setAttribute(String string, Object object) {
        IAttributeEditor iAttributeEditor = this.editors.get(string);
        if (iAttributeEditor != null) {
            iAttributeEditor.setValue(object);
        }
    }

    @Override
    public void addAttributeListener(IAttributeListener iAttributeListener) {
        this.listeners.add(iAttributeListener);
    }

    @Override
    public void removeAttributeListener(IAttributeListener iAttributeListener) {
        this.listeners.remove(iAttributeListener);
    }

    public void dispose() {
        for (IAttributeEditor iAttributeEditor : this.editors.values()) {
            iAttributeEditor.removeAttributeListener(this.forwardListener);
        }
        super.dispose();
    }

    public boolean setFocus() {
        if (this.editors.containsKey("query")) {
            this.editors.get("query").setFocus();
            return true;
        }
        return false;
    }

    private void createComponents(Map<String, Object> map) {
        Object object;
        Object object2;
        Object object3;
        Locale locale = Locale.getDefault();
        final HashMap hashMap = Maps.newHashMap();
        for (Map.Entry<String, AttributeDescriptor> object42 : this.attributeDescriptors.entrySet()) {
            hashMap.put(object42.getKey(), this.getLabel(object42.getValue()).toLowerCase(locale));
        }
        final Collator collator = Collator.getInstance(locale);
        ArrayList arrayList = Lists.newArrayList(hashMap.keySet());
        Collections.sort(arrayList, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return collator.compare((String)hashMap.get(string), (String)hashMap.get(string2));
            }
        });
        this.editors = Maps.newHashMap();
        HashMap hashMap2 = Maps.newHashMap();
        int n = 1;
        GridDataFactory gridDataFactory = arrayList.iterator();
        while (gridDataFactory.hasNext()) {
            object3 = (String)gridDataFactory.next();
            AttributeDescriptor bl = this.attributeDescriptors.get(object3);
            object2 = null;
            try {
                object2 = EditorFactory.getEditorFor(this.componentClazz, bl);
                object = object2.init(this.bindable, bl, this.globalEventsProvider, map);
                hashMap2.put(object3, object);
                n = Math.max(n, ((AttributeEditorInfo)object).columns);
            }
            catch (EditorNotFoundException editorNotFoundException) {
                Utils.logError("No editor for attribute: " + bl.key + " (class: " + bl.type + ")", false);
                object2 = null;
            }
            this.editors.put((String)object3, (IAttributeEditor)object2);
        }
        object3 = GUIFactory.zeroMarginGridLayout();
        object3.makeColumnsEqualWidth = false;
        object3.numColumns = n;
        this.setLayout((Layout)object3);
        gridDataFactory = GridDataFactory.fillDefaults().span(n, 1);
        boolean bl = true;
        object = arrayList.iterator();
        while (object.hasNext()) {
            object2 = (String)object.next();
            AttributeDescriptor attributeDescriptor = this.attributeDescriptors.get(object2);
            IAttributeEditor iAttributeEditor = this.editors.get(object2);
            AttributeEditorInfo attributeEditorInfo = (AttributeEditorInfo)hashMap2.get(object2);
            if (iAttributeEditor == null) continue;
            Object object4 = map != null && map.get(object2) != null ? map.get(object2) : this.attributeDescriptors.get((Object)object2).defaultValue;
            if (!attributeEditorInfo.displaysOwnLabel) {
                Label label = new Label((Composite)this, 16384);
                GridData gridData = gridDataFactory.create();
                if (!bl) {
                    gridData.verticalIndent = 5;
                }
                label.setLayoutData((Object)gridData);
                label.setText(String.valueOf(this.getLabel(attributeDescriptor)) + (attributeDescriptor.requiredAttribute ? " (required)" : ""));
                this.addValidationOverlay(attributeDescriptor, iAttributeEditor, object4, (Control)label);
                AttributeInfoTooltip.attach((Control)label, attributeDescriptor);
            }
            iAttributeEditor.createEditor(this, n);
            iAttributeEditor.setValue(object4);
            this.editors.put(iAttributeEditor.getAttributeKey(), iAttributeEditor);
            iAttributeEditor.addAttributeListener(this.forwardListener);
            bl = false;
        }
    }

    private void addValidationOverlay(AttributeDescriptor attributeDescriptor, final IAttributeEditor iAttributeEditor, Object object, Control control) {
        final ControlDecoration controlDecoration = new ControlDecoration(control, 17408);
        controlDecoration.hide();
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        controlDecoration.setImage(fieldDecoration.getImage());
        controlDecoration.setDescriptionText("Invalid value");
        final InvalidStateDecorationListener invalidStateDecorationListener = new InvalidStateDecorationListener(controlDecoration, attributeDescriptor, object);
        this.globalEventsProvider.addAttributeListener(invalidStateDecorationListener);
        iAttributeEditor.addAttributeListener(invalidStateDecorationListener);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                AttributeList.this.globalEventsProvider.removeAttributeListener(invalidStateDecorationListener);
                iAttributeEditor.removeAttributeListener(invalidStateDecorationListener);
                controlDecoration.dispose();
            }
        });
    }

    private String getLabel(AttributeDescriptor attributeDescriptor) {
        String string = null;
        if (attributeDescriptor.metadata != null) {
            string = attributeDescriptor.metadata.getLabelOrTitle();
        }
        if (string == null) {
            string = "(no label available)";
        }
        return string;
    }
}

