/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import java.util.Collections;
import org.carrot2.util.attribute.BindableDescriptor;
import org.carrot2.workbench.core.WorkbenchActionFactory;
import org.carrot2.workbench.core.WorkbenchCorePlugin;
import org.carrot2.workbench.core.helpers.GUIFactory;
import org.carrot2.workbench.core.helpers.SimpleXmlMemento;
import org.carrot2.workbench.core.ui.AttributeGroups;
import org.carrot2.workbench.core.ui.AttributeViewMemento;
import org.carrot2.workbench.core.ui.PropertyChangeListenerAdapter;
import org.carrot2.workbench.core.ui.ResetToDefaultsAction;
import org.carrot2.workbench.core.ui.ResetToFactoryDefaultsAction;
import org.carrot2.workbench.core.ui.SaveAlgorithmAttributesAction;
import org.carrot2.workbench.core.ui.SearchEditor;
import org.carrot2.workbench.core.ui.SearchInput;
import org.carrot2.workbench.core.ui.SetNewDefaultsAction;
import org.carrot2.workbench.core.ui.actions.GroupingMethodAction;
import org.carrot2.workbench.core.ui.widgets.CScrolledComposite;
import org.carrot2.workbench.editors.AttributeEvent;
import org.carrot2.workbench.editors.AttributeListenerAdapter;
import org.carrot2.workbench.editors.IAttributeListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.Page;

final class AttributeViewPage
extends Page {
    private static final String PREFERENCE_KEY_EXPANSION_STATE = String.valueOf(AttributeViewPage.class.getName()) + ".expansionState";
    private final SearchEditor editor;
    private AttributeGroups attributeEditors;
    private IAttributeListener editorToViewSync;
    private AttributeListenerAdapter viewToEditorSync;
    private Composite mainControl;

    public AttributeViewPage(SearchEditor searchEditor) {
        this.editor = searchEditor;
    }

    public void makeContributions(IMenuManager iMenuManager, IToolBarManager iToolBarManager, IStatusLineManager iStatusLineManager) {
        super.makeContributions(iMenuManager, iToolBarManager, iStatusLineManager);
        this.createToolbarActions(iToolBarManager);
        this.createMenuActions(iMenuManager);
    }

    private void createMenuActions(IMenuManager iMenuManager) {
        SearchInput searchInput = this.editor.getSearchResult().getInput();
        iMenuManager.add((IAction)new SetNewDefaultsAction(searchInput));
        iMenuManager.add((IAction)new ResetToDefaultsAction(searchInput));
        iMenuManager.add((IAction)new ResetToFactoryDefaultsAction(searchInput));
    }

    private void createToolbarActions(IToolBarManager iToolBarManager) {
        IWorkbenchWindow iWorkbenchWindow = this.getSite().getWorkbenchWindow();
        iToolBarManager.add((IAction)WorkbenchActionFactory.AUTO_UPDATE_ACTION.create(iWorkbenchWindow));
        iToolBarManager.add((IAction)new GroupingMethodAction("attributes-view.layout"));
        SaveAlgorithmAttributesAction saveAlgorithmAttributesAction = new SaveAlgorithmAttributesAction(this.editor.getSearchResult().getInput());
        iToolBarManager.add((IAction)saveAlgorithmAttributesAction);
    }

    private void updateGroupingState(BindableDescriptor.GroupingMethod groupingMethod) {
        this.attributeEditors.setGrouping(groupingMethod);
        this.attributeEditors.setAttributes(this.editor.getSearchResult().getInput().getAttributeValueSet().getAttributeValues());
    }

    public void createControl(Composite composite) {
        final IPreferenceStore iPreferenceStore = WorkbenchCorePlugin.getDefault().getPreferenceStore();
        iPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)new PropertyChangeListenerAdapter("attributes-view.layout"){

            @Override
            protected void propertyChangeFiltered(PropertyChangeEvent propertyChangeEvent) {
                AttributeViewPage.this.updateGroupingState(BindableDescriptor.GroupingMethod.valueOf((String)iPreferenceStore.getString("attributes-view.layout")));
            }
        });
        CScrolledComposite cScrolledComposite = new CScrolledComposite(composite, 768);
        Composite composite2 = GUIFactory.createSpacer((Composite)cScrolledComposite);
        cScrolledComposite.setContent((Control)composite2);
        cScrolledComposite.setExpandHorizontal(true);
        cScrolledComposite.setExpandVertical(false);
        BindableDescriptor.GroupingMethod groupingMethod = BindableDescriptor.GroupingMethod.valueOf((String)iPreferenceStore.getString("attributes-view.layout"));
        this.attributeEditors = new AttributeGroups(composite2, this.editor.getAlgorithmDescriptor(), groupingMethod, null, Collections.emptyMap());
        this.attributeEditors.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
        this.attributeEditors.setAttribute("enable.validation.overlays", true);
        this.restoreGlobalState();
        this.mainControl = cScrolledComposite;
        cScrolledComposite.reflow(true);
        this.updateGroupingState(groupingMethod);
        this.registerListeners();
    }

    void saveGlobalState() {
        assert (Display.getCurrent() != null);
        AttributeViewMemento attributeViewMemento = new AttributeViewMemento();
        attributeViewMemento.sectionsExpansionState = this.attributeEditors.getExpansionStates();
        SimpleXmlMemento.toPreferenceStore(PREFERENCE_KEY_EXPANSION_STATE, attributeViewMemento);
    }

    void restoreGlobalState() {
        assert (Display.getCurrent() != null);
        AttributeViewMemento attributeViewMemento = SimpleXmlMemento.fromPreferenceStore(AttributeViewMemento.class, PREFERENCE_KEY_EXPANSION_STATE);
        if (attributeViewMemento != null) {
            this.attributeEditors.setExpanded(attributeViewMemento.sectionsExpansionState);
        }
    }

    public Control getControl() {
        return this.mainControl;
    }

    public void setFocus() {
        this.attributeEditors.setFocus();
    }

    public void dispose() {
        this.unregisterListeners();
        this.attributeEditors.dispose();
        super.dispose();
    }

    private void registerListeners() {
        this.viewToEditorSync = new AttributeListenerAdapter(){

            @Override
            public void valueChanged(AttributeEvent attributeEvent) {
                AttributeViewPage.this.editor.getSearchResult().getInput().setAttribute(attributeEvent.key, attributeEvent.value);
            }
        };
        this.attributeEditors.addAttributeListener(this.viewToEditorSync);
        this.editorToViewSync = new AttributeListenerAdapter(){

            @Override
            public void valueChanged(AttributeEvent attributeEvent) {
                AttributeViewPage.this.attributeEditors.removeAttributeListener(AttributeViewPage.this.viewToEditorSync);
                AttributeViewPage.this.attributeEditors.setAttribute(attributeEvent.key, attributeEvent.value);
                AttributeViewPage.this.attributeEditors.addAttributeListener(AttributeViewPage.this.viewToEditorSync);
            }
        };
        this.editor.getSearchResult().getInput().addAttributeListener(this.editorToViewSync);
    }

    private void unregisterListeners() {
        this.editor.getSearchResult().getInput().removeAttributeListener(this.editorToViewSync);
        this.attributeEditors.removeAttributeListener(this.viewToEditorSync);
    }
}

