/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.mutable.MutableInt;
import org.carrot2.core.Controller;
import org.carrot2.core.ProcessingComponentDescriptor;
import org.carrot2.util.CloseableUtils;
import org.carrot2.workbench.core.WorkbenchCorePlugin;
import org.carrot2.workbench.core.helpers.Utils;
import org.carrot2.workbench.core.ui.BenchmarkSettings;
import org.carrot2.workbench.core.ui.BenchmarkStatistics;
import org.carrot2.workbench.core.ui.SearchInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

final class BenchmarkJob
extends Job {
    private final SearchInput input;
    final BenchmarkSettings settings;
    public volatile BenchmarkStatistics statistics;
    public PrintWriter logWriter;
    public File logFile;

    public BenchmarkJob(SearchInput searchInput, BenchmarkSettings benchmarkSettings) {
        super("Benchmarking...");
        this.settings = benchmarkSettings;
        this.input = searchInput;
        this.statistics = new BenchmarkStatistics(benchmarkSettings.warmupRounds, benchmarkSettings.benchmarksRounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor iProgressMonitor) {
        Object object;
        this.prepareLogs();
        this.pushLogHeaders();
        int n = this.settings.getTotalRounds();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        MutableInt mutableInt = new MutableInt(n);
        Callable<Long> callable = this.createBenchmarkRunner();
        Thread[] threadArray = this.createBenchmarkThreads(countDownLatch, mutableInt, iProgressMonitor, callable);
        iProgressMonitor.beginTask("Running...", n);
        countDownLatch.countDown();
        Thread[] threadArray2 = threadArray;
        int n2 = threadArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = threadArray2[n3];
            try {
                ((Thread)object).join();
            }
            catch (InterruptedException interruptedException) {
                iProgressMonitor.setCanceled(true);
            }
            ++n3;
        }
        object = this.logWriter;
        synchronized (object) {
            if (iProgressMonitor.isCanceled()) {
                this.logWriter.println("# (cancelled)");
            } else {
                this.logWriter.println("# Statistics:");
                this.logWriter.println("# " + this.statistics.toString());
            }
        }
        iProgressMonitor.done();
        CloseableUtils.close((Closeable)this.logWriter);
        return Status.OK_STATUS;
    }

    private Callable<Long> createBenchmarkRunner() {
        WorkbenchCorePlugin workbenchCorePlugin = WorkbenchCorePlugin.getDefault();
        final Controller controller = workbenchCorePlugin.getController();
        final ProcessingComponentDescriptor processingComponentDescriptor = workbenchCorePlugin.getComponent(this.input.getSourceId());
        final ProcessingComponentDescriptor processingComponentDescriptor2 = workbenchCorePlugin.getComponent(this.input.getAlgorithmId());
        final HashMap hashMap = Maps.newHashMap((Map)this.input.getAttributeValueSet().getAttributeValues());
        return new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                long l = System.currentTimeMillis();
                controller.process(hashMap, new String[]{processingComponentDescriptor.getId(), processingComponentDescriptor2.getId()});
                return System.currentTimeMillis() - l;
            }
        };
    }

    private Thread[] createBenchmarkThreads(CountDownLatch countDownLatch, final MutableInt mutableInt, final IProgressMonitor iProgressMonitor, final Callable<Long> callable) {
        Thread[] threadArray = new Thread[this.settings.threads];
        int n = 0;
        while (n < this.settings.threads) {
            final int n2 = n + 1;
            threadArray[n] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (!Thread.currentThread().isInterrupted()) {
                        long l;
                        int n;
                        int n22 = BenchmarkJob.this.settings.warmupRounds + BenchmarkJob.this.settings.benchmarksRounds;
                        PrintWriter printWriter = BenchmarkJob.this.logWriter;
                        synchronized (printWriter) {
                            n = mutableInt.intValue();
                            if (n == 0 || iProgressMonitor.isCanceled()) {
                                return;
                            }
                            mutableInt.decrement();
                        }
                        try {
                            l = (Long)callable.call();
                        }
                        catch (Exception exception) {
                            Utils.logError(exception, false);
                            l = 0L;
                        }
                        PrintWriter printWriter2 = BenchmarkJob.this.logWriter;
                        synchronized (printWriter2) {
                            BenchmarkJob.this.logWriter.format(Locale.ENGLISH, "%2d  %4d  %8.03f\n", n2, n22 - n, (double)l / 1000.0);
                            BenchmarkJob.this.statistics = BenchmarkJob.this.statistics.update((int)l);
                            iProgressMonitor.worked(1);
                        }
                    }
                }
            };
            threadArray[n].setName("benchmark-" + n);
            threadArray[n].setPriority(this.settings.priority.threadPriority);
            threadArray[n].start();
            ++n;
        }
        return threadArray;
    }

    private void pushLogHeaders() {
        if (this.logWriter == null) {
            return;
        }
        this.logWriter.println("# Benchmarking log.");
        this.logWriter.println("# ");
        this.logWriter.println("# Source: " + this.input.getSourceId());
        this.logWriter.println("# Algorithm: " + this.input.getAlgorithmId());
        this.logWriter.println("# Query: " + this.input.getAttribute("query"));
        this.logWriter.println("# Results: " + this.input.getAttribute("results"));
        this.logWriter.println("# ");
        this.logWriter.println("# JVM: " + SystemUtils.JAVA_VM_NAME + ", " + SystemUtils.JAVA_VM_VERSION + ", " + SystemUtils.JAVA_VM_INFO + ", " + SystemUtils.JAVA_VM_VENDOR);
        this.logWriter.println("# OS arch: " + SystemUtils.OS_ARCH + ", name: " + SystemUtils.OS_NAME + ", version: " + SystemUtils.OS_VERSION);
        this.logWriter.println("# ");
        this.logWriter.println("# Benchmark rounds: " + this.settings.benchmarksRounds);
        this.logWriter.println("# Warmup rounds: " + this.settings.warmupRounds);
        this.logWriter.println("# Threads: " + this.settings.threads + " (available CPUs or cores: " + Runtime.getRuntime().availableProcessors() + "), " + "running at " + (Object)((Object)this.settings.priority) + " priority.");
        this.logWriter.println("# ");
        this.logWriter.println("# thread_id  round_number  time[s]");
    }

    private void prepareLogs() {
        String string = String.format(Locale.ENGLISH, "benchmark_%1$tF_%1$tH-%1$tM-%1$tS.txt", new Date());
        try {
            this.logFile = this.settings.logDirectory != null ? new File(this.settings.logDirectory, string) : new File(System.getProperty("java.io.tmpdir", "."), string);
            this.logWriter = new PrintWriter(this.logFile, "UTF-8");
        }
        catch (IOException iOException) {
            Utils.logError(iOException, false);
            this.logFile = null;
            this.logWriter = null;
        }
    }
}

