/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import java.io.File;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.Required;
import org.carrot2.util.attribute.constraint.IntRange;
import org.carrot2.util.attribute.constraint.IsDirectory;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Bindable
@Root(name="benchmark-settings")
public class BenchmarkSettings {
    private static final String ROUNDS = "Rounds";
    private static final String THREADS = "Threads";
    private static final String LOGGING = "Logging";
    @Input
    @Attribute
    @IntRange(min=1, max=1000)
    @Element
    @Label(value="Benchmark rounds")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Rounds")
    public int benchmarksRounds = 75;
    @Input
    @IntRange(min=0, max=200)
    @Attribute
    @Element
    @Label(value="Warmup rounds")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Rounds")
    public int warmupRounds = 25;
    @Required
    @Input
    @Attribute
    @Element
    @Label(value="Thread priority")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Threads")
    public ThreadPriority priority = ThreadPriority.NORMAL;
    @Required
    @Input
    @Attribute
    @IntRange(min=1, max=8)
    @Element
    @Label(value="Number of concurrent threads")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Threads")
    public int threads = 1;
    @Input
    @Attribute
    @IsDirectory(mustExist=true)
    @Element(required=false)
    @Label(value="Log directory")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Logging")
    public File logDirectory;
    @Input
    @Attribute
    @Element
    @Label(value="Open log in editor")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Logging")
    public boolean openLogsInEditor;

    public int getTotalRounds() {
        return this.benchmarksRounds + this.warmupRounds;
    }

    public static enum ThreadPriority {
        HIGH(10),
        NORMAL(5),
        LOW(4),
        IDLE(1);

        public final int threadPriority;

        private ThreadPriority(int n2) {
            this.threadPriority = n2;
        }
    }
}

