/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import java.util.Locale;

public final class BenchmarkStatistics {
    public final double avg;
    public final double stdDev;
    public final int min;
    public final int max;
    private final long sum;
    private final long sumSquares;
    public final int benchmarkRounds;
    public final int warmupRounds;
    public final int round;

    public BenchmarkStatistics(int n, int n2) {
        this(n, n2, 0, 0.0, 0.0, 0, 0, 0L, 0L);
    }

    private BenchmarkStatistics(int n, int n2, int n3, double d, double d2, int n4, int n5, long l, long l2) {
        this.warmupRounds = n;
        this.benchmarkRounds = n2;
        this.round = n3;
        this.avg = d;
        this.stdDev = d2;
        this.min = n4;
        this.max = n5;
        this.sum = l;
        this.sumSquares = l2;
    }

    public BenchmarkStatistics update(int n) {
        int n2 = this.round + 1;
        if (this.round >= this.warmupRounds) {
            n2 -= this.warmupRounds;
        }
        long l = this.sum + (long)n;
        long l2 = this.sumSquares + (long)(n * n);
        if (this.round == this.warmupRounds) {
            l = n;
            l2 = n * n;
        }
        int n3 = Math.min(this.min, n);
        int n4 = Math.max(this.max, n);
        double d = (double)l / (double)n2;
        double d2 = Math.sqrt((double)l2 / (double)n2 - d * d);
        if (this.round == this.warmupRounds || this.round == 0) {
            n3 = n;
            n4 = n;
        }
        return new BenchmarkStatistics(this.warmupRounds, this.benchmarkRounds, this.round + 1, d, d2, n3, n4, l, l2);
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "avg: %.3f sec., stddev: %.3f sec., min: %.3f sec., max: %.3f sec.\n", this.avg / 1000.0, this.stdDev / 1000.0, (double)this.min / 1000.0, (double)this.max / 1000.0);
    }
}

