/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.carrot2.util.attribute.AttributeBinder;
import org.carrot2.util.attribute.BindableDescriptor;
import org.carrot2.util.attribute.BindableDescriptorBuilder;
import org.carrot2.util.attribute.Input;
import org.carrot2.workbench.core.helpers.GUIFactory;
import org.carrot2.workbench.core.helpers.SimpleXmlMemento;
import org.carrot2.workbench.core.helpers.Utils;
import org.carrot2.workbench.core.ui.AttributeGroups;
import org.carrot2.workbench.core.ui.BenchmarkSettings;
import org.carrot2.workbench.core.ui.BenchmarkViewMemento;
import org.carrot2.workbench.core.ui.BenchmarkViewPage;
import org.carrot2.workbench.core.ui.PageBookViewBase;
import org.carrot2.workbench.core.ui.SearchEditor;
import org.carrot2.workbench.core.ui.widgets.CScrolledComposite;
import org.carrot2.workbench.editors.AttributeEvent;
import org.carrot2.workbench.editors.AttributeListenerAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public final class BenchmarkView
extends PageBookViewBase {
    public static final String ID = "org.carrot2.workbench.core.views.benchmark";
    private final BenchmarkSettings benchmarkSettings = new BenchmarkSettings();
    private CScrolledComposite mainControl;
    private AttributeGroups attributeGroups;
    private BenchmarkViewMemento restoreState;

    public void createPartControl(Composite composite) {
        CScrolledComposite cScrolledComposite = new CScrolledComposite(composite, 768);
        cScrolledComposite.setExpandHorizontal(true);
        cScrolledComposite.setExpandVertical(true);
        this.mainControl = cScrolledComposite;
        Composite composite2 = GUIFactory.createSpacer((Composite)cScrolledComposite);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = LayoutConstants.getSpacing().y;
        cScrolledComposite.setContent((Control)composite2);
        super.createPartControl(composite2);
        this.getPageBook().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.createSeparator(composite2);
        this.createSettingsPanel(composite2);
        this.restoreState();
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        super.showPageRec(pageRec);
        this.mainControl.reflow(true);
    }

    @Override
    protected IPage createDefaultPage(PageBook pageBook) {
        MessagePage messagePage = new MessagePage();
        messagePage.setMessage("No active search result.");
        this.initPage((IPageBookViewPage)messagePage);
        messagePage.createControl((Composite)pageBook);
        return messagePage;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart iWorkbenchPart) {
        SearchEditor searchEditor = (SearchEditor)iWorkbenchPart;
        BenchmarkViewPage benchmarkViewPage = new BenchmarkViewPage(searchEditor, this);
        this.initPage((IPageBookViewPage)benchmarkViewPage);
        benchmarkViewPage.createControl((Composite)this.getPageBook());
        return new PageBookView.PageRec(iWorkbenchPart, (IPage)benchmarkViewPage);
    }

    @Override
    protected boolean isImportant(IWorkbenchPart iWorkbenchPart) {
        return iWorkbenchPart instanceof SearchEditor;
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        try {
            if (iMemento != null) {
                this.restoreState = SimpleXmlMemento.getChild(BenchmarkViewMemento.class, iMemento);
            }
        }
        catch (IOException iOException) {
            Utils.logError(iOException, false);
        }
    }

    public void saveState(IMemento iMemento) {
        super.saveState(iMemento);
        try {
            BenchmarkViewMemento benchmarkViewMemento = new BenchmarkViewMemento();
            benchmarkViewMemento.settings = this.benchmarkSettings;
            benchmarkViewMemento.sectionsExpansionState = this.attributeGroups.getExpansionStates();
            SimpleXmlMemento.addChild(iMemento, benchmarkViewMemento);
        }
        catch (IOException iOException) {
            Utils.logError(iOException, false);
        }
    }

    private void restoreState() {
        if (this.restoreState == null) {
            return;
        }
        try {
            HashMap hashMap = Maps.newHashMap();
            AttributeBinder.get((Object)this.restoreState.settings, (Map)hashMap, (Class[])new Class[]{Input.class});
            this.attributeGroups.setAttributes(hashMap);
            this.attributeGroups.setExpanded(this.restoreState.sectionsExpansionState);
        }
        catch (Exception exception) {
            Utils.logError(exception, false);
        }
    }

    private Control createSettingsPanel(Composite composite) {
        BindableDescriptor bindableDescriptor = BindableDescriptorBuilder.buildDescriptor((Object)this.benchmarkSettings);
        this.attributeGroups = new AttributeGroups(composite, bindableDescriptor, BindableDescriptor.GroupingMethod.GROUP, null, bindableDescriptor.getDefaultValues());
        this.attributeGroups.setLayoutData(GridDataFactory.fillDefaults().grab(true, false).create());
        this.attributeGroups.addAttributeListener(new AttributeListenerAdapter(){

            @Override
            public void valueChanged(AttributeEvent attributeEvent) {
                try {
                    HashMap hashMap = Maps.newHashMap();
                    hashMap.put(attributeEvent.key, attributeEvent.value);
                    AttributeBinder.set((Object)BenchmarkView.this.benchmarkSettings, (Map)hashMap, (Class[])new Class[]{Input.class});
                }
                catch (InstantiationException instantiationException) {
                    Utils.logError(instantiationException, true);
                }
            }
        });
        this.attributeGroups.setExpanded(false);
        return this.attributeGroups;
    }

    private void createSeparator(Composite composite) {
        Label label = new Label(composite, 258);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
    }

    BenchmarkSettings getCurrentSettings() {
        BenchmarkSettings benchmarkSettings = new BenchmarkSettings();
        try {
            HashMap hashMap = Maps.newHashMap();
            AttributeBinder.get((Object)this.benchmarkSettings, (Map)hashMap, (Class[])new Class[]{Input.class});
            AttributeBinder.set((Object)benchmarkSettings, (Map)hashMap, (Class[])new Class[]{Input.class});
        }
        catch (Exception exception) {
            Utils.logError(exception, false);
        }
        return benchmarkSettings;
    }
}

