/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import java.util.Locale;
import org.carrot2.workbench.core.helpers.Utils;
import org.carrot2.workbench.core.ui.BenchmarkJob;
import org.carrot2.workbench.core.ui.BenchmarkStatistics;
import org.carrot2.workbench.core.ui.BenchmarkView;
import org.carrot2.workbench.core.ui.SearchEditor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.internal.browser.WebBrowserEditorInput;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.progress.UIJob;

final class BenchmarkViewPage
extends Page {
    private static final String START_TEXT = "Start";
    private static final String STOP_TEXT = "Stop";
    private final SearchEditor editor;
    private Control mainControl;
    private Label avgTimeLabel;
    private Label minTimeLabel;
    private Label maxTimeLabel;
    private Label stddevLabel;
    private Label statusLabel;
    private Button startButton;
    private ProgressBar progressBar;
    private BenchmarkJob benchmarkJob;
    private final BenchmarkView benchmarkView;
    private Job benchmarkStatusUpdateJob = new UIJob("Benchmark update"){
        {
            this.setPriority(20);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            if (BenchmarkViewPage.this.benchmarkJob != null) {
                BenchmarkViewPage.this.updateBenchmark(((BenchmarkViewPage)BenchmarkViewPage.this).benchmarkJob.statistics);
                this.schedule(1000L);
            }
            return Status.OK_STATUS;
        }
    };
    private IJobChangeListener jobListener = new JobChangeAdapter(){

        public void done(IJobChangeEvent iJobChangeEvent) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BenchmarkViewPage.this.updateBenchmark(((BenchmarkViewPage)(this).BenchmarkViewPage.this).benchmarkJob.statistics);
                    BenchmarkViewPage.this.endBenchmark();
                }
            });
        }
    };

    private void startBenchmark() {
        assert (Display.getCurrent() != null);
        this.startButton.setText(STOP_TEXT);
        this.benchmarkJob = new BenchmarkJob(this.editor.getSearchResult().getInput(), this.benchmarkView.getCurrentSettings());
        this.updateBenchmark(this.benchmarkJob.statistics);
        this.benchmarkJob.addJobChangeListener(this.jobListener);
        this.benchmarkJob.schedule();
        this.benchmarkStatusUpdateJob.schedule();
    }

    private void updateBenchmark(BenchmarkStatistics benchmarkStatistics) {
        assert (Display.getCurrent() != null);
        if (benchmarkStatistics.round == 0) {
            this.progressBar.setMaximum(benchmarkStatistics.benchmarkRounds + benchmarkStatistics.warmupRounds);
            this.progressBar.setMinimum(0);
            this.progressBar.setSelection(0);
            this.avgTimeLabel.setText("");
            this.stddevLabel.setText("");
            this.minTimeLabel.setText("");
            this.maxTimeLabel.setText("");
            this.statusLabel.setText("waiting for data");
        } else {
            this.progressBar.setSelection(benchmarkStatistics.round);
            this.avgTimeLabel.setText(this.formatSeconds(benchmarkStatistics.avg));
            this.stddevLabel.setText(this.formatSeconds(benchmarkStatistics.stdDev));
            this.minTimeLabel.setText(this.formatSeconds(benchmarkStatistics.min));
            this.maxTimeLabel.setText(this.formatSeconds(benchmarkStatistics.max));
            String string = benchmarkStatistics.round < benchmarkStatistics.warmupRounds ? "warmup" : (benchmarkStatistics.round == benchmarkStatistics.warmupRounds + benchmarkStatistics.benchmarkRounds ? "done" : "benchmark");
            this.statusLabel.setText(String.format("Round %d (%s)", benchmarkStatistics.round, string));
        }
    }

    private String formatSeconds(double d) {
        return String.format(Locale.ENGLISH, "%.03f sec.", d / 1000.0);
    }

    private void endBenchmark() {
        assert (Display.getCurrent() != null);
        try {
            if (this.benchmarkJob.settings.openLogsInEditor) {
                this.getSite().getWorkbenchWindow().getActivePage().openEditor((IEditorInput)new WebBrowserEditorInput(this.benchmarkJob.logFile.toURI().toURL()), "org.eclipse.ui.browser.editor");
            }
        }
        catch (Exception exception) {
            Utils.logError(exception, true);
        }
        this.benchmarkJob = null;
        this.startButton.setText(START_TEXT);
        this.startButton.setEnabled(true);
    }

    public BenchmarkViewPage(SearchEditor searchEditor, BenchmarkView benchmarkView) {
        this.editor = searchEditor;
        this.benchmarkView = benchmarkView;
    }

    public void createControl(Composite composite) {
        this.mainControl = this.createBenchmarkPanel(composite);
    }

    private Control createBenchmarkPanel(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).create());
        composite2.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        composite3.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 0).create());
        this.progressBar = new ProgressBar(composite3, 65792);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setSelection(0);
        this.progressBar.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.startButton = new Button(composite3, 8);
        this.startButton.setText(START_TEXT);
        this.startButton.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (BenchmarkViewPage.this.benchmarkJob == null) {
                    BenchmarkViewPage.this.startBenchmark();
                } else {
                    BenchmarkViewPage.this.benchmarkJob.cancel();
                    BenchmarkViewPage.this.startButton.setEnabled(false);
                }
            }
        });
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        composite4.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(4).margins(0, 0).create());
        this.statusLabel = this.addLabelOneColumn(composite4, "Status:");
        this.avgTimeLabel = this.addLabelTwoColumns(composite4, "Avg time:");
        this.stddevLabel = this.addLabelTwoColumns(composite4, "Std dev:");
        this.minTimeLabel = this.addLabelTwoColumns(composite4, "Min time:");
        this.maxTimeLabel = this.addLabelTwoColumns(composite4, "Max time:");
        return composite2;
    }

    private Label addLabelTwoColumns(Composite composite, String string) {
        Label label = new Label(composite, 16384);
        label.setText(string);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        Label label2 = new Label(composite, 16384);
        label2.setText("");
        label2.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, false).create());
        return label2;
    }

    private Label addLabelOneColumn(Composite composite, String string) {
        Label label = new Label(composite, 16384);
        label.setText(string);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        Label label2 = new Label(composite, 16384);
        label2.setText("");
        label2.setLayoutData((Object)GridDataFactory.swtDefaults().span(3, 1).align(4, 4).grab(true, false).create());
        return label2;
    }

    public Control getControl() {
        return this.mainControl;
    }

    public void setFocus() {
        this.startButton.setFocus();
    }
}

