/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.carrot2.core.Cluster;
import org.carrot2.core.ProcessingResult;
import org.carrot2.workbench.core.ui.ClusterLabelPaths;
import org.carrot2.workbench.core.ui.ClusterLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public final class ClusterTree
extends Composite
implements IPostSelectionProvider {
    private TreeViewer treeViewer;
    private List<Cluster> previousClusters;
    private final ITreeContentProvider contentProvider = new ITreeContentProvider(){
        private Map<Cluster, Cluster> parents = Maps.newIdentityHashMap();

        public Object[] getElements(Object object) {
            return ((List)object).toArray();
        }

        public Object[] getChildren(Object object) {
            Cluster cluster = (Cluster)object;
            return cluster.getSubclusters().toArray();
        }

        public Object getParent(Object object) {
            return this.parents.get(object);
        }

        public boolean hasChildren(Object object) {
            Cluster cluster = (Cluster)object;
            return cluster.getSubclusters().size() > 0;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            this.parents.clear();
            if (object2 != null) {
                this.recurse((List)object2, null);
            }
        }

        private void recurse(List<Cluster> list, Cluster cluster) {
            for (Cluster cluster2 : list) {
                this.parents.put(cluster2, cluster);
                this.recurse(cluster2.getSubclusters(), cluster2);
            }
        }
    };

    public ClusterTree(Composite composite, int n) {
        super(composite, n);
        this.createComponents();
    }

    public void dispose() {
        this.treeViewer.getTree().dispose();
        super.dispose();
    }

    public void show(List<Cluster> list) {
        if (list == null || list.isEmpty()) {
            this.clear();
        } else {
            ClusterLabelPaths clusterLabelPaths = null;
            if (this.previousClusters != null) {
                clusterLabelPaths = ClusterLabelPaths.from(this.previousClusters, this.getExpandedClusters());
            }
            this.treeViewer.setInput(list);
            if (clusterLabelPaths != null) {
                this.treeViewer.setExpandedElements(clusterLabelPaths.filterMatching(list).toArray());
            }
            this.previousClusters = list;
        }
    }

    private List<Cluster> getExpandedClusters() {
        ArrayList arrayList = Lists.newArrayList();
        Object[] objectArray = this.treeViewer.getExpandedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            arrayList.add((Cluster)object);
            ++n2;
        }
        return arrayList;
    }

    public void show(ProcessingResult processingResult) {
        List list = processingResult.getClusters();
        this.show(list);
    }

    public void clear() {
        this.previousClusters = null;
        this.treeViewer.setInput(Collections.emptyList());
    }

    private void createComponents() {
        this.setLayout((Layout)new FillLayout());
        this.treeViewer = new TreeViewer((Composite)this, 2);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ClusterLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setInput(Collections.emptyList());
        this.treeViewer.setAutoExpandLevel(1);
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.treeViewer.addSelectionChangedListener(iSelectionChangedListener);
    }

    public ISelection getSelection() {
        return this.treeViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.treeViewer.removeSelectionChangedListener(iSelectionChangedListener);
    }

    public void setSelection(ISelection iSelection) {
        this.treeViewer.setSelection(iSelection);
        if (iSelection instanceof TreeSelection) {
            TreePath[] treePathArray = ((TreeSelection)iSelection).getPaths();
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath treePath = treePathArray[n2];
                this.treeViewer.reveal((Object)treePath);
                ++n2;
            }
        }
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.treeViewer.addPostSelectionChangedListener(iSelectionChangedListener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.treeViewer.removePostSelectionChangedListener(iSelectionChangedListener);
    }

    public void expandAll() {
        this.treeViewer.expandAll();
    }

    public void collapseAll() {
        this.treeViewer.collapseAll();
    }
}

