/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import java.util.Collection;
import org.carrot2.core.Cluster;
import org.carrot2.core.ProcessingResult;
import org.carrot2.workbench.core.WorkbenchCorePlugin;
import org.carrot2.workbench.core.ui.ClusterTree;
import org.carrot2.workbench.core.ui.SearchResult;
import org.carrot2.workbench.core.ui.SearchResultListenerAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.actions.ActionDelegate;

final class ClusterTreeExpanderAction
extends ActionDelegate {
    private final CollapseAction collapseAction;
    private ClusterTree tree;
    private volatile IAction action;

    public ClusterTreeExpanderAction(CollapseAction collapseAction, ClusterTree clusterTree, SearchResult searchResult) {
        this.tree = clusterTree;
        this.collapseAction = collapseAction;
        searchResult.addListener(new SearchResultListenerAdapter(){

            @Override
            public void processingResultUpdated(ProcessingResult processingResult) {
                boolean bl = false;
                for (Cluster cluster : Cluster.flatten((Collection)processingResult.getClusters())) {
                    if (cluster.getSubclusters().isEmpty()) continue;
                    bl = true;
                    break;
                }
                if (ClusterTreeExpanderAction.this.action != null) {
                    ClusterTreeExpanderAction.this.action.setEnabled(bl);
                }
            }
        });
    }

    public void init(IAction iAction) {
        this.action = iAction;
        iAction.setImageDescriptor(WorkbenchCorePlugin.getImageDescriptor(this.collapseAction.iconPath));
        iAction.setToolTipText(this.collapseAction.hint);
    }

    public void run(IAction iAction) {
        if (this.collapseAction == CollapseAction.EXPAND) {
            this.tree.expandAll();
        } else {
            this.tree.collapseAll();
        }
    }

    public static enum CollapseAction {
        COLLAPSE("icons/collapseall.png", "Collapse all clusters."),
        EXPAND("icons/expandall.png", "Expand all clusters.");

        final String iconPath;
        final String hint;

        private CollapseAction(String string2, String string3) {
            this.iconPath = string2;
            this.hint = string3;
        }
    }
}

