/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import org.carrot2.workbench.core.ui.SearchEditorSelectionProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClusterTreeSelectionAdapter {
    private final Logger logger = LoggerFactory.getLogger(ClusterTreeSelectionAdapter.class);
    private final SearchEditorSelectionProvider target;
    private final IPostSelectionProvider provider;
    private final ISelectionChangedListener targetToEditorListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            ClusterTreeSelectionAdapter.this.logger.debug("tree->editor: " + selectionChangedEvent.getSelection());
            ClusterTreeSelectionAdapter.this.target.setSelection(selectionChangedEvent.getSelection(), ClusterTreeSelectionAdapter.this.editorToTargetListener);
        }
    };
    private final ISelectionChangedListener editorToTargetListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            ClusterTreeSelectionAdapter.this.logger.debug("editor->tree: " + selectionChangedEvent.getSelection());
            if (selectionChangedEvent.getSelection() instanceof SearchEditorSelectionProvider.ClusterSelection) {
                ClusterTreeSelectionAdapter.this.unlinkTargetFromEditor();
                ClusterTreeSelectionAdapter.this.provider.setSelection((ISelection)((SearchEditorSelectionProvider.ClusterSelection)selectionChangedEvent.getSelection()).treeSelection);
                ClusterTreeSelectionAdapter.this.linkTargetToEditor();
            }
        }
    };

    public ClusterTreeSelectionAdapter(SearchEditorSelectionProvider searchEditorSelectionProvider, IPostSelectionProvider iPostSelectionProvider) {
        this.target = searchEditorSelectionProvider;
        this.provider = iPostSelectionProvider;
        this.linkEditorToTarget();
        this.linkTargetToEditor();
    }

    private void linkTargetToEditor() {
        this.provider.addPostSelectionChangedListener(this.targetToEditorListener);
    }

    private void unlinkTargetFromEditor() {
        this.provider.removePostSelectionChangedListener(this.targetToEditorListener);
    }

    private void linkEditorToTarget() {
        this.target.addSelectionChangedListener(this.editorToTargetListener);
    }
}

