/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import org.carrot2.core.ProcessingResult;
import org.carrot2.workbench.core.helpers.ActionDelegateProxy;
import org.carrot2.workbench.core.ui.ClusterTree;
import org.carrot2.workbench.core.ui.ClusterTreeExpanderAction;
import org.carrot2.workbench.core.ui.ClusterTreeSelectionAdapter;
import org.carrot2.workbench.core.ui.SearchEditor;
import org.carrot2.workbench.core.ui.SearchEditorSelectionProvider;
import org.carrot2.workbench.core.ui.SearchResultListenerAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.part.Page;

final class ClusterTreeViewPage
extends Page {
    private final SearchEditor editor;
    private final SearchResultListenerAdapter editorSyncListener = new SearchResultListenerAdapter(){

        @Override
        public void processingResultUpdated(ProcessingResult processingResult) {
            ClusterTreeViewPage.this.showProcessingResult();
        }
    };
    private ClusterTree clusterTree;

    public ClusterTreeViewPage(SearchEditor searchEditor) {
        this.editor = searchEditor;
    }

    public void createControl(Composite composite) {
        this.clusterTree = new ClusterTree(composite, 0);
        IActionBars iActionBars = this.getSite().getActionBars();
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        iToolBarManager.add((IAction)new ActionDelegateProxy((IActionDelegate)new ClusterTreeExpanderAction(ClusterTreeExpanderAction.CollapseAction.EXPAND, this.clusterTree, this.editor.getSearchResult()), 1));
        iToolBarManager.add((IAction)new ActionDelegateProxy((IActionDelegate)new ClusterTreeExpanderAction(ClusterTreeExpanderAction.CollapseAction.COLLAPSE, this.clusterTree, this.editor.getSearchResult()), 1));
        iActionBars.updateActionBars();
        this.registerListeners();
        this.showProcessingResult();
        SearchEditorSelectionProvider searchEditorSelectionProvider = (SearchEditorSelectionProvider)this.editor.getSite().getSelectionProvider();
        new ClusterTreeSelectionAdapter(searchEditorSelectionProvider, this.clusterTree);
        this.clusterTree.setSelection((ISelection)searchEditorSelectionProvider.getSelection());
    }

    public Control getControl() {
        return this.clusterTree;
    }

    public void setFocus() {
        this.clusterTree.setFocus();
    }

    public void dispose() {
        this.unregisterListeners();
        this.clusterTree.dispose();
        super.dispose();
    }

    private void showProcessingResult() {
        ProcessingResult processingResult = this.editor.getSearchResult().getProcessingResult();
        if (processingResult != null) {
            this.clusterTree.show(processingResult);
        } else {
            this.clusterTree.clear();
        }
    }

    private void registerListeners() {
        this.editor.getSearchResult().addListener(this.editorSyncListener);
    }

    private void unregisterListeners() {
        this.editor.getSearchResult().removeListener(this.editorSyncListener);
    }
}

