/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeInstance;
import org.carrot2.core.Cluster;
import org.carrot2.core.ProcessingResult;
import org.carrot2.workbench.core.WorkbenchCorePlugin;
import org.carrot2.workbench.core.helpers.Utils;
import org.carrot2.workbench.core.ui.BrowserFacade;
import org.carrot2.workbench.velocity.VelocityInitializer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.LoggerFactory;

public final class DocumentList
extends Composite {
    private static final String TEMPLATES_PREFIX = "/templates/";
    private static final String TEMPLATE_PROCESSING_RESULT = "processing-result.vm";
    private static final String TEMPLATE_CLEAR = "clear.vm";
    private static final String TEMPLATE_CLUSTERS = "clusters.vm";
    private static boolean initialized;
    private Browser browser;
    private int maxDisplayPerResult = 1000;
    private int maxDisplayPerCluster = 1000;
    private static RuntimeInstance velocity;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentList(Composite composite, int n) {
        super(composite, n);
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            if (!initialized) {
                velocity = VelocityInitializer.createInstance("org.carrot2.workbench.core", TEMPLATES_PREFIX);
                initialized = true;
            }
        }
        this.createComponents();
    }

    public void show(ProcessingResult processingResult) {
        String string;
        VelocityContext velocityContext = VelocityInitializer.createContext();
        velocityContext.put("result", (Object)processingResult);
        if (processingResult.getAttributes().get("results-total") != null) {
            long l = (Long)processingResult.getAttributes().get("results-total");
            velocityContext.put("results-total-formatted", (Object)String.format(Locale.ENGLISH, "%1$,d", l));
        }
        if (StringUtils.isEmpty((String)(string = (String)processingResult.getAttributes().get("query")))) {
            string = "";
        }
        velocityContext.put("query", (Object)string);
        velocityContext.put("maxDisplay", (Object)this.maxDisplayPerResult);
        this.update(velocityContext, TEMPLATE_PROCESSING_RESULT);
    }

    public void show(Cluster ... clusterArray) {
        if (clusterArray.length == 0) {
            this.clear();
        } else {
            VelocityContext velocityContext = VelocityInitializer.createContext();
            velocityContext.put("clusters", Arrays.asList(clusterArray));
            velocityContext.put("maxDisplay", (Object)this.maxDisplayPerCluster);
            this.update(velocityContext, TEMPLATE_CLUSTERS);
        }
    }

    public void clear() {
        this.update(null, TEMPLATE_CLEAR);
    }

    public void dispose() {
        this.browser.dispose();
    }

    private void update(VelocityContext velocityContext, String string) {
        long l = System.currentTimeMillis();
        long l2 = 0L;
        StringWriter stringWriter = new StringWriter();
        try {
            Template template = velocity.getTemplate(string, "UTF-8");
            template.merge((Context)velocityContext, (Writer)stringWriter);
            l2 = System.currentTimeMillis() - l;
        }
        catch (Exception exception) {
            Utils.logError("Error while loading template", exception, true);
            return;
        }
        this.browser.setText(stringWriter.toString());
        long l3 = System.currentTimeMillis() - l - l2;
        LoggerFactory.getLogger(DocumentList.class).debug(String.format(Locale.ENGLISH, "Velocity [rendering: %.2f, display: %.2f]", (double)l2 / 1000.0, (double)l3 / 1000.0));
    }

    private void createComponents() {
        this.setLayout((Layout)new FillLayout());
        this.browser = BrowserFacade.createNew(this, 0);
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent locationEvent) {
                if (locationEvent.location.equals("about:blank")) {
                    return;
                }
                try {
                    WorkbenchCorePlugin.getDefault().getWorkbench().getBrowserSupport().createBrowser(46, null, null, null).openURL(new URL(locationEvent.location));
                }
                catch (Exception exception) {
                    Utils.logError("Couldn't open internal browser", exception, true);
                }
                locationEvent.doit = false;
            }
        });
    }
}

