/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import org.carrot2.core.ProcessingResult;
import org.carrot2.workbench.core.ui.DocumentList;
import org.carrot2.workbench.core.ui.DocumentListSelectionAdapter;
import org.carrot2.workbench.core.ui.SearchEditor;
import org.carrot2.workbench.core.ui.SearchEditorSelectionProvider;
import org.carrot2.workbench.core.ui.SearchResultListenerAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.Page;

class DocumentListPage
extends Page {
    private final SearchEditor editor;
    private final SearchResultListenerAdapter editorSyncListener = new SearchResultListenerAdapter(){

        @Override
        public void processingResultUpdated(ProcessingResult processingResult) {
            DocumentListPage.this.showProcessingResult();
        }
    };
    DocumentList documentList;
    private DocumentListSelectionAdapter selectionAdapter;

    public DocumentListPage(SearchEditor searchEditor) {
        this.editor = searchEditor;
    }

    public void createControl(Composite composite) {
        this.documentList = new DocumentList(composite, 0);
        this.registerListeners();
    }

    public Control getControl() {
        return this.documentList;
    }

    public void setFocus() {
        this.documentList.setFocus();
    }

    public void dispose() {
        this.unregisterListeners();
        this.documentList.dispose();
        super.dispose();
    }

    private void showProcessingResult() {
        ProcessingResult processingResult = this.editor.getSearchResult().getProcessingResult();
        if (processingResult != null) {
            this.documentList.show(processingResult);
        } else {
            this.documentList.clear();
        }
    }

    private void registerListeners() {
        this.editor.getSearchResult().addListener(this.editorSyncListener);
        this.selectionAdapter = new DocumentListSelectionAdapter((SearchEditorSelectionProvider)this.editor.getSite().getSelectionProvider(), this.documentList, this.editor);
    }

    private void unregisterListeners() {
        this.editor.getSearchResult().removeListener(this.editorSyncListener);
        this.selectionAdapter.unlinkEditorFromTarget();
    }
}

