/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import org.carrot2.core.Cluster;
import org.carrot2.core.ProcessingResult;
import org.carrot2.workbench.core.ui.DocumentList;
import org.carrot2.workbench.core.ui.SearchEditor;
import org.carrot2.workbench.core.ui.SearchEditorSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DocumentListSelectionAdapter {
    private final Logger logger = LoggerFactory.getLogger(DocumentListSelectionAdapter.class);
    private final DocumentList target;
    private final SearchEditorSelectionProvider provider;
    private final SearchEditor editor;
    private final ISelectionChangedListener editorToTargetListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            DocumentListSelectionAdapter.this.logger.debug("editor->doclist: " + selectionChangedEvent.getSelection());
            if (selectionChangedEvent.getSelection() instanceof SearchEditorSelectionProvider.ClusterSelection) {
                SearchEditorSelectionProvider.ClusterSelection clusterSelection = (SearchEditorSelectionProvider.ClusterSelection)selectionChangedEvent.getSelection();
                if (clusterSelection.isEmpty()) {
                    DocumentListSelectionAdapter.this.emptySelection();
                } else {
                    DocumentListSelectionAdapter.this.target.show((Cluster[])clusterSelection.toArray());
                }
            }
        }
    };

    public DocumentListSelectionAdapter(SearchEditorSelectionProvider searchEditorSelectionProvider, DocumentList documentList, SearchEditor searchEditor) {
        this.target = documentList;
        this.provider = searchEditorSelectionProvider;
        this.editor = searchEditor;
        this.linkEditorToTarget();
        this.editorToTargetListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)searchEditorSelectionProvider, (ISelection)searchEditorSelectionProvider.getSelection()));
    }

    private void emptySelection() {
        ProcessingResult processingResult = this.editor.getSearchResult().getProcessingResult();
        if (processingResult == null) {
            this.target.clear();
        } else {
            this.target.show(processingResult);
        }
    }

    public void linkEditorToTarget() {
        this.provider.addSelectionChangedListener(this.editorToTargetListener);
    }

    public void unlinkEditorFromTarget() {
        this.provider.removeSelectionChangedListener(this.editorToTargetListener);
    }
}

