/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.carrot2.workbench.core.WorkbenchCorePlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class FileDialogs {
    public static Path openSaveXML(IPath iPath) {
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        FileDialog fileDialog = new FileDialog(shell, 8192);
        if (iPath != null && !iPath.isEmpty() && iPath.segmentCount() >= 2) {
            fileDialog.setFileName(iPath.lastSegment());
            fileDialog.setFilterPath(iPath.removeLastSegments(1).toOSString());
        }
        fileDialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
        fileDialog.setFilterNames(new String[]{"XML Files", "All Files"});
        fileDialog.setOverwrite(true);
        String string = fileDialog.open();
        if (string == null) {
            return null;
        }
        return new Path(string);
    }

    public static IPath openReadXML(IPath iPath) {
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        FileDialog fileDialog = new FileDialog(shell, 4096);
        if (iPath != null && !iPath.isEmpty()) {
            fileDialog.setFilterPath(iPath.toOSString());
        }
        fileDialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
        fileDialog.setFilterNames(new String[]{"XML Files", "All Files"});
        String string = fileDialog.open();
        if (string == null || !new File(string).exists()) {
            return null;
        }
        return new Path(string);
    }

    public static void rememberPath(String string, IPath iPath) {
        WorkbenchCorePlugin.getPreferences().put(string, iPath.toOSString());
    }

    public static void rememberDirectory(String string, IPath iPath) {
        File file = iPath.toFile();
        if (!file.isDirectory() && file.getParentFile() != null) {
            file = file.getParentFile();
        }
        FileDialogs.rememberPath(string, (IPath)new Path(file.getAbsolutePath()));
    }

    public static Path recallPath(String string) {
        String string2 = WorkbenchCorePlugin.getPreferences().get(string, FileDialogs.getDefaultPath().toOSString());
        return FileDialogs.checkOrDefault(string2);
    }

    public static Path checkOrDefault(String string) {
        if (string == null) {
            return FileDialogs.getDefaultPath();
        }
        File file = new File(string);
        if (file.getParentFile() == null || file.getParentFile().exists()) {
            return new Path(file.getAbsolutePath());
        }
        return FileDialogs.getDefaultPath();
    }

    public static Path getDefaultPath() {
        return new Path(new File(System.getProperty("user.home", ".")).getAbsolutePath());
    }

    public static String sanitizeFileName(String string) {
        String string2 = string.replaceAll("[^a-zA-Z0-9_\\-.\\s]", "");
        string2 = string2.trim().replaceAll("[\\s]+", "-");
        if (StringUtils.isEmpty((String)(string2 = string2.toLowerCase()))) {
            string2 = "unnamed";
        }
        return string2;
    }
}

