/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import org.carrot2.util.attribute.AttributeDescriptor;
import org.carrot2.workbench.core.helpers.Utils;
import org.carrot2.workbench.editors.AttributeEvent;
import org.carrot2.workbench.editors.IAttributeListener;
import org.eclipse.jface.fieldassist.ControlDecoration;

final class InvalidStateDecorationListener
implements IAttributeListener {
    private final ControlDecoration decoration;
    private AttributeDescriptor descriptor;
    private boolean showOverlay;
    private boolean valid;

    public InvalidStateDecorationListener(ControlDecoration controlDecoration, AttributeDescriptor attributeDescriptor, Object object) {
        this.decoration = controlDecoration;
        this.descriptor = attributeDescriptor;
        this.valueChanged(new AttributeEvent(this, attributeDescriptor.key, object));
    }

    @Override
    public void valueChanged(AttributeEvent attributeEvent) {
        if (attributeEvent.key.equals("enable.validation.overlays")) {
            this.showOverlay = true;
            this.updateOverlay();
        } else if (attributeEvent.key.equals(this.descriptor.key)) {
            try {
                this.valid = this.descriptor.isValid(attributeEvent.value);
            }
            catch (Exception exception) {
                Utils.logError(exception, false);
                this.valid = false;
            }
            this.updateOverlay();
        }
    }

    private void updateOverlay() {
        if (this.valid || !this.showOverlay) {
            this.decoration.hide();
        } else {
            this.decoration.show();
        }
    }

    @Override
    public void valueChanging(AttributeEvent attributeEvent) {
        this.valueChanged(attributeEvent);
    }
}

