/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.carrot2.core.ProcessingComponentDescriptor;
import org.carrot2.core.attribute.InternalAttributePredicate;
import org.carrot2.util.attribute.AttributeDescriptor;
import org.carrot2.util.attribute.AttributeValueSet;
import org.carrot2.util.attribute.AttributeValueSets;
import org.carrot2.util.attribute.BindableDescriptor;
import org.carrot2.util.attribute.Input;
import org.carrot2.workbench.core.WorkbenchCorePlugin;
import org.carrot2.workbench.core.helpers.DropDownMenuAction;
import org.carrot2.workbench.core.helpers.Utils;
import org.carrot2.workbench.core.ui.FileDialogs;
import org.carrot2.workbench.core.ui.MenuManagerCreator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Event;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.stream.Format;

abstract class SaveAttributesAction
extends Action {
    private static final String REMEMBER_DIRECTORY = String.valueOf(SaveAttributesAction.class.getName()) + ".lastSaveDir";
    private final Action openAction = new Action("Open"){

        public void runWithEvent(Event event) {
            SaveAttributesAction.this.applyAttributes(SaveAttributesAction.this.createAttributeMapToApply(SaveAttributesAction.openAttributes()));
        }
    };
    private final Action saveAction = new Action("Save As..."){

        public void runWithEvent(Event event) {
            AttributeValueSets attributeValueSets = SaveAttributesAction.this.createAttributeValueSetsToSave(SaveAttributesAction.this.collectAttributes());
            SaveAttributesAction.saveAttributes(SaveAttributesAction.this.getFileNameHint(), attributeValueSets);
        }
    };

    public SaveAttributesAction(String string) {
        super(string, 4);
        this.setImageDescriptor(WorkbenchCorePlugin.getImageDescriptor("icons/save_e.gif"));
        this.setMenuCreator(new MenuManagerCreator(){

            @Override
            protected MenuManager createMenu() {
                return SaveAttributesAction.this.createMenu();
            }
        });
    }

    static AttributeValueSets openAttributes() {
        Path path = FileDialogs.recallPath(REMEMBER_DIRECTORY);
        IPath iPath = FileDialogs.openReadXML((IPath)path);
        if (iPath != null) {
            FileDialogs.rememberDirectory(REMEMBER_DIRECTORY, iPath);
            try {
                Persister persister = new Persister();
                AttributeValueSets attributeValueSets = (AttributeValueSets)persister.read(AttributeValueSets.class, iPath.toFile());
                return attributeValueSets;
            }
            catch (Exception exception) {
                Utils.showError((IStatus)new Status(4, "org.carrot2.workbench.core", "Failed to read attributes from: " + iPath.toOSString(), (Throwable)exception));
            }
        }
        return new AttributeValueSets();
    }

    protected abstract Map<String, Object> collectAttributes();

    protected abstract String getComponentId();

    private AttributeValueSets createAttributeValueSetsToSave(Map<String, Object> map) {
        String string = this.getComponentId();
        assert (string != null);
        AttributeValueSet attributeValueSet = SaveAttributesAction.getDefaultAttributeValueSet(string);
        AttributeValueSet attributeValueSet2 = new AttributeValueSet("overridden-attributes", attributeValueSet);
        SaveAttributesAction.removeSpecialKeys(map);
        SaveAttributesAction.removeInternalNonConfigurationAttributes(map, string);
        SaveAttributesAction.removeKeysWithDefaultValues(map, attributeValueSet);
        map.keySet().retainAll(attributeValueSet.getAttributeValues().keySet());
        attributeValueSet2.setAttributeValues(map);
        AttributeValueSets attributeValueSets = new AttributeValueSets();
        attributeValueSets.addAttributeValueSet(attributeValueSet2.label, attributeValueSet2);
        attributeValueSets.addAttributeValueSet(attributeValueSet.label, attributeValueSet);
        attributeValueSets.setDefaultAttributeValueSetId(attributeValueSet2.label);
        return attributeValueSets;
    }

    protected abstract void applyAttributes(Map<String, Object> var1);

    private Map<String, Object> createAttributeMapToApply(AttributeValueSets attributeValueSets) {
        HashMap hashMap = Maps.newHashMap((Map)attributeValueSets.getDefaultAttributeValueSet().getAttributeValues());
        SaveAttributesAction.removeInternalNonConfigurationAttributes(hashMap, this.getComponentId());
        return hashMap;
    }

    protected abstract IPath getFileNameHint();

    static void saveAttributes(IPath iPath, AttributeValueSets attributeValueSets) {
        IPath iPath2 = iPath.isAbsolute() ? iPath : FileDialogs.recallPath(REMEMBER_DIRECTORY).append(iPath);
        Path path = FileDialogs.openSaveXML(iPath2);
        if (path != null) {
            try {
                Persister persister = new Persister(new Format(2));
                persister.write((Object)attributeValueSets, path.toFile());
            }
            catch (Exception exception) {
                Utils.showError((IStatus)new Status(4, "org.carrot2.workbench.core", "An error occurred while saving attributes.", (Throwable)exception));
            }
            FileDialogs.rememberDirectory(REMEMBER_DIRECTORY, (IPath)path);
        }
    }

    static IPath getDefaultHint(String string, String string2) {
        ProcessingComponentDescriptor processingComponentDescriptor = WorkbenchCorePlugin.getDefault().getComponent(string);
        String string3 = processingComponentDescriptor.getAttributeSetsResource();
        if (StringUtils.isBlank((String)string3)) {
            string3 = FileDialogs.sanitizeFileName(String.valueOf(string2) + string + "-attributes.xml");
        }
        return new Path(string3);
    }

    protected static void removeSpecialKeys(Map<String, Object> map) {
        map.remove("documents");
        map.remove("query");
        map.remove("start");
        map.remove("results");
    }

    protected MenuManager createMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)this.openAction);
        menuManager.add((IAction)this.saveAction);
        return menuManager;
    }

    public void runWithEvent(Event event) {
        DropDownMenuAction.showMenu((IAction)this, event);
    }

    private static void removeKeysWithDefaultValues(Map<String, Object> map, AttributeValueSet attributeValueSet) {
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String string = entry.getKey();
            Object object = entry.getValue();
            if (!ObjectUtils.equals((Object)object, (Object)attributeValueSet.getAttributeValue(string))) continue;
            iterator.remove();
        }
    }

    static AttributeValueSet getDefaultAttributeValueSet(String string) {
        BindableDescriptor bindableDescriptor = WorkbenchCorePlugin.getDefault().getComponentDescriptor(string);
        HashMap hashMap = Maps.newHashMap();
        for (Map.Entry attributeValueSet2 : bindableDescriptor.flatten().only((Class[])new Class[]{Input.class}).attributeDescriptors.entrySet()) {
            hashMap.put((String)attributeValueSet2.getKey(), ((AttributeDescriptor)attributeValueSet2.getValue()).defaultValue);
        }
        SaveAttributesAction.removeSpecialKeys(hashMap);
        SaveAttributesAction.removeInternalNonConfigurationAttributes(hashMap, string);
        AttributeValueSet attributeValueSet = new AttributeValueSet("defaults");
        attributeValueSet.setAttributeValues((Map)hashMap);
        return attributeValueSet;
    }

    private static void removeInternalNonConfigurationAttributes(Map<String, Object> map, String string) {
        BindableDescriptor bindableDescriptor = WorkbenchCorePlugin.getDefault().getComponentDescriptor(string);
        map.keySet().removeAll(bindableDescriptor.flatten().only((Predicate)new InternalAttributePredicate((Boolean)Boolean.valueOf((boolean)false))).attributeDescriptors.keySet());
    }
}

