/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.carrot2.core.ProcessingComponentDescriptor;
import org.carrot2.core.ProcessingResult;
import org.carrot2.core.attribute.InternalAttributePredicate;
import org.carrot2.core.attribute.Processing;
import org.carrot2.util.attribute.BindableDescriptor;
import org.carrot2.util.attribute.Input;
import org.carrot2.workbench.core.WorkbenchActionFactory;
import org.carrot2.workbench.core.WorkbenchCorePlugin;
import org.carrot2.workbench.core.helpers.ActionDelegateProxy;
import org.carrot2.workbench.core.helpers.DisposeBin;
import org.carrot2.workbench.core.helpers.GUIFactory;
import org.carrot2.workbench.core.helpers.PartListenerAdapter;
import org.carrot2.workbench.core.helpers.PostponableJob;
import org.carrot2.workbench.core.helpers.SimpleXmlMemento;
import org.carrot2.workbench.core.helpers.Utils;
import org.carrot2.workbench.core.ui.AttributeGroups;
import org.carrot2.workbench.core.ui.ClusterTree;
import org.carrot2.workbench.core.ui.ClusterTreeExpanderAction;
import org.carrot2.workbench.core.ui.ClusterTreeSelectionAdapter;
import org.carrot2.workbench.core.ui.DocumentList;
import org.carrot2.workbench.core.ui.DocumentListSelectionAdapter;
import org.carrot2.workbench.core.ui.FileDialogs;
import org.carrot2.workbench.core.ui.PropertyChangeListenerAdapter;
import org.carrot2.workbench.core.ui.SaveAlgorithmAttributesAction;
import org.carrot2.workbench.core.ui.SearchEditorMemento;
import org.carrot2.workbench.core.ui.SearchEditorPanelsAction;
import org.carrot2.workbench.core.ui.SearchEditorSaveAsDialog;
import org.carrot2.workbench.core.ui.SearchEditorSelectionProvider;
import org.carrot2.workbench.core.ui.SearchInput;
import org.carrot2.workbench.core.ui.SearchJob;
import org.carrot2.workbench.core.ui.SearchResult;
import org.carrot2.workbench.core.ui.SearchResultListenerAdapter;
import org.carrot2.workbench.core.ui.actions.GroupingMethodAction;
import org.carrot2.workbench.core.ui.actions.SaveAsXMLActionDelegate;
import org.carrot2.workbench.core.ui.sash.SashForm;
import org.carrot2.workbench.core.ui.widgets.CScrolledComposite;
import org.carrot2.workbench.editors.AttributeEvent;
import org.carrot2.workbench.editors.AttributeListenerAdapter;
import org.carrot2.workbench.editors.IAttributeListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart3;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.progress.UIJob;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Transient;

public final class SearchEditor
extends EditorPart
implements IPersistableEditor {
    public static final String ID = "org.carrot2.workbench.core.editors.searchEditor";
    private SaveOptions saveOptions;
    private static final String GROUPING_LOCAL = "search-editor.layout.local";
    private static final String GLOBAL_MEMENTO_KEY = SearchEditor.class + ".memento";
    private EnumMap<PanelName, PanelReference> panels;
    private SearchResult searchResult;
    private DisposeBin resources;
    private Image sourceImage;
    private boolean dirty = true;
    private FormToolkit toolkit;
    private Form rootForm;
    private SashForm sashForm;
    private SearchEditorMemento state;
    private SearchEditorSelectionProvider selectionProvider;
    private SearchJob searchJob;
    private IAttributeListener autoUpdateListener = new AttributeListenerAdapter(){
        private PostponableJob job = new PostponableJob((Job)new UIJob("Auto update..."){

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                SearchEditor.this.reprocess();
                return Status.OK_STATUS;
            }
        });

        @Override
        public void valueChanged(AttributeEvent attributeEvent) {
            IPreferenceStore iPreferenceStore = WorkbenchCorePlugin.getDefault().getPreferenceStore();
            if (iPreferenceStore.getBoolean("auto-update.enabled")) {
                int n = iPreferenceStore.getInt("auto-update.delay");
                this.job.reschedule(n);
            }
        }
    };
    private IPropertyChangeListener autoUpdateListener2 = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("auto-update.enabled".equals(propertyChangeEvent.getProperty()) && SearchEditor.this.isDirty()) {
                SearchEditor.this.reprocess();
            }
        }
    };
    private AttributeGroups attributesPanel;

    public void createPartControl(Composite composite) {
        this.resources = new DisposeBin((Plugin)WorkbenchCorePlugin.getDefault());
        this.sourceImage = this.getEditorInput().getImageDescriptor().createImage();
        this.resources.add(new Resource[]{this.sourceImage});
        this.toolkit = new FormToolkit(composite.getDisplay());
        this.resources.add(this.toolkit);
        this.rootForm = this.toolkit.createForm(composite);
        this.rootForm.setText(this.getPartName());
        this.rootForm.setImage(this.getTitleImage());
        this.toolkit.decorateFormHeading(this.rootForm);
        this.sashForm = new SashForm(this.rootForm.getBody(), 256){

            @Override
            protected boolean onDragSash(Event event) {
                boolean bl = super.onDragSash(event);
                if (bl) {
                    int[] nArray = SearchEditor.this.sashForm.getWeights();
                    for (PanelReference panelReference : SearchEditor.this.panels.values()) {
                        panelReference.state.weight = nArray[panelReference.sashIndex];
                    }
                    SearchEditor.saveGlobalPanelsState(SearchEditor.this.getPanelState());
                }
                return bl;
            }
        };
        this.toolkit.adapt((Composite)this.sashForm);
        GridLayout gridLayout = GridLayoutFactory.swtDefaults().margins(this.sashForm.SASH_WIDTH, this.sashForm.SASH_WIDTH).create();
        this.rootForm.getBody().setLayout((Layout)gridLayout);
        this.createControls(this.sashForm);
        this.createActions();
        this.updatePartHeaders();
        this.sashForm.setLayoutData(new GridData(4, 4, true, true));
        this.searchResult.addListener(new SearchResultListenerAdapter(){

            @Override
            public void processingResultUpdated(ProcessingResult processingResult) {
                SearchEditor.this.updatePartHeaders();
            }
        });
        this.createJobs();
        this.getSite().getPage().addPartListener((IPartListener)new PartListenerAdapter(){

            @Override
            public void partClosed(IWorkbenchPart iWorkbenchPart) {
                SearchEditor.this.getSite().getPage().removePartListener((IPartListener)this);
            }

            @Override
            public void partOpened(IWorkbenchPart iWorkbenchPart) {
                if (iWorkbenchPart == SearchEditor.this) {
                    SearchEditor.this.reprocess();
                }
            }
        });
    }

    private void updatePartHeaders() {
        SearchResult searchResult = this.getSearchResult();
        SearchInput searchInput = this.getSearchResult().getInput();
        String string = this.getFullInputTitle(searchResult);
        String string2 = this.getAbbreviatedInputTitle(searchResult);
        this.setPartName(string2);
        this.setTitleToolTip(string);
        ProcessingResult processingResult = searchResult.getProcessingResult();
        if (processingResult != null) {
            int n = processingResult.getDocuments().size();
            int n2 = processingResult.getClusters().size();
            this.rootForm.setText(String.valueOf(string2) + " (" + this.pluralize(n, "document") + " from " + this.componentName(searchInput.getSourceId()) + ", " + this.pluralize(n2, "cluster") + " from " + this.componentName(searchInput.getAlgorithmId()) + ")");
        } else {
            this.rootForm.setText(string2);
        }
    }

    private String componentName(String string) {
        ProcessingComponentDescriptor processingComponentDescriptor = WorkbenchCorePlugin.getDefault().getComponent(string);
        if (processingComponentDescriptor != null && !StringUtils.isEmpty((String)processingComponentDescriptor.getLabel())) {
            return processingComponentDescriptor.getLabel();
        }
        return string;
    }

    private String pluralize(int n, String string) {
        return String.valueOf(Integer.toString(n)) + " " + string + (n != 1 ? "s" : "");
    }

    private String getAbbreviatedInputTitle(SearchResult searchResult) {
        return StringUtils.abbreviate((String)this.getFullInputTitle(searchResult), (int)40);
    }

    private String getFullInputTitle(SearchResult searchResult) {
        String string = ObjectUtils.toString((Object)this.searchResult.getInput().getAttribute("query"), null);
        if (searchResult.hasProcessingResult()) {
            ProcessingResult processingResult = searchResult.getProcessingResult();
            string = ObjectUtils.toString(processingResult.getAttributes().get("query"), null);
            string = ObjectUtils.toString(processingResult.getAttributes().get("processing-result.title"), (String)string);
        }
        if (StringUtils.isEmpty((String)string)) {
            string = "(empty query)";
        }
        return string;
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        if (!(iEditorInput instanceof SearchInput)) {
            throw new PartInitException("Invalid input: must be an instance of: " + SearchInput.class.getName());
        }
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        if (StringUtils.isEmpty((String)this.getPartProperty(GROUPING_LOCAL))) {
            IPreferenceStore iPreferenceStore = WorkbenchCorePlugin.getDefault().getPreferenceStore();
            this.setPartProperty(GROUPING_LOCAL, iPreferenceStore.getString("search-editor.layout"));
        }
        this.searchResult = new SearchResult((SearchInput)iEditorInput);
    }

    public Image getTitleImage() {
        return this.sourceImage;
    }

    public void setFocus() {
        this.rootForm.setFocus();
    }

    public void dispose() {
        this.resources.dispose();
        super.dispose();
    }

    public void saveState(IMemento iMemento) {
        if (iMemento == null) {
            return;
        }
        try {
            SearchEditorMemento searchEditorMemento = new SearchEditorMemento();
            searchEditorMemento.panels = this.getPanelState();
            searchEditorMemento.sectionsExpansionState = this.attributesPanel.getExpansionStates();
            searchEditorMemento.saveOptions = this.saveOptions;
            SimpleXmlMemento.addChild(iMemento, searchEditorMemento);
        }
        catch (IOException iOException) {
            Utils.logError(iOException, false);
        }
    }

    public void restoreState(IMemento iMemento) {
        if (iMemento == null) {
            return;
        }
        try {
            this.state = SimpleXmlMemento.getChild(SearchEditorMemento.class, iMemento);
        }
        catch (IOException iOException) {
            Utils.logError(iOException, false);
        }
    }

    void saveAsGlobalState() {
        SearchEditor.saveGlobalPanelsState(this.getPanelState());
        this.state = new SearchEditorMemento();
        this.state.panels = this.getPanelState();
        this.state.sectionsExpansionState = this.attributesPanel.getExpansionStates();
        SimpleXmlMemento.toPreferenceStore(GLOBAL_MEMENTO_KEY, this.state);
    }

    public static void saveGlobalPanelsState(Map<PanelName, PanelState> map) {
        IPreferenceStore iPreferenceStore = WorkbenchCorePlugin.getDefault().getPreferenceStore();
        for (Map.Entry<PanelName, PanelState> entry : map.entrySet()) {
            iPreferenceStore.setValue(entry.getKey().prefKeyVisibility, entry.getValue().visibility);
            iPreferenceStore.setValue(entry.getKey().prefKeyWeight, entry.getValue().weight);
        }
    }

    private static SearchEditorMemento restoreGlobalState() {
        SearchEditorMemento searchEditorMemento = SimpleXmlMemento.fromPreferenceStore(SearchEditorMemento.class, GLOBAL_MEMENTO_KEY);
        if (searchEditorMemento == null) {
            searchEditorMemento = new SearchEditorMemento();
            searchEditorMemento.sectionsExpansionState = Maps.newHashMap();
        }
        IPreferenceStore iPreferenceStore = WorkbenchCorePlugin.getDefault().getPreferenceStore();
        EnumMap enumMap = Maps.newEnumMap(PanelName.class);
        for (PanelName panelName : EnumSet.allOf(PanelName.class)) {
            PanelState panelState = new PanelState();
            panelState.visibility = iPreferenceStore.getBoolean(panelName.prefKeyVisibility);
            panelState.weight = iPreferenceStore.getInt(panelName.prefKeyWeight);
            enumMap.put(panelName, panelState);
        }
        searchEditorMemento.panels = enumMap;
        return searchEditorMemento;
    }

    private void restoreState() {
        Map.Entry<PanelName, PanelState> entry2;
        SearchEditorMemento searchEditorMemento = SearchEditor.restoreGlobalState();
        for (Map.Entry<PanelName, PanelState> entry2 : searchEditorMemento.panels.entrySet()) {
            this.panels.get((Object)((Object)entry2.getKey())).state = entry2.getValue();
        }
        this.attributesPanel.setExpanded(searchEditorMemento.sectionsExpansionState);
        if (this.state != null) {
            for (Map.Entry<PanelName, PanelState> entry2 : this.state.panels.entrySet()) {
                this.panels.get((Object)((Object)entry2.getKey())).state = entry2.getValue();
            }
            this.attributesPanel.setExpanded(this.state.sectionsExpansionState);
            this.saveOptions = this.state.saveOptions;
        }
        entry2 = (Map.Entry<PanelName, PanelState>)this.sashForm.getWeights();
        for (Map.Entry<PanelName, PanelReference> entry3 : this.panels.entrySet()) {
            PanelReference panelReference = entry3.getValue();
            entry2[((PanelReference)panelReference).sashIndex] = (Map.Entry<PanelName, PanelState>)panelReference.state.weight;
            this.setPanelVisibility(entry3.getKey(), panelReference.state.visibility);
        }
        this.sashForm.setWeights((int[])entry2);
    }

    Map<PanelName, PanelState> getPanelState() {
        HashMap hashMap = Maps.newHashMap();
        for (Map.Entry<PanelName, PanelReference> entry : this.panels.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().state);
        }
        return hashMap;
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        if (this.saveOptions == null) {
            this.doSaveAs();
            return;
        }
        this.doSave(this.saveOptions);
    }

    public void doSaveAs() {
        Shell shell;
        SaveOptions saveOptions;
        if ((this.isDirty() || this.searchJob.getState() == 4) && (saveOptions = new MessageDialog(this.getEditorSite().getShell(), "Modified parameters", null, "Search parameters have been changed. Save stale results?", 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0)).open() == 1) {
            return;
        }
        saveOptions = this.saveOptions;
        if (saveOptions == null) {
            saveOptions = SaveOptions.getGlobalOrDefault();
            saveOptions.fileName = String.valueOf(FileDialogs.sanitizeFileName(this.getFullInputTitle(this.getSearchResult()))) + ".xml";
        }
        if (new SearchEditorSaveAsDialog(shell = this.getEditorSite().getShell(), saveOptions).open() == 0) {
            this.saveOptions = saveOptions;
            this.doSave(this.saveOptions);
        }
    }

    private void doSave(SaveOptions saveOptions) {
        ProcessingResult processingResult = this.getSearchResult().getProcessingResult();
        if (processingResult == null) {
            Utils.showError((IStatus)new Status(4, "org.carrot2.workbench.core", "No search result yet."));
            return;
        }
        SaveAsXMLActionDelegate saveAsXMLActionDelegate = new SaveAsXMLActionDelegate(processingResult, saveOptions);
        Job job = new Job("Saving search result...", (IAction)saveAsXMLActionDelegate){
            private final /* synthetic */ IAction val$saveAction;
            {
                this.val$saveAction = iAction;
                super(string);
            }

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                this.val$saveAction.run();
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void setDirty(boolean bl) {
        this.dirty = bl;
        this.firePropertyChange(257);
    }

    public Object getAdapter(Class clazz) {
        return super.getAdapter(clazz);
    }

    public void setPanelVisibility(PanelName panelName, boolean bl) {
        this.panels.get((Object)((Object)panelName)).state.visibility = bl;
        this.panels.get((Object)panelName).section.setVisible(bl);
        this.sashForm.layout();
    }

    public void reprocess() {
        this.setDirty(false);
        this.searchJob.schedule();
    }

    public SearchResult getSearchResult() {
        return this.searchResult;
    }

    private void createActions() {
        IToolBarManager iToolBarManager = this.rootForm.getToolBarManager();
        SearchEditorPanelsAction searchEditorPanelsAction = new SearchEditorPanelsAction("Choose visible panels", this);
        iToolBarManager.add((IAction)searchEditorPanelsAction);
        iToolBarManager.update(true);
    }

    private void updateGroupingState(BindableDescriptor.GroupingMethod groupingMethod) {
        this.attributesPanel.setGrouping(groupingMethod);
        this.attributesPanel.setAttributes(this.getSearchResult().getInput().getAttributeValueSet().getAttributeValues());
    }

    private void createControls(SashForm sashForm) {
        Object object2;
        this.panels = Maps.newEnumMap(PanelName.class);
        int n = 0;
        for (Object object2 : EnumSet.allOf(PanelName.class)) {
            Section section;
            switch (object2) {
                case CLUSTERS: {
                    section = this.createClustersPart(sashForm, (IWorkbenchSite)this.getSite());
                    break;
                }
                case DOCUMENTS: {
                    section = this.createDocumentsPart(sashForm, (IWorkbenchSite)this.getSite());
                    break;
                }
                case ATTRIBUTES: {
                    section = this.createAttributesPart(sashForm, (IWorkbenchSite)this.getSite());
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown section: " + (Object)object2);
                }
            }
            PanelReference panelReference = new PanelReference(section, n++);
            this.panels.put((PanelName)((Object)object2), panelReference);
        }
        this.selectionProvider = new SearchEditorSelectionProvider(this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        object2 = (ClusterTree)this.panels.get((Object)PanelName.CLUSTERS).section.getClient();
        new ClusterTreeSelectionAdapter(this.selectionProvider, (IPostSelectionProvider)object2);
        this.getSearchResult().getInput().addAttributeListener(new AttributeListenerAdapter(){

            @Override
            public void valueChanged(AttributeEvent attributeEvent) {
                SearchEditor.this.setDirty(true);
            }
        });
        this.resources.registerAttributeChangeListener(this.getSearchResult().getInput(), this.autoUpdateListener);
        this.resources.registerPropertyChangeListener(WorkbenchCorePlugin.getDefault().getPreferenceStore(), this.autoUpdateListener2);
        Object object3 = (DocumentList)this.panels.get((Object)PanelName.DOCUMENTS).section.getClient();
        new DocumentListSelectionAdapter(this.selectionProvider, (DocumentList)((Object)object3), this);
        this.restoreState();
    }

    private Section createSection(Composite composite) {
        return this.toolkit.createSection(composite, 320);
    }

    private Section createClustersPart(Composite composite, IWorkbenchSite iWorkbenchSite) {
        PanelName panelName = PanelName.CLUSTERS;
        Section section = this.createSection(composite);
        section.setText(panelName.name);
        final ClusterTree clusterTree = new ClusterTree((Composite)section, 0);
        this.resources.add((Widget)clusterTree);
        this.searchResult.addListener(new SearchResultListenerAdapter(){

            @Override
            public void processingResultUpdated(ProcessingResult processingResult) {
                List list = processingResult.getClusters();
                if (list != null && list.size() > 0) {
                    clusterTree.show(list);
                } else {
                    clusterTree.show(Collections.emptyList());
                }
            }
        });
        section.setClient((Control)clusterTree);
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolBar = toolBarManager.createControl((Composite)section);
        toolBarManager.add((IAction)new ActionDelegateProxy((IActionDelegate)new ClusterTreeExpanderAction(ClusterTreeExpanderAction.CollapseAction.EXPAND, clusterTree, this.getSearchResult()), 1));
        toolBarManager.add((IAction)new ActionDelegateProxy((IActionDelegate)new ClusterTreeExpanderAction(ClusterTreeExpanderAction.CollapseAction.COLLAPSE, clusterTree, this.getSearchResult()), 1));
        toolBarManager.update(true);
        section.setTextClient((Control)toolBar);
        return section;
    }

    private Section createDocumentsPart(Composite composite, IWorkbenchSite iWorkbenchSite) {
        PanelName panelName = PanelName.DOCUMENTS;
        Section section = this.createSection(composite);
        section.setText(panelName.name);
        final DocumentList documentList = new DocumentList((Composite)section, 0);
        this.resources.add((Widget)documentList);
        this.searchResult.addListener(new SearchResultListenerAdapter(){

            @Override
            public void processingResultUpdated(ProcessingResult processingResult) {
                documentList.show(processingResult);
            }
        });
        section.setClient((Control)documentList);
        return section;
    }

    private Section createAttributesPart(Composite composite, IWorkbenchSite iWorkbenchSite) {
        PanelName panelName = PanelName.ATTRIBUTES;
        Section section = this.createSection(composite);
        section.setText(panelName.name);
        BindableDescriptor bindableDescriptor = this.getAlgorithmDescriptor();
        CScrolledComposite cScrolledComposite = new CScrolledComposite((Composite)section, 768);
        this.resources.add((Widget)cScrolledComposite);
        Composite composite2 = GUIFactory.createSpacer((Composite)cScrolledComposite);
        this.resources.add((Widget)composite2);
        String string = this.getPartProperty(GROUPING_LOCAL);
        BindableDescriptor.GroupingMethod groupingMethod = BindableDescriptor.GroupingMethod.valueOf((String)string);
        Map map = this.getSearchResult().getInput().getAttributeValueSet().getAttributeValues();
        this.attributesPanel = new AttributeGroups(composite2, bindableDescriptor, groupingMethod, null, map);
        this.attributesPanel.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
        this.resources.add((Widget)this.attributesPanel);
        this.toolkit.paintBordersFor((Composite)cScrolledComposite);
        this.toolkit.adapt((Composite)cScrolledComposite);
        cScrolledComposite.setExpandHorizontal(true);
        cScrolledComposite.setExpandVertical(false);
        cScrolledComposite.setContent((Control)composite2);
        final AttributeListenerAdapter attributeListenerAdapter = new AttributeListenerAdapter(){

            @Override
            public void valueChanged(AttributeEvent attributeEvent) {
                SearchEditor.this.getSearchResult().getInput().setAttribute(attributeEvent.key, attributeEvent.value);
            }
        };
        this.attributesPanel.addAttributeListener(attributeListenerAdapter);
        AttributeListenerAdapter attributeListenerAdapter2 = new AttributeListenerAdapter(){

            @Override
            public void valueChanged(AttributeEvent attributeEvent) {
                SearchEditor.this.attributesPanel.removeAttributeListener(attributeListenerAdapter);
                SearchEditor.this.attributesPanel.setAttribute(attributeEvent.key, attributeEvent.value);
                SearchEditor.this.attributesPanel.addAttributeListener(attributeListenerAdapter);
            }
        };
        this.getSearchResult().getInput().addAttributeListener(attributeListenerAdapter2);
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolBar = toolBarManager.createControl((Composite)section);
        IWorkbenchWindow iWorkbenchWindow = this.getSite().getWorkbenchWindow();
        toolBarManager.add((IAction)WorkbenchActionFactory.AUTO_UPDATE_ACTION.create(iWorkbenchWindow));
        GroupingMethodAction groupingMethodAction = new GroupingMethodAction(GROUPING_LOCAL, (IWorkbenchPart3)this);
        toolBarManager.add((IAction)groupingMethodAction);
        SaveAlgorithmAttributesAction saveAlgorithmAttributesAction = new SaveAlgorithmAttributesAction(this.getSearchResult().getInput());
        toolBarManager.add((IAction)saveAlgorithmAttributesAction);
        toolBarManager.update(true);
        section.setTextClient((Control)toolBar);
        this.addPartPropertyListener(new PropertyChangeListenerAdapter(GROUPING_LOCAL){

            @Override
            protected void propertyChangeFiltered(PropertyChangeEvent propertyChangeEvent) {
                IPreferenceStore iPreferenceStore = WorkbenchCorePlugin.getDefault().getPreferenceStore();
                String string = SearchEditor.this.getPartProperty(SearchEditor.GROUPING_LOCAL);
                iPreferenceStore.setValue("search-editor.layout", string);
                SearchEditor.this.updateGroupingState(BindableDescriptor.GroupingMethod.valueOf((String)string));
                Utils.adaptToFormUI(SearchEditor.this.toolkit, (Control)SearchEditor.this.attributesPanel);
                if (!((PanelReference)((SearchEditor)SearchEditor.this).panels.get((Object)((Object)PanelName.ATTRIBUTES))).state.visibility) {
                    SearchEditor.this.setPanelVisibility(PanelName.ATTRIBUTES, true);
                }
            }
        });
        Utils.adaptToFormUI(this.toolkit, (Control)this.attributesPanel);
        Utils.adaptToFormUI(this.toolkit, (Control)cScrolledComposite);
        section.setClient((Control)cScrolledComposite);
        return section;
    }

    BindableDescriptor getAlgorithmDescriptor() {
        String string;
        WorkbenchCorePlugin workbenchCorePlugin = WorkbenchCorePlugin.getDefault();
        BindableDescriptor bindableDescriptor = workbenchCorePlugin.getComponentDescriptor(string = this.getSearchResult().getInput().getAlgorithmId());
        if (bindableDescriptor == null) {
            throw new RuntimeException("No descriptor for algorithm: " + string);
        }
        return bindableDescriptor.only(new Class[]{Input.class, Processing.class}).only(Predicates.not((Predicate)new InternalAttributePredicate(Boolean.valueOf(false))));
    }

    private void createJobs() {
        String string = this.getAbbreviatedInputTitle(this.searchResult);
        this.searchJob = new SearchJob("Searching for '" + string + "'...", this.searchResult);
        this.searchJob.setPriority(50);
        this.searchJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent iJobChangeEvent) {
                this.setBusy(true);
            }

            public void done(IJobChangeEvent iJobChangeEvent) {
                this.setBusy(false);
            }

            private void setBusy(final boolean bl) {
                Utils.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!SearchEditor.this.rootForm.isDisposed()) {
                            SearchEditor.this.rootForm.setBusy(bl);
                        }
                    }
                });
            }
        });
    }

    private IToolBarManager createToolbarManager(Section section) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolBar = toolBarManager.createControl((Composite)section);
        final Cursor cursor = new Cursor((Device)Display.getCurrent(), 21);
        toolBar.setCursor(cursor);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (cursor != null && !cursor.isDisposed()) {
                    cursor.dispose();
                }
            }
        });
        section.setTextClient((Control)toolBar);
        return toolBarManager;
    }

    public static enum PanelName {
        CLUSTERS("Clusters", "org.carrot2.workbench.core.views.clusters"),
        DOCUMENTS("Documents", "org.carrot2.workbench.core.views.documents"),
        ATTRIBUTES("Attributes", "org.carrot2.workbench.core.views.attributes");

        public final String name;
        public final String iconID;
        public final String prefKeyVisibility;
        public final String prefKeyWeight;

        private PanelName(String string2, String string3) {
            this.name = string2;
            this.iconID = string3;
            String string4 = String.valueOf(PanelName.class.getName()) + "." + string2;
            this.prefKeyVisibility = String.valueOf(string4) + ".visibility";
            this.prefKeyWeight = String.valueOf(string4) + ".weight";
        }
    }

    static final class PanelReference {
        private final Section section;
        private final int sashIndex;
        PanelState state;

        PanelReference(Section section, int n) {
            this.section = section;
            this.sashIndex = n;
        }
    }

    @Root
    public static final class PanelState {
        @Element
        public int weight;
        @Element
        public boolean visibility;
    }

    @Root(name="save-dialog-options")
    public static final class SaveOptions
    implements Cloneable {
        @Transient
        private static final String GLOBAL_OPTIONS_PREFKEY = String.valueOf(SearchEditorSaveAsDialog.class.getName()) + ".saveOptions";
        @Attribute(required=false)
        public String directory;
        @Attribute(required=false)
        public String fileName;
        @Attribute(required=false)
        public Boolean includeDocuments = true;
        @Attribute(required=false)
        public Boolean includeClusters = true;
        @Attribute(required=false)
        public Boolean includeAttributes = false;

        public String getFullPath() {
            Path path = FileDialogs.checkOrDefault(this.directory);
            return new File(path.toFile(), this.fileName).getAbsolutePath();
        }

        public static SaveOptions getGlobalOrDefault() {
            try {
                String string = WorkbenchCorePlugin.getPreferences().get(GLOBAL_OPTIONS_PREFKEY, null);
                if (string != null) {
                    return SimpleXmlMemento.fromString(SaveOptions.class, string);
                }
            }
            catch (IOException iOException) {}
            return new SaveOptions();
        }

        public void saveGlobal() {
            try {
                WorkbenchCorePlugin.getPreferences().put(GLOBAL_OPTIONS_PREFKEY, SimpleXmlMemento.toString(this));
            }
            catch (IOException iOException) {
                Utils.logError(iOException, false);
            }
        }
    }
}

