/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import java.util.Map;
import org.carrot2.workbench.core.WorkbenchCorePlugin;
import org.carrot2.workbench.core.helpers.DisposeBin;
import org.carrot2.workbench.core.helpers.DropDownMenuAction;
import org.carrot2.workbench.core.ui.SearchEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

final class SearchEditorPanelsAction
extends Action {
    private final SearchEditor editor;
    private IMenuCreator menuCreator = new IMenuCreator(){
        private DisposeBin bin = new DisposeBin();

        public Menu getMenu(Control control) {
            Menu menu = this.createItems(new Menu(control));
            this.bin.add((Widget)menu);
            return menu;
        }

        public Menu getMenu(Menu menu) {
            Menu menu2 = this.createItems(new Menu(menu));
            this.bin.add((Widget)menu2);
            return menu2;
        }

        private Menu createItems(Menu menu) {
            for (Map.Entry<SearchEditor.PanelName, SearchEditor.PanelState> menuItem2 : SearchEditorPanelsAction.this.editor.getPanelState().entrySet()) {
                final SearchEditor.PanelName panelName = menuItem2.getKey();
                final MenuItem menuItem = new MenuItem(menu, 32);
                menuItem.setText(panelName.name);
                menuItem.setSelection(menuItem2.getValue().visibility);
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        SearchEditorPanelsAction.this.editor.setPanelVisibility(panelName, menuItem.getSelection());
                        selectionEvent.doit = true;
                    }
                });
            }
            new MenuItem(menu, 2);
            MenuItem menuItem = new MenuItem(menu, 8);
            menuItem.setText("Save as default layout");
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SearchEditorPanelsAction.this.editor.saveAsGlobalState();
                }
            });
            return menu;
        }

        public void dispose() {
            this.bin.dispose();
        }
    };

    SearchEditorPanelsAction(String string, SearchEditor searchEditor) {
        super(string, 4);
        this.editor = searchEditor;
        this.setMenuCreator(this.menuCreator);
        this.setImageDescriptor(WorkbenchCorePlugin.getImageDescriptor("icons/panels.gif"));
    }

    public void runWithEvent(Event event) {
        DropDownMenuAction.showMenu((IAction)this, event);
    }
}

