/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.carrot2.workbench.core.ui.FileDialogs;
import org.carrot2.workbench.core.ui.SearchEditor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

final class SearchEditorSaveAsDialog
extends TrayDialog {
    private Text fileNameText;
    private Button browseButton;
    private Button clusterOption;
    private Button docOption;
    private Button attributesOption;
    public SearchEditor.SaveOptions editorOptions;

    public SearchEditorSaveAsDialog(Shell shell, SearchEditor.SaveOptions saveOptions) {
        super(shell);
        this.editorOptions = saveOptions;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Save as XML");
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent shellEvent) {
                SearchEditorSaveAsDialog.this.validateInput();
            }
        });
    }

    protected void okPressed() {
        File file = new File(this.fileNameText.getText());
        this.editorOptions.directory = file.getParent();
        this.editorOptions.fileName = file.getName();
        this.editorOptions.includeClusters = this.clusterOption.getSelection();
        this.editorOptions.includeDocuments = this.docOption.getSelection();
        this.editorOptions.includeAttributes = this.attributesOption.getSelection();
        this.editorOptions.saveGlobal();
        super.okPressed();
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.createControls(composite2);
        final Path path = new Path(this.editorOptions.getFullPath());
        this.fileNameText.setText(path.toOSString());
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Path path2 = FileDialogs.openSaveXML((IPath)path);
                if (path2 != null) {
                    SearchEditorSaveAsDialog.this.fileNameText.setText(path2.toOSString());
                }
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                SearchEditorSaveAsDialog.this.validateInput();
            }
        };
        this.docOption.addListener(13, listener);
        this.clusterOption.addListener(13, listener);
        this.fileNameText.addListener(24, listener);
        return composite2;
    }

    private void validateInput() {
        boolean bl = false;
        bl |= !this.docOption.getSelection() && !this.clusterOption.getSelection();
        bl = StringUtils.isBlank((String)this.fileNameText.getText()) ? true : (bl |= !new File(this.fileNameText.getText()).getAbsoluteFile().getParentFile().isDirectory());
        this.getButton(0).setEnabled(!bl);
    }

    private void createControls(Composite composite) {
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText("Location:");
        label = new GridData();
        label.horizontalAlignment = 4;
        label.grabExcessHorizontalSpace = true;
        label.verticalAlignment = 4;
        label.horizontalIndent = 5;
        label.minimumWidth = 280;
        label.widthHint = 280;
        this.fileNameText = new Text(composite, 2048);
        this.fileNameText.setLayoutData((Object)label);
        this.browseButton = new Button(composite, 0);
        label = new GridData();
        label.horizontalAlignment = 4;
        label.verticalAlignment = 4;
        this.browseButton.setText("Browse...");
        label.widthHint = this.browseButton.computeSize((int)-1, (int)-1).x + 8;
        this.browseButton.setLayoutData((Object)label);
        this.docOption = this.createCheckbox(composite, "Include documents", this.editorOptions.includeDocuments);
        this.clusterOption = this.createCheckbox(composite, "Include clusters", this.editorOptions.includeClusters);
        this.attributesOption = this.createCheckbox(composite, "Include other attributes", this.editorOptions.includeAttributes);
    }

    private Button createCheckbox(Composite composite, String string, Boolean bl) {
        new Label(composite, 0).setVisible(false);
        Button button = new Button(composite, 16416);
        GridData gridData = new GridData();
        gridData.horizontalIndent = 5;
        gridData.horizontalSpan = 2;
        button.setLayoutData((Object)gridData);
        button.setText(string);
        button.setSelection(bl.booleanValue());
        return button;
    }
}

