/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.carrot2.core.Cluster;
import org.carrot2.core.ProcessingResult;
import org.carrot2.workbench.core.helpers.Utils;
import org.carrot2.workbench.core.ui.ClusterLabelPaths;
import org.carrot2.workbench.core.ui.SearchEditor;
import org.carrot2.workbench.core.ui.SearchResultListenerAdapter;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Display;

public final class SearchEditorSelectionProvider
implements ISelectionProvider {
    private final ArrayList<ISelectionChangedListener> listeners = Lists.newArrayList();
    private BitSet selectedClusters = new BitSet();
    private final Map<Integer, Cluster> clustersById = Maps.newHashMap();
    private final Map<Integer, TreePath> clusterTreePathsById = Maps.newHashMap();
    private ProcessingResult processingResult;

    SearchEditorSelectionProvider(SearchEditor searchEditor) {
        if (searchEditor.getSearchResult().getProcessingResult() != null) {
            this.buildRepresentation(searchEditor.getSearchResult().getProcessingResult());
        } else {
            searchEditor.getSearchResult().addListener(new SearchResultListenerAdapter(){
                ClusterLabelPaths paths;

                @Override
                public void beforeProcessingResultUpdated() {
                    this.paths = null;
                    if (SearchEditorSelectionProvider.this.processingResult != null) {
                        this.paths = ClusterLabelPaths.from(SearchEditorSelectionProvider.this.processingResult.getClusters(), SearchEditorSelectionProvider.this.getSelection().toList());
                    }
                }

                @Override
                public void processingResultUpdated(ProcessingResult processingResult) {
                    SearchEditorSelectionProvider.this.buildRepresentation(processingResult);
                }

                @Override
                public void afterProcessingResultUpdated() {
                    if (this.paths != null) {
                        SearchEditorSelectionProvider.this.setSelected(this.paths.filterMatching(SearchEditorSelectionProvider.this.processingResult.getClusters()), new ISelectionChangedListener[0]);
                    }
                }
            });
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        assert (Display.getCurrent() != null);
        this.listeners.add(iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        assert (Display.getCurrent() != null);
        this.listeners.remove(iSelectionChangedListener);
    }

    public ClusterSelection getSelection() {
        return new ClusterSelection(this);
    }

    public void setSelection(ISelection iSelection, ISelectionChangedListener ... iSelectionChangedListenerArray) {
        if (iSelection.isEmpty()) {
            if (!this.selectedClusters.isEmpty()) {
                this.selectedClusters.clear();
                this.fireSelectionChanged(new ISelectionChangedListener[0]);
            }
            return;
        }
        if (iSelection instanceof IStructuredSelection) {
            BitSet bitSet = SearchEditorSelectionProvider.getClustersFromSelection((IStructuredSelection)iSelection);
            BitSet bitSet2 = (BitSet)this.selectedClusters.clone();
            bitSet2.xor(bitSet);
            if (bitSet2.cardinality() > 0) {
                this.selectedClusters = bitSet;
                this.fireSelectionChanged(iSelectionChangedListenerArray);
            }
            return;
        }
        Utils.logError("Unexpected selection passed to search editor: " + iSelection.getClass(), false);
    }

    static BitSet getClustersFromSelection(IStructuredSelection iStructuredSelection) {
        IStructuredSelection iStructuredSelection2 = iStructuredSelection;
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        BitSet bitSet = new BitSet();
        Object[] objectArray = iStructuredSelection2.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            Cluster cluster = (Cluster)iAdapterManager.getAdapter(object, Cluster.class);
            if (cluster != null) {
                bitSet.set(cluster.getId());
            }
            ++n2;
        }
        return bitSet;
    }

    public void setSelection(ISelection iSelection) {
        this.setSelection(iSelection, new ISelectionChangedListener[0]);
    }

    public void toggleSelected(int n, boolean bl, ISelectionChangedListener ... iSelectionChangedListenerArray) {
        assert (Display.getCurrent() != null);
        if (this.selectedClusters.get(n) == bl) {
            return;
        }
        this.selectedClusters.set(n, bl);
        this.fireSelectionChanged(iSelectionChangedListenerArray);
    }

    public void setSelected(int[] nArray, ISelectionChangedListener ... iSelectionChangedListenerArray) {
        assert (Display.getCurrent() != null);
        this.selectedClusters.clear();
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            this.selectedClusters.set(n3);
            ++n2;
        }
        this.fireSelectionChanged(iSelectionChangedListenerArray);
    }

    public void setSelected(List<Cluster> list, ISelectionChangedListener ... iSelectionChangedListenerArray) {
        assert (Display.getCurrent() != null);
        int[] nArray = new int[list.size()];
        int n = 0;
        while (n < list.size()) {
            nArray[n] = list.get(n).getId();
            ++n;
        }
        this.setSelected(nArray, iSelectionChangedListenerArray);
    }

    private void fireSelectionChanged(ISelectionChangedListener ... iSelectionChangedListenerArray) {
        assert (Display.getCurrent() != null);
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.getSelection());
        ArrayList arrayList = Lists.newArrayList(this.listeners);
        arrayList.removeAll(Arrays.asList(iSelectionChangedListenerArray));
        for (ISelectionChangedListener iSelectionChangedListener : arrayList) {
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
        }
    }

    private void buildRepresentation(ProcessingResult processingResult) {
        this.selectedClusters.clear();
        this.clustersById.clear();
        this.clusterTreePathsById.clear();
        this.processingResult = processingResult;
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        this.descend(processingResult.getClusters(), arrayList);
    }

    private void descend(List<Cluster> list, List<Cluster> list2) {
        for (Cluster cluster : list) {
            list2.add(cluster);
            this.clusterTreePathsById.put(cluster.getId(), new TreePath(list2.toArray()));
            this.clustersById.put(cluster.getId(), cluster);
            this.descend(cluster.getSubclusters(), list2);
            list2.remove(list2.size() - 1);
        }
    }

    public final class ClusterSelection
    implements IStructuredSelection {
        private final ArrayList<Cluster> selected;
        public final TreeSelection treeSelection;

        ClusterSelection(SearchEditorSelectionProvider searchEditorSelectionProvider2) {
            this.selected = Lists.newArrayListWithCapacity((int)searchEditorSelectionProvider2.selectedClusters.cardinality());
            int n = searchEditorSelectionProvider2.selectedClusters.nextSetBit(0);
            while (n >= 0) {
                this.selected.add((Cluster)searchEditorSelectionProvider2.clustersById.get(n));
                n = searchEditorSelectionProvider2.selectedClusters.nextSetBit(n + 1);
            }
            this.treeSelection = this.createTreeSelection();
        }

        public Object getFirstElement() {
            return this.selected.get(0);
        }

        public Iterator iterator() {
            return this.selected.iterator();
        }

        public int size() {
            return this.selected.size();
        }

        public Object[] toArray() {
            return this.selected.toArray(new Cluster[this.selected.size()]);
        }

        public List<Cluster> toList() {
            return Lists.newArrayList(this.selected);
        }

        public boolean isEmpty() {
            return this.selected.isEmpty();
        }

        private TreeSelection createTreeSelection() {
            TreePath[] treePathArray = new TreePath[this.selected.size()];
            int n = 0;
            while (n < this.selected.size()) {
                treePathArray[n] = (TreePath)SearchEditorSelectionProvider.this.clusterTreePathsById.get(this.selected.get(n).getId());
                ++n;
            }
            return new TreeSelection(treePathArray);
        }

        public String toString() {
            return this.treeSelection.toString();
        }
    }
}

