/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang.ObjectUtils;
import org.carrot2.util.attribute.AttributeValueSet;
import org.carrot2.workbench.core.WorkbenchCorePlugin;
import org.carrot2.workbench.core.ui.SearchInputFactory;
import org.carrot2.workbench.editors.AttributeEvent;
import org.carrot2.workbench.editors.IAttributeEventProvider;
import org.carrot2.workbench.editors.IAttributeListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class SearchInput
implements IEditorInput,
IPersistableElement,
IAttributeEventProvider {
    private final String sourceId;
    private final String algorithmId;
    private final AttributeValueSet attributes;
    private final List<IAttributeListener> listeners = new CopyOnWriteArrayList<IAttributeListener>();

    public SearchInput(String string, String string2, AttributeValueSet attributeValueSet) {
        this.sourceId = string;
        this.algorithmId = string2;
        this.attributes = attributeValueSet;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getAlgorithmId() {
        return this.algorithmId;
    }

    public AttributeValueSet getAttributeValueSet() {
        return this.attributes;
    }

    public boolean setAttribute(String string, Object object, boolean bl) {
        Object object2 = this.getAttribute(string);
        if (ObjectUtils.equals((Object)object2, (Object)object)) {
            return false;
        }
        this.attributes.setAttributeValue(string, object);
        if (bl) {
            this.fireAttributeChanged(string, object);
        }
        return true;
    }

    public void setAttribute(String string, Object object) {
        this.setAttribute(string, object, true);
    }

    public Object getAttribute(String string) {
        return this.getAttributeValueSet().getAttributeValue(string);
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return WorkbenchCorePlugin.getDefault().getComponentImageDescriptor(this.getSourceId());
    }

    public String getName() {
        return "SearchInput [source: " + this.sourceId + ", algorithm: " + this.algorithmId + "]";
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        return "Search input";
    }

    public Object getAdapter(Class clazz) {
        if (clazz.isInstance(this)) {
            return this;
        }
        return null;
    }

    public String getFactoryId() {
        return "org.carrot2.workbench.core.searchParametersFactory";
    }

    public void saveState(IMemento iMemento) {
        SearchInputFactory.saveState(this, iMemento);
    }

    @Override
    public void addAttributeListener(IAttributeListener iAttributeListener) {
        this.listeners.add(iAttributeListener);
    }

    @Override
    public void removeAttributeListener(IAttributeListener iAttributeListener) {
        this.listeners.remove(iAttributeListener);
    }

    public void fireAttributeChanged(String string, Object object) {
        AttributeEvent attributeEvent = new AttributeEvent(this, string, object);
        for (IAttributeListener iAttributeListener : this.listeners) {
            iAttributeListener.valueChanged(attributeEvent);
        }
    }
}

