/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.carrot2.core.attribute.Processing;
import org.carrot2.util.attribute.AttributeValueSet;
import org.carrot2.util.attribute.AttributeValueSets;
import org.carrot2.util.attribute.BindableDescriptor;
import org.carrot2.util.attribute.Input;
import org.carrot2.workbench.core.WorkbenchCorePlugin;
import org.carrot2.workbench.core.helpers.Utils;
import org.carrot2.workbench.core.ui.SearchInput;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;

public final class SearchInputFactory
implements IElementFactory {
    private static final String ID_ATTRIBUTE = "id";
    private static final String ALGORITHM_ELEMENT = "algorithm";
    private static final String SOURCE_ELEMENT = "source";
    private static final String ATTRIBUTES_ELEMENT = "attributes";
    public static final String ID = "org.carrot2.workbench.core.searchParametersFactory";

    public IAdaptable createElement(IMemento iMemento) {
        String string = this.tryGetStringFrom(iMemento, SOURCE_ELEMENT, ID_ATTRIBUTE);
        String string2 = this.tryGetStringFrom(iMemento, ALGORITHM_ELEMENT, ID_ATTRIBUTE);
        if (StringUtils.isBlank((String)string) || StringUtils.isBlank((String)string2)) {
            return null;
        }
        AttributeValueSet attributeValueSet = null;
        try {
            String string3;
            IMemento iMemento2 = iMemento.getChild(ATTRIBUTES_ELEMENT);
            if (iMemento2 != null && (string3 = iMemento2.getTextData()) != null) {
                AttributeValueSets attributeValueSets = AttributeValueSets.deserialize((InputStream)new ByteArrayInputStream(string3.getBytes("UTF-8")));
                attributeValueSet = attributeValueSets.getDefaultAttributeValueSet();
            }
        }
        catch (Exception exception) {
            Utils.logError(exception, false);
        }
        if (attributeValueSet == null) {
            attributeValueSet = new AttributeValueSet("defaults");
        }
        SearchInput searchInput = new SearchInput(string, string2, attributeValueSet);
        return searchInput;
    }

    private String tryGetStringFrom(IMemento iMemento, String string, String string2) {
        IMemento iMemento2 = iMemento.getChild(string);
        if (iMemento2 != null) {
            return iMemento2.getString(string2);
        }
        return null;
    }

    static void saveState(SearchInput searchInput, IMemento iMemento) {
        iMemento.createChild(SOURCE_ELEMENT).putString(ID_ATTRIBUTE, searchInput.getSourceId());
        iMemento.createChild(ALGORITHM_ELEMENT).putString(ID_ATTRIBUTE, searchInput.getAlgorithmId());
        try {
            Object object2;
            String string2;
            WorkbenchCorePlugin workbenchCorePlugin = WorkbenchCorePlugin.getDefault();
            Map map = searchInput.getAttributeValueSet().getAttributeValues();
            AttributeValueSet attributeValueSet = new AttributeValueSet("memento-saved");
            BindableDescriptor bindableDescriptor = workbenchCorePlugin.getComponentDescriptor(searchInput.getSourceId()).flatten().only(new Class[]{Input.class, Processing.class});
            for (String string2 : bindableDescriptor.attributeDescriptors.keySet()) {
                if (!map.containsKey(string2)) continue;
                attributeValueSet.setAttributeValue(string2, map.get(string2));
            }
            string2 = workbenchCorePlugin.getComponentDescriptor(searchInput.getAlgorithmId()).flatten().only(new Class[]{Input.class, Processing.class});
            for (Object object2 : ((BindableDescriptor)string2).attributeDescriptors.keySet()) {
                if (!map.containsKey(object2)) continue;
                attributeValueSet.setAttributeValue((String)object2, map.get(object2));
            }
            object2 = new ByteArrayOutputStream();
            AttributeValueSets attributeValueSets = new AttributeValueSets();
            attributeValueSets.addAttributeValueSet("default", attributeValueSet);
            attributeValueSets.serialize((OutputStream)object2);
            ((ByteArrayOutputStream)object2).close();
            iMemento.createChild(ATTRIBUTES_ELEMENT).putTextData(new String(((ByteArrayOutputStream)object2).toByteArray(), "UTF-8"));
        }
        catch (Exception exception) {
            Utils.logError(exception, false);
        }
    }
}

