/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.carrot2.core.DocumentSourceDescriptor;
import org.carrot2.core.ProcessingComponentDescriptor;
import org.carrot2.core.ProcessingComponentSuite;
import org.carrot2.core.attribute.Processing;
import org.carrot2.util.attribute.AnnotationsPredicate;
import org.carrot2.util.attribute.AttributeDescriptor;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.AttributeValueSet;
import org.carrot2.util.attribute.BindableDescriptor;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Required;
import org.carrot2.workbench.core.WorkbenchCorePlugin;
import org.carrot2.workbench.core.helpers.ActionDelegateProxy;
import org.carrot2.workbench.core.helpers.GUIFactory;
import org.carrot2.workbench.core.helpers.SimpleXmlMemento;
import org.carrot2.workbench.core.helpers.Utils;
import org.carrot2.workbench.core.ui.AttributeGroups;
import org.carrot2.workbench.core.ui.PropertyChangeListenerAdapter;
import org.carrot2.workbench.core.ui.SaveDocumentSourceAttributesAction;
import org.carrot2.workbench.core.ui.SearchEditor;
import org.carrot2.workbench.core.ui.SearchInput;
import org.carrot2.workbench.core.ui.SearchInputViewMemento;
import org.carrot2.workbench.core.ui.actions.ActiveSearchEditorActionDelegate;
import org.carrot2.workbench.core.ui.actions.GroupingMethodAction;
import org.carrot2.workbench.core.ui.widgets.CScrolledComposite;
import org.carrot2.workbench.editors.AttributeEvent;
import org.carrot2.workbench.editors.AttributeListenerAdapter;
import org.eclipse.core.commands.operations.OperationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class SearchInputView
extends ViewPart {
    public static final String ID = "org.carrot2.workbench.core.views.search";
    private static final Predicate<AttributeDescriptor> SHOW_REQUIRED = new AnnotationsPredicate(false, new Class[]{Required.class});
    private static final Predicate<AttributeDescriptor> SHOW_ALL = Predicates.alwaysTrue();
    private SearchInputViewMemento state;
    private ComboViewer sourceViewer;
    private ComboViewer algorithmViewer;
    private Button processButton;
    private CScrolledComposite scroller;
    private Composite editorCompositeContainer;
    private AttributeGroups attributeGroups;
    private final AttributeValueSet attributes = new AttributeValueSet("global");
    private Map<String, BindableDescriptor> descriptors = Maps.newHashMap();
    private HashMap<String, DocumentSourceDescriptor> sources;
    private HashMap<String, ProcessingComponentDescriptor> algorithms;
    private boolean linkWithEditor = false;
    private ISelectionChangedListener sourceSelectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            DocumentSourceDescriptor documentSourceDescriptor = (DocumentSourceDescriptor)((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
            SearchInputView.this.setSourceId(documentSourceDescriptor.getId());
        }
    };
    private IAction linkWithEditorAction;
    private CLabel validationStatus;
    private boolean showValidationStatus;
    private Image errorStatusImage = WorkbenchCorePlugin.getImageDescriptor("icons/error.gif").createImage();

    public void init(IViewSite iViewSite) throws PartInitException {
        super.init(iViewSite);
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.createToolbar(iActionBars.getToolBarManager());
        iActionBars.updateActionBars();
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        this.state = null;
        try {
            if (iMemento != null) {
                this.state = SimpleXmlMemento.getChild(SearchInputViewMemento.class, iMemento);
            }
        }
        catch (IOException iOException) {
            Utils.logError(iOException, false);
            this.state = null;
        }
    }

    private void createToolbar(IToolBarManager iToolBarManager) {
        ActionDelegateProxy actionDelegateProxy = new ActionDelegateProxy((IActionDelegate)new LinkWithEditorActionDelegate(), 2);
        actionDelegateProxy.setImageDescriptor(WorkbenchCorePlugin.getImageDescriptor("icons/link_e.gif"));
        actionDelegateProxy.setToolTipText("Link the interface with current editor");
        iToolBarManager.add((IAction)actionDelegateProxy);
        this.linkWithEditorAction = actionDelegateProxy;
        ShowOptionalAction showOptionalAction = new ShowOptionalAction();
        iToolBarManager.add((IAction)showOptionalAction);
        iToolBarManager.add((IAction)new GroupingMethodAction("search-input-view.layout"));
        iToolBarManager.add((IAction)new SaveDocumentSourceAttributesAction(this));
    }

    public void createPartControl(Composite composite) {
        this.createComponents(composite);
        this.processButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = SearchInputView.this.getSourceId();
                if (SearchInputView.this.hasAllRequiredAttributes(string)) {
                    SearchInputView.this.fireProcessing();
                } else {
                    SearchInputView.this.showValidationStatus = true;
                    SearchInputView.this.checkAllRequiredAttributes();
                }
            }
        });
        composite.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 4) {
                    traverseEvent.doit = false;
                    traverseEvent.detail = 0;
                    SearchInputView.this.fireProcessing();
                }
            }
        });
        IPreferenceStore iPreferenceStore = WorkbenchCorePlugin.getDefault().getPreferenceStore();
        iPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)new PropertyChangeListenerAdapter("search-input-view.show-required"){

            @Override
            public void propertyChangeFiltered(PropertyChangeEvent propertyChangeEvent) {
                SearchInputView.this.displayEditorSet();
            }
        });
        iPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)new PropertyChangeListenerAdapter("search-input-view.layout"){

            @Override
            public void propertyChangeFiltered(PropertyChangeEvent propertyChangeEvent) {
                SearchInputView.this.displayEditorSet();
            }
        });
    }

    private void displayEditorSet() {
        IPreferenceStore iPreferenceStore = WorkbenchCorePlugin.getDefault().getPreferenceStore();
        Predicate<AttributeDescriptor> predicate = iPreferenceStore.getBoolean("search-input-view.show-required") ? SHOW_ALL : SHOW_REQUIRED;
        this.editorCompositeContainer.setRedraw(false);
        Map<String, Boolean> map = Collections.emptyMap();
        if (this.attributeGroups != null) {
            map = this.attributeGroups.getExpansionStates();
            this.attributeGroups.dispose();
            this.attributeGroups = null;
        }
        IPreferenceStore iPreferenceStore2 = WorkbenchCorePlugin.getDefault().getPreferenceStore();
        String string = this.getSourceId();
        BindableDescriptor.GroupingMethod groupingMethod = BindableDescriptor.GroupingMethod.valueOf((String)iPreferenceStore2.getString("search-input-view.layout"));
        BindableDescriptor bindableDescriptor = this.descriptors.get(string);
        if (StringUtils.isEmpty((String)this.getSourceId())) {
            Label label = new Label(this.editorCompositeContainer, 0x1000000);
            label.setText("No active sources");
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)gridData);
        } else {
            this.attributeGroups = new AttributeGroups(this.editorCompositeContainer, bindableDescriptor, groupingMethod, predicate, this.attributes.getAttributeValues());
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.attributeGroups.setLayoutData(gridData);
            this.attributeGroups.setExpanded(map);
            HashMap hashMap = bindableDescriptor.getDefaultValues();
            for (Map.Entry entry : hashMap.entrySet()) {
                if (this.attributes.getAttributeValue((String)entry.getKey()) != null) continue;
                this.attributes.setAttributeValue((String)entry.getKey(), entry.getValue());
            }
            this.attributeGroups.setAttributes(this.filterAttributesOf(string));
            this.attributeGroups.addAttributeListener(new AttributeListenerAdapter(){

                @Override
                public void valueChanged(AttributeEvent attributeEvent) {
                    if (attributeEvent.key.equals("enable.validation.overlays")) {
                        return;
                    }
                    SearchInputView.this.attributes.setAttributeValue(attributeEvent.key, attributeEvent.value);
                    SearchInputView.this.checkAllRequiredAttributes();
                }

                @Override
                public void valueChanging(AttributeEvent attributeEvent) {
                    this.valueChanged(attributeEvent);
                }
            });
        }
        this.editorCompositeContainer.setRedraw(true);
        this.editorCompositeContainer.layout(true);
        this.checkAllRequiredAttributes();
        this.scroller.reflow(true);
    }

    private void createComponents(Composite composite) {
        DocumentSourceDescriptor documentSourceDescriptor2;
        WorkbenchCorePlugin workbenchCorePlugin = WorkbenchCorePlugin.getDefault();
        composite.setLayout((Layout)new FillLayout());
        this.scroller = new CScrolledComposite(composite, 768);
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(false);
        Composite composite2 = GUIFactory.createSpacer((Composite)this.scroller);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        this.scroller.setContent((Control)composite2);
        ProcessingComponentSuite processingComponentSuite = workbenchCorePlugin.getComponentSuite();
        this.sourceViewer = this.createComboViewer(composite2, "Source", processingComponentSuite.getSources());
        this.sourceViewer.addSelectionChangedListener(this.sourceSelectionListener);
        this.sources = Maps.newHashMap();
        for (DocumentSourceDescriptor documentSourceDescriptor2 : processingComponentSuite.getSources()) {
            try {
                this.sources.put(documentSourceDescriptor2.getId(), documentSourceDescriptor2);
                this.addFilteredDescriptor((ProcessingComponentDescriptor)documentSourceDescriptor2);
            }
            catch (Exception exception) {
                Utils.logError("Could not initialize source: " + documentSourceDescriptor2.getId(), false);
            }
        }
        this.algorithmViewer = this.createComboViewer(composite2, "Algorithm", processingComponentSuite.getAlgorithms());
        this.algorithms = Maps.newHashMap();
        for (DocumentSourceDescriptor documentSourceDescriptor2 : processingComponentSuite.getAlgorithms()) {
            this.algorithms.put(documentSourceDescriptor2.getId(), (ProcessingComponentDescriptor)documentSourceDescriptor2);
            this.addFilteredDescriptor((ProcessingComponentDescriptor)documentSourceDescriptor2);
        }
        documentSourceDescriptor2 = new Label(composite2, 258);
        documentSourceDescriptor2.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).minSize(-1, 10).create());
        this.editorCompositeContainer = new Composite(composite2, 0);
        this.editorCompositeContainer.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        this.editorCompositeContainer.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).grab(true, false).create());
        composite3.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).spacing(3, 0).create());
        this.validationStatus = new CLabel(composite3, 16384);
        this.validationStatus.setLayoutData((Object)GridDataFactory.fillDefaults().hint(250, -1).grab(true, false).create());
        this.processButton = new Button(composite3, 8);
        this.processButton.setText("Process");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 3;
        gridData.horizontalSpan = 1;
        this.processButton.setLayoutData((Object)gridData);
        this.restoreState();
        this.displayEditorSet();
        if (this.attributeGroups != null) {
            if (this.state != null) {
                if (this.state.sectionsExpansionState != null) {
                    this.attributeGroups.setExpanded(this.state.sectionsExpansionState);
                }
            } else {
                this.attributeGroups.setExpanded(false);
                this.attributeGroups.setExpanded(AttributeLevel.BASIC.toString(), true);
            }
        }
    }

    private void addFilteredDescriptor(ProcessingComponentDescriptor processingComponentDescriptor) {
        WorkbenchCorePlugin workbenchCorePlugin = WorkbenchCorePlugin.getDefault();
        this.descriptors.put(processingComponentDescriptor.getId(), workbenchCorePlugin.getComponentDescriptor(processingComponentDescriptor.getId()).only(new Class[]{Input.class, Processing.class}));
    }

    private ComboViewer createComboViewer(Composite composite, String string, List<? extends ProcessingComponentDescriptor> list) {
        Label label = new Label(composite, 0x1000000);
        label.setLayoutData((Object)new GridData());
        label.setText(string);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        Combo combo = new Combo(composite, 2060);
        combo.setLayoutData((Object)gridData);
        combo.setBackground(Display.getDefault().getSystemColor(1));
        ComboViewer comboViewer = new ComboViewer(combo);
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return ((ProcessingComponentDescriptor)object).getLabel();
            }
        });
        comboViewer.setComparator(new ViewerComparator((Comparator)new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.toLowerCase().compareTo(string2.toLowerCase());
            }
        }));
        comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        comboViewer.setInput(list);
        return comboViewer;
    }

    private void fireProcessing() {
        if (!this.hasAllRequiredAttributes(this.getSourceId())) {
            return;
        }
        IWorkbenchPage iWorkbenchPage = this.getViewSite().getWorkbenchWindow().getActivePage();
        AttributeValueSet attributeValueSet = new AttributeValueSet("request");
        attributeValueSet.setAttributeValues(this.filterAttributesOf(this.getSourceId()));
        attributeValueSet.setAttributeValues(this.filterAttributesOf(this.getAlgorithmId()));
        SearchInput searchInput = new SearchInput(this.getSourceId(), this.getAlgorithmId(), attributeValueSet);
        try {
            iWorkbenchPage.openEditor((IEditorInput)searchInput, "org.carrot2.workbench.core.editors.searchEditor");
        }
        catch (Exception exception) {
            OperationStatus operationStatus = new OperationStatus(4, "org.carrot2.workbench.core", -2, "Editor could not be opened.", (Throwable)exception);
            Utils.showError((IStatus)operationStatus);
        }
    }

    private boolean hasAllRequiredAttributes(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        return this.getEmptyRequiredAttributes(string).isEmpty();
    }

    private Collection<AttributeDescriptor> getEmptyRequiredAttributes(String string) {
        Collection collection = this.descriptors.get((Object)string).flatten().attributeDescriptors.values();
        ArrayList arrayList = Lists.newArrayList();
        for (AttributeDescriptor attributeDescriptor : collection) {
            Object object;
            if (attributeDescriptor.isValid(object = this.attributes.getAttributeValue(attributeDescriptor.key))) continue;
            arrayList.add(attributeDescriptor);
        }
        return arrayList;
    }

    private void checkAllRequiredAttributes() {
        if (!this.showValidationStatus) {
            this.validationStatus.setText("");
            this.validationStatus.setImage(null);
        } else {
            this.attributeGroups.setAttribute("enable.validation.overlays", true);
            String string = this.getSourceId();
            if (!StringUtils.isEmpty((String)string)) {
                Collection<AttributeDescriptor> collection = this.getEmptyRequiredAttributes(string);
                if (collection.size() > 0) {
                    String string2 = collection.iterator().next().metadata.getLabelOrTitle();
                    this.validationStatus.setText("Invalid attribute value: " + string2);
                    this.validationStatus.setImage(this.errorStatusImage);
                } else {
                    this.validationStatus.setText("");
                    this.validationStatus.setImage(null);
                }
            }
        }
    }

    private void restoreState() {
        String string;
        if (this.state != null) {
            this.attributes.setAttributeValues(this.state.attributes.getAttributeValues());
            this.linkWithEditor = this.state.linkWithEditor;
        }
        this.linkWithEditorAction.setChecked(this.linkWithEditor);
        ProcessingComponentDescriptor processingComponentDescriptor = null;
        ProcessingComponentDescriptor processingComponentDescriptor2 = null;
        if (this.state != null) {
            processingComponentDescriptor = (ProcessingComponentDescriptor)this.sources.get(this.state.sourceId);
            processingComponentDescriptor2 = this.algorithms.get(this.state.algorithmId);
        }
        if (processingComponentDescriptor == null) {
            string = WorkbenchCorePlugin.getDefault().getPreferenceStore().getString("DEFAULT_SOURCE_ID");
            processingComponentDescriptor = (ProcessingComponentDescriptor)this.sources.get(string);
        }
        if (processingComponentDescriptor2 == null) {
            string = WorkbenchCorePlugin.getDefault().getPreferenceStore().getString("DEFAULT_ALGORITHM_ID");
            processingComponentDescriptor2 = this.algorithms.get(string);
        }
        this.restoreState(this.sourceViewer, processingComponentDescriptor);
        this.restoreState(this.algorithmViewer, processingComponentDescriptor2);
        if (this.sources.isEmpty()) {
            this.disableComboWithMessage(this.sourceViewer.getCombo(), "No document sources.");
            this.processButton.setEnabled(false);
        }
        if (this.algorithms.isEmpty()) {
            this.disableComboWithMessage(this.algorithmViewer.getCombo(), "No clustering algorithms.");
            this.processButton.setEnabled(false);
        }
    }

    private void restoreState(ComboViewer comboViewer, ProcessingComponentDescriptor processingComponentDescriptor) {
        Collection collection;
        if (processingComponentDescriptor == null && (collection = (Collection)comboViewer.getInput()).size() > 0) {
            processingComponentDescriptor = (ProcessingComponentDescriptor)collection.iterator().next();
        }
        if (processingComponentDescriptor != null) {
            comboViewer.setSelection((ISelection)new StructuredSelection((Object)processingComponentDescriptor), true);
        }
    }

    private void disableComboWithMessage(Combo combo, String string) {
        combo.setForeground(Display.getDefault().getSystemColor(3));
        combo.setToolTipText(string);
        combo.setEnabled(false);
    }

    String getSourceId() {
        return this.getSelectedId(this.sourceViewer);
    }

    private void setSourceId(String string) {
        this.sourceViewer.removeSelectionChangedListener(this.sourceSelectionListener);
        this.sourceViewer.setSelection((ISelection)new StructuredSelection((Object)this.sources.get(string)));
        this.sourceViewer.addSelectionChangedListener(this.sourceSelectionListener);
        this.showValidationStatus = false;
        this.displayEditorSet();
    }

    private String getAlgorithmId() {
        return this.getSelectedId(this.algorithmViewer);
    }

    private void setAlgorithmId(String string) {
        this.algorithmViewer.setSelection((ISelection)new StructuredSelection((Object)this.algorithms.get(string)));
    }

    private String getSelectedId(ComboViewer comboViewer) {
        if (comboViewer.getSelection().isEmpty()) {
            return null;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)comboViewer.getSelection();
        return ((ProcessingComponentDescriptor)iStructuredSelection.getFirstElement()).getId();
    }

    Map<String, Object> filterAttributesOf(String string) {
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap((Map)this.attributes.getAttributeValues());
        linkedHashMap.keySet().retainAll(this.descriptors.get((Object)string).attributeDescriptors.keySet());
        return linkedHashMap;
    }

    void setAttribute(String string, Object object) {
        this.attributes.setAttributeValue(string, object);
        this.attributeGroups.setAttribute(string, object);
    }

    public void saveState(IMemento iMemento) {
        SearchInputViewMemento searchInputViewMemento = new SearchInputViewMemento();
        searchInputViewMemento.sourceId = this.getSourceId();
        searchInputViewMemento.algorithmId = this.getAlgorithmId();
        searchInputViewMemento.linkWithEditor = this.linkWithEditor;
        searchInputViewMemento.attributes = this.attributes;
        if (this.attributeGroups != null) {
            searchInputViewMemento.sectionsExpansionState = this.attributeGroups.getExpansionStates();
        }
        try {
            SimpleXmlMemento.addChild(iMemento, searchInputViewMemento);
        }
        catch (IOException iOException) {
            Utils.logError(iOException, false);
        }
    }

    public void setFocus() {
        if (this.attributeGroups != null) {
            this.attributeGroups.setFocus();
        } else {
            this.sourceViewer.getCombo().setFocus();
        }
    }

    public void dispose() {
        if (this.attributeGroups != null) {
            this.attributeGroups.dispose();
        }
        if (this.errorStatusImage != null) {
            this.errorStatusImage.dispose();
        }
        super.dispose();
    }

    public static SearchInputView getView() {
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        return (SearchInputView)iWorkbenchPage.findView(ID);
    }

    private class LinkWithEditorActionDelegate
    extends ActiveSearchEditorActionDelegate {
        private LinkWithEditorActionDelegate() {
        }

        @Override
        protected void run(SearchEditor searchEditor) {
            SearchInputView.this.linkWithEditor = !SearchInputView.this.linkWithEditor;
            super.getAction().setChecked(SearchInputView.this.linkWithEditor);
            if (SearchInputView.this.linkWithEditor && this.isEnabled(this.getEditor())) {
                this.linkWith((SearchEditor)this.getEditor());
            }
        }

        @Override
        protected boolean isEnabled(IEditorPart iEditorPart) {
            return iEditorPart != null && iEditorPart instanceof SearchEditor;
        }

        @Override
        protected void switchingEditors(IEditorPart iEditorPart, IEditorPart iEditorPart2) {
            super.switchingEditors(iEditorPart, iEditorPart2);
            if (iEditorPart2 != null && SearchInputView.this.linkWithEditor) {
                SearchEditor searchEditor = (SearchEditor)iEditorPart2;
                this.linkWith(searchEditor);
            }
        }

        private void linkWith(SearchEditor searchEditor) {
            SearchInput searchInput = searchEditor.getSearchResult().getInput();
            SearchInputView.this.setAlgorithmId(searchInput.getAlgorithmId());
            SearchInputView.this.attributes.setAttributeValues(searchInput.getAttributeValueSet().getAttributeValues());
            SearchInputView.this.setSourceId(searchInput.getSourceId());
        }
    }

    private static class ShowOptionalAction
    extends Action {
        public ShowOptionalAction() {
            super("Show optional attributes", 2);
            this.setImageDescriptor(WorkbenchCorePlugin.getImageDescriptor("icons/optional.gif"));
            IPreferenceStore iPreferenceStore = WorkbenchCorePlugin.getDefault().getPreferenceStore();
            iPreferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("search-input-view.show-required".equals(propertyChangeEvent.getProperty())) {
                        ShowOptionalAction.this.updateState();
                    }
                }
            });
            this.updateState();
        }

        private void updateState() {
            boolean bl = WorkbenchCorePlugin.getDefault().getPreferenceStore().getBoolean("search-input-view.show-required");
            this.setChecked(bl);
        }

        public void run() {
            IPreferenceStore iPreferenceStore;
            boolean bl = (iPreferenceStore = WorkbenchCorePlugin.getDefault().getPreferenceStore()).getBoolean("search-input-view.show-required");
            iPreferenceStore.setValue("search-input-view.show-required", !bl);
        }
    }
}

