/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import java.util.Map;
import org.carrot2.core.CachingProcessingComponentManager;
import org.carrot2.core.Controller;
import org.carrot2.core.ProcessingComponentDescriptor;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.ProcessingResult;
import org.carrot2.workbench.core.WorkbenchCorePlugin;
import org.carrot2.workbench.core.ui.SearchInput;
import org.carrot2.workbench.core.ui.SearchResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.PlatformUI;

public final class SearchJob
extends Job {
    private final SearchResult searchResult;

    public SearchJob(String string, SearchResult searchResult) {
        super(string);
        this.searchResult = searchResult;
    }

    public SearchJob(SearchResult searchResult) {
        this(searchResult.getInput().getName(), searchResult);
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        Status status;
        SearchInput searchInput = this.searchResult.getInput();
        WorkbenchCorePlugin workbenchCorePlugin = WorkbenchCorePlugin.getDefault();
        ProcessingComponentDescriptor processingComponentDescriptor = workbenchCorePlugin.getComponent(searchInput.getSourceId());
        ProcessingComponentDescriptor processingComponentDescriptor2 = workbenchCorePlugin.getComponent(searchInput.getAlgorithmId());
        iProgressMonitor.beginTask("Processing: " + processingComponentDescriptor.getLabel() + " -> " + processingComponentDescriptor2.getLabel(), -1);
        try {
            try {
                Map map = searchInput.getAttributeValueSet().getAttributeValues();
                Controller controller = workbenchCorePlugin.getController();
                final ProcessingResult processingResult = controller.process(map, new String[]{processingComponentDescriptor.getId(), processingComponentDescriptor2.getId()});
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        SearchJob.this.searchResult.getInput().setAttribute(CachingProcessingComponentManager.CACHE_BYPASS_ATTR, false, false);
                        SearchJob.this.searchResult.setProcessingResult(processingResult);
                    }
                });
                status = Status.OK_STATUS;
            }
            catch (ProcessingException processingException) {
                status = new Status(4, "org.carrot2.workbench.core", "Processing error: " + processingException.getMessage(), (Throwable)processingException);
                iProgressMonitor.done();
            }
        }
        finally {
            iProgressMonitor.done();
        }
        return status;
    }
}

