/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.carrot2.core.ProcessingResult;
import org.carrot2.workbench.core.ui.ISearchResultListener;
import org.carrot2.workbench.core.ui.SearchInput;

public final class SearchResult {
    private final SearchInput input;
    private ProcessingResult result;
    private List<ISearchResultListener> listeners = new CopyOnWriteArrayList<ISearchResultListener>();

    public SearchResult(SearchInput searchInput) {
        this.input = searchInput;
    }

    public SearchInput getInput() {
        return this.input;
    }

    void setProcessingResult(ProcessingResult processingResult) {
        this.result = processingResult;
        this.fireProcessingResultUpdated();
    }

    public ProcessingResult getProcessingResult() {
        return this.result;
    }

    public void addListener(ISearchResultListener iSearchResultListener) {
        this.listeners.add(iSearchResultListener);
    }

    public void removeListener(ISearchResultListener iSearchResultListener) {
        this.listeners.remove(iSearchResultListener);
    }

    private void fireProcessingResultUpdated() {
        for (ISearchResultListener iSearchResultListener : this.listeners) {
            iSearchResultListener.beforeProcessingResultUpdated();
        }
        for (ISearchResultListener iSearchResultListener : this.listeners) {
            iSearchResultListener.processingResultUpdated(this.result);
        }
        for (ISearchResultListener iSearchResultListener : this.listeners) {
            iSearchResultListener.afterProcessingResultUpdated();
        }
    }

    public boolean hasProcessingResult() {
        return this.getProcessingResult() != null;
    }
}

