/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.swt.custom.StyleRange;

final class StyledTextContentBuilder {
    public static final int BOLD = 1;
    private final StringBuilder buffer = new StringBuilder();
    private final List<StyleRange> ranges = Lists.newArrayList();

    StyledTextContentBuilder() {
    }

    public String getText() {
        return this.buffer.toString();
    }

    public StyleRange[] getStyleRanges() {
        return this.ranges.toArray(new StyleRange[this.ranges.size()]);
    }

    public StyledTextContentBuilder print(String string) {
        this.buffer.append(string);
        return this;
    }

    public StyledTextContentBuilder println(String string) {
        this.print(string);
        this.print("\n");
        return this;
    }

    public StyledTextContentBuilder println() {
        this.print("\n");
        return this;
    }

    public StyledTextContentBuilder print(String string, int n) {
        if (string.length() == 0) {
            return this;
        }
        this.print(string);
        StyleRange styleRange = new StyleRange();
        styleRange.start = this.buffer.length() - string.length();
        styleRange.length = string.length();
        styleRange.fontStyle = n;
        this.ranges.add(styleRange);
        return this;
    }

    public StyledTextContentBuilder println(String string, int n) {
        return this.print(String.valueOf(string) + "\n", n);
    }
}

