/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui.actions;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.carrot2.util.CloseableUtils;
import org.carrot2.workbench.core.WorkbenchCorePlugin;
import org.carrot2.workbench.core.ui.actions.IControlProvider;
import org.carrot2.workbench.core.ui.actions.IImageStreamProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ExportImageAction
extends Action {
    private static String SAVE_PNG_PATH = "dialogs.save.png.path";
    private final IImageStreamProvider imageStreamProvider;

    public ExportImageAction(IImageStreamProvider iImageStreamProvider) {
        this.setImageDescriptor(WorkbenchCorePlugin.getImageDescriptor("icons/save_e.gif"));
        this.setToolTipText("Export as PNG");
        this.imageStreamProvider = iImageStreamProvider;
    }

    public ExportImageAction(final IControlProvider iControlProvider) {
        this(new IImageStreamProvider(){

            @Override
            public void save(OutputStream outputStream) throws IOException {
                Control control = iControlProvider.getControl();
                GC gC = new GC((Drawable)control);
                Image image = new Image((Device)control.getDisplay(), control.getBounds());
                gC.copyArea(image, 0, 0);
                gC.dispose();
                ImageLoader imageLoader = new ImageLoader();
                imageLoader.data = new ImageData[]{image.getImageData()};
                imageLoader.save(outputStream, 5);
                image.dispose();
            }
        });
    }

    public void run() {
        block7: {
            File file = null;
            FileOutputStream fileOutputStream = null;
            try {
                try {
                    file = File.createTempFile("capture", "png");
                    fileOutputStream = new FileOutputStream(file);
                    this.imageStreamProvider.save(fileOutputStream);
                    CloseableUtils.close((Closeable)fileOutputStream);
                    Path path = ExportImageAction.openSavePNG((IPath)new Path("clusters-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".png"));
                    if (path != null) {
                        FileUtils.moveFile((File)file, (File)path.toFile());
                    }
                }
                catch (IOException iOException) {
                    CloseableUtils.close(fileOutputStream);
                    if (file != null) {
                        file.delete();
                    }
                    CloseableUtils.close(fileOutputStream);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                CloseableUtils.close(fileOutputStream);
                throw throwable;
            }
            CloseableUtils.close((Closeable)fileOutputStream);
        }
    }

    public static Path openSavePNG(IPath iPath) {
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        FileDialog fileDialog = new FileDialog(shell, 8192);
        if (iPath != null && !iPath.isEmpty()) {
            if (iPath.segmentCount() >= 2) {
                fileDialog.setFileName(iPath.lastSegment());
                fileDialog.setFilterPath(iPath.removeLastSegments(1).toOSString());
            } else if (iPath.segmentCount() == 1) {
                fileDialog.setFilterPath(WorkbenchCorePlugin.getDefault().getPreferenceStore().getString(SAVE_PNG_PATH));
                fileDialog.setFileName(iPath.lastSegment());
            }
        }
        fileDialog.setFilterExtensions(new String[]{"*.png", "*.*"});
        fileDialog.setFilterNames(new String[]{"PNG Files", "All Files"});
        fileDialog.setOverwrite(true);
        String string = fileDialog.open();
        if (string == null) {
            return null;
        }
        Path path = new Path(string);
        WorkbenchCorePlugin.getDefault().getPreferenceStore().setValue(SAVE_PNG_PATH, path.removeLastSegments(1).toOSString());
        return path;
    }
}

