/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core.ui.actions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.carrot2.core.ProcessingResult;
import org.carrot2.util.CloseableUtils;
import org.carrot2.util.ExceptionUtils;
import org.carrot2.util.xslt.NopURIResolver;
import org.carrot2.workbench.core.helpers.Utils;
import org.carrot2.workbench.core.ui.SearchEditor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;

public final class SaveAsXMLActionDelegate
extends Action {
    private final ProcessingResult results;
    private final SearchEditor.SaveOptions options;
    private final Transformer transformer;

    public SaveAsXMLActionDelegate(ProcessingResult processingResult, SearchEditor.SaveOptions saveOptions) {
        Transformer transformer;
        block8: {
            this.results = processingResult;
            this.options = saveOptions;
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setURIResolver((URIResolver)new NopURIResolver());
            String string = System.getProperty("carrot2.workbench.save-as-xml.xslt");
            FileInputStream fileInputStream = null;
            transformer = null;
            try {
                if (StringUtils.isNotBlank((String)string)) {
                    try {
                        try {
                            fileInputStream = new FileInputStream(string);
                            transformer = transformerFactory.newTransformer(new StreamSource(fileInputStream));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            Utils.showError((IStatus)new Status(2, "org.carrot2.workbench.core", "Could not XSLT stylesheet", (Throwable)fileNotFoundException));
                            transformer = transformerFactory.newTransformer();
                            CloseableUtils.close((Closeable)fileInputStream);
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        CloseableUtils.close(fileInputStream);
                        throw throwable;
                    }
                    CloseableUtils.close((Closeable)fileInputStream);
                    break block8;
                }
                transformer = transformerFactory.newTransformer();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw ExceptionUtils.wrapAsRuntimeException((Throwable)transformerConfigurationException);
            }
        }
        this.transformer = transformer;
    }

    public void run() {
        block6: {
            FileOutputStream fileOutputStream = null;
            try {
                try {
                    File file = new File(this.options.getFullPath());
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    fileOutputStream = new FileOutputStream(file);
                    this.results.serialize((OutputStream)byteArrayOutputStream, this.options.includeDocuments.booleanValue(), this.options.includeClusters.booleanValue(), this.options.includeAttributes.booleanValue());
                    this.transformer.transform(new StreamSource(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())), new StreamResult(fileOutputStream));
                }
                catch (Exception exception) {
                    Utils.showError((IStatus)new Status(4, "org.carrot2.workbench.core", "An error occurred while saving the result.", (Throwable)exception));
                    CloseableUtils.close(fileOutputStream);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                CloseableUtils.close(fileOutputStream);
                throw throwable;
            }
            CloseableUtils.close((Closeable)fileOutputStream);
        }
    }
}

