/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.editors;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.carrot2.util.attribute.AttributeDescriptor;
import org.carrot2.util.attribute.BindableDescriptor;
import org.carrot2.workbench.editors.AttributeEditorInfo;
import org.carrot2.workbench.editors.AttributeEvent;
import org.carrot2.workbench.editors.IAttributeEditor;
import org.carrot2.workbench.editors.IAttributeEventProvider;
import org.carrot2.workbench.editors.IAttributeListener;
import org.eclipse.swt.widgets.Composite;

public abstract class AttributeEditorAdapter
implements IAttributeEditor {
    private final List<IAttributeListener> listeners = new CopyOnWriteArrayList<IAttributeListener>();
    protected AttributeDescriptor descriptor;
    protected BindableDescriptor bindable;
    protected IAttributeEventProvider eventProvider;
    private AttributeEditorInfo attributeEditorInfo;
    private boolean flag1;
    private boolean flag2;

    @Override
    public final AttributeEditorInfo init(BindableDescriptor bindableDescriptor, AttributeDescriptor attributeDescriptor, IAttributeEventProvider iAttributeEventProvider, Map<String, Object> map) {
        this.descriptor = attributeDescriptor;
        this.bindable = bindableDescriptor;
        this.eventProvider = iAttributeEventProvider;
        this.attributeEditorInfo = this.init(map);
        return this.attributeEditorInfo;
    }

    protected abstract AttributeEditorInfo init(Map<String, Object> var1);

    @Override
    public String getAttributeKey() {
        return this.descriptor.key;
    }

    @Override
    public abstract void createEditor(Composite var1, int var2);

    @Override
    public void setFocus() {
    }

    @Override
    public abstract Object getValue();

    @Override
    public abstract void setValue(Object var1);

    @Override
    public void addAttributeListener(IAttributeListener iAttributeListener) {
        this.listeners.add(iAttributeListener);
    }

    @Override
    public void removeAttributeListener(IAttributeListener iAttributeListener) {
        this.listeners.remove(iAttributeListener);
    }

    protected void fireAttributeChanged(AttributeEvent attributeEvent) {
        if (this.flag1) {
            return;
        }
        this.flag1 = true;
        try {
            for (IAttributeListener iAttributeListener : this.listeners) {
                iAttributeListener.valueChanged(attributeEvent);
            }
        }
        finally {
            this.flag1 = false;
        }
    }

    protected void fireContentChanging(AttributeEvent attributeEvent) {
        if (this.flag2) {
            return;
        }
        this.flag2 = true;
        try {
            for (IAttributeListener iAttributeListener : this.listeners) {
                iAttributeListener.valueChanging(attributeEvent);
            }
        }
        finally {
            this.flag2 = false;
        }
    }

    @Override
    public void dispose() {
        this.listeners.clear();
        this.descriptor = null;
    }
}

