/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.editors.factory;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.carrot2.workbench.core.helpers.Utils;
import org.carrot2.workbench.editors.factory.AttributeEditorWrapper;
import org.carrot2.workbench.editors.factory.DedicatedEditorWrapper;
import org.carrot2.workbench.editors.factory.TypeEditorWrapper;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

class AttributeEditorLoader {
    public static final String EXTENSION_NAME = "attributeEditor";
    public static final String EL_TYPE_EDITOR = "type-editor";
    public static final String EL_DEDICATED_EDITOR = "dedicated-editor";
    public static final AttributeEditorLoader INSTANCE = new AttributeEditorLoader();
    private List<DedicatedEditorWrapper> dedicatedEditorsList = new ArrayList<DedicatedEditorWrapper>();
    private List<TypeEditorWrapper> typeEditorsList = new ArrayList<TypeEditorWrapper>();
    public final List<DedicatedEditorWrapper> dedicatedEditors;
    public final List<TypeEditorWrapper> typeEditors;

    private AttributeEditorLoader() {
        this.loadExtensions();
        this.dedicatedEditors = ImmutableList.copyOf(this.dedicatedEditorsList);
        this.typeEditors = ImmutableList.copyOf(this.typeEditorsList);
    }

    List<DedicatedEditorWrapper> filterDedicatedEditors(Predicate<DedicatedEditorWrapper> predicate) {
        return ImmutableList.copyOf((Collection)Collections2.filter(this.dedicatedEditorsList, predicate));
    }

    List<TypeEditorWrapper> filterTypeEditors(Predicate<TypeEditorWrapper> predicate) {
        return ImmutableList.copyOf((Collection)Collections2.filter(this.typeEditorsList, predicate));
    }

    private void loadExtensions() {
        IExtension[] iExtensionArray;
        IExtension[] iExtensionArray2 = iExtensionArray = Platform.getExtensionRegistry().getExtensionPoint("org.carrot2.workbench.core", EXTENSION_NAME).getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension iExtension = iExtensionArray2[n2];
            this.parseExtension(iExtension.getConfigurationElements());
            ++n2;
        }
    }

    private void parseExtension(IConfigurationElement[] iConfigurationElementArray) {
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            try {
                AttributeEditorWrapper attributeEditorWrapper;
                if (iConfigurationElement.getName().equals(EL_DEDICATED_EDITOR)) {
                    attributeEditorWrapper = new DedicatedEditorWrapper(iConfigurationElement);
                    this.dedicatedEditorsList.add((DedicatedEditorWrapper)attributeEditorWrapper);
                } else if (iConfigurationElement.getName().equals(EL_TYPE_EDITOR)) {
                    attributeEditorWrapper = new TypeEditorWrapper(iConfigurationElement);
                    this.typeEditorsList.add((TypeEditorWrapper)attributeEditorWrapper);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Utils.logError("Error while parsing extension " + iConfigurationElement.getDeclaringExtension().getUniqueIdentifier(), illegalArgumentException, false);
            }
            ++n;
        }
    }
}

