/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.editors.factory;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.carrot2.core.IProcessingComponent;
import org.carrot2.util.attribute.AttributeDescriptor;
import org.carrot2.workbench.editors.IAttributeEditor;
import org.carrot2.workbench.editors.factory.AttributeEditorLoader;
import org.carrot2.workbench.editors.factory.DedicatedEditorWrapper;
import org.carrot2.workbench.editors.factory.EditorNotFoundException;
import org.carrot2.workbench.editors.factory.TypeEditorWrapper;

public final class EditorFactory {
    private EditorFactory() {
    }

    public static IAttributeEditor getEditorFor(Class<? extends IProcessingComponent> clazz, AttributeDescriptor attributeDescriptor) {
        IAttributeEditor iAttributeEditor = null;
        if (clazz != null) {
            iAttributeEditor = EditorFactory.findDedicatedEditor(clazz, attributeDescriptor);
        }
        if (iAttributeEditor == null) {
            iAttributeEditor = EditorFactory.findGenericEditor(attributeDescriptor);
        }
        if (iAttributeEditor == null) {
            throw new EditorNotFoundException("No suitable editor found for attribute: " + attributeDescriptor.toString());
        }
        return iAttributeEditor;
    }

    private static IAttributeEditor findGenericEditor(AttributeDescriptor attributeDescriptor) {
        List<TypeEditorWrapper> list = EditorFactory.getCompatibleTypeEditors(attributeDescriptor);
        if (!list.isEmpty()) {
            list = EditorFactory.sortTypeEditors(list, attributeDescriptor);
            return list.get(0).getExecutableComponent();
        }
        return null;
    }

    private static IAttributeEditor findDedicatedEditor(Class<? extends IProcessingComponent> clazz, AttributeDescriptor attributeDescriptor) {
        List<DedicatedEditorWrapper> list = EditorFactory.getCompatibleDedicatedEditors(clazz, attributeDescriptor);
        if (!list.isEmpty()) {
            return list.get(0).getExecutableComponent();
        }
        return null;
    }

    private static List<TypeEditorWrapper> sortTypeEditors(List<TypeEditorWrapper> list, final AttributeDescriptor attributeDescriptor) {
        Object object2;
        ArrayList arrayList = Lists.newArrayList();
        for (Object object2 : attributeDescriptor.constraints) {
            arrayList.add(object2.annotationType().getName());
        }
        object2 = Maps.newHashMap();
        for (TypeEditorWrapper typeEditorWrapper : list) {
            ArrayList arrayList2 = Lists.newArrayList((Iterable)arrayList);
            arrayList2.retainAll(typeEditorWrapper.constraints);
            ((HashMap)object2).put(typeEditorWrapper, arrayList2.size());
        }
        Comparator<TypeEditorWrapper> comparator = new Comparator<TypeEditorWrapper>((HashMap)object2){
            private final /* synthetic */ HashMap val$matchingConstraints;
            {
                this.val$matchingConstraints = hashMap;
            }

            @Override
            public int compare(TypeEditorWrapper typeEditorWrapper, TypeEditorWrapper typeEditorWrapper2) {
                int n = EditorFactory.distance(attributeDescriptor.type, typeEditorWrapper.attributeClass) - EditorFactory.distance(attributeDescriptor.type, typeEditorWrapper2.attributeClass);
                if (n == 0) {
                    n = -((Integer)this.val$matchingConstraints.get(typeEditorWrapper) - (Integer)this.val$matchingConstraints.get(typeEditorWrapper2));
                }
                if (n == 0) {
                    n = -(typeEditorWrapper.constraints.size() - typeEditorWrapper2.constraints.size());
                }
                return n;
            }
        };
        return Ordering.from((Comparator)comparator).sortedCopy(list);
    }

    private static List<TypeEditorWrapper> getCompatibleTypeEditors(final AttributeDescriptor attributeDescriptor) {
        final ArrayList arrayList = Lists.newArrayList();
        for (Annotation annotation : attributeDescriptor.constraints) {
            arrayList.add(annotation.annotationType().getName());
        }
        return AttributeEditorLoader.INSTANCE.filterTypeEditors(new Predicate<TypeEditorWrapper>(){

            public boolean apply(TypeEditorWrapper typeEditorWrapper) {
                boolean bl = EditorFactory.isCompatible(attributeDescriptor.type, typeEditorWrapper.attributeClass);
                if (bl && !typeEditorWrapper.constraints.isEmpty() && typeEditorWrapper.allConstraintsRequired) {
                    bl = arrayList.containsAll(typeEditorWrapper.constraints);
                }
                return bl;
            }
        });
    }

    private static List<DedicatedEditorWrapper> getCompatibleDedicatedEditors(final Class<? extends IProcessingComponent> clazz, final AttributeDescriptor attributeDescriptor) {
        return AttributeEditorLoader.INSTANCE.filterDedicatedEditors(new Predicate<DedicatedEditorWrapper>(){

            public boolean apply(DedicatedEditorWrapper dedicatedEditorWrapper) {
                return EditorFactory.isCompatible(clazz, dedicatedEditorWrapper.componentClass) && dedicatedEditorWrapper.attributeId.equals(attributeDescriptor.key);
            }
        });
    }

    private static boolean isCompatible(Class<?> clazz, String string) {
        List list;
        boolean bl = clazz.getName().equals(string);
        if (!bl) {
            list = ClassUtils.convertClassesToClassNames((List)ClassUtils.getAllSuperclasses(clazz));
            bl = list.contains(string);
        }
        if (!bl && clazz.isInterface()) {
            bl = "java.lang.Object".equals(string);
        }
        if (!bl) {
            list = ClassUtils.convertClassesToClassNames((List)ClassUtils.getAllInterfaces(clazz));
            bl = list.contains(string);
        }
        return bl;
    }

    public static int distance(Class<?> clazz, String string) {
        List list;
        if (clazz.getName().equals(string)) {
            return 0;
        }
        if (string.equals("java.lang.Object")) {
            return Integer.MAX_VALUE;
        }
        int n = Integer.MAX_VALUE;
        List list2 = ClassUtils.convertClassesToClassNames((List)ClassUtils.getAllInterfaces(clazz));
        if (list2.contains(string)) {
            n = Math.min(1, n);
        }
        if ((list = ClassUtils.convertClassesToClassNames((List)ClassUtils.getAllSuperclasses(clazz))).contains(string)) {
            n = Math.min(list.indexOf(string) + 1, n);
        }
        if (n == Integer.MAX_VALUE) {
            throw new RuntimeException("Cannot calculate distance between incompatible classes: " + clazz + ", " + string);
        }
        return n;
    }
}

