/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.velocity;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public final class BundleResourceLoader
extends ResourceLoader {
    public static final String BUNDLE_ID = "bundle.id";
    private Bundle bundle;
    private String prefix;

    public BundleResourceLoader(String string, String string2) {
        this.bundle = this.locateBundle(string);
        this.prefix = string2;
    }

    public InputStream getResourceStream(String string) throws ResourceNotFoundException {
        URL uRL = FileLocator.find((Bundle)this.bundle, (IPath)new Path(String.valueOf(this.prefix) + string), null);
        if (uRL == null) {
            throw new ResourceNotFoundException("Not found: " + string);
        }
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            throw new ResourceNotFoundException("Failed to open: " + string, (Throwable)iOException);
        }
    }

    public void init(ExtendedProperties extendedProperties) {
        if (this.bundle != null) {
            return;
        }
        String string = extendedProperties.getString(BUNDLE_ID, null);
        if (string == null) {
            throw new RuntimeException("Initialize bundle key in Velocity properties: bundle.id");
        }
        this.bundle = this.locateBundle(string);
    }

    public boolean isSourceModified(Resource resource) {
        return false;
    }

    public long getLastModified(Resource resource) {
        return 0L;
    }

    private Bundle locateBundle(String string) {
        Bundle bundle = Platform.getBundle((String)string);
        if (bundle == null) {
            throw new RuntimeException("Bundle not found: " + string);
        }
        return bundle;
    }
}

