/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.clustering.kmeans;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIntHashMap;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.IntIntCursor;
import com.carrotsearch.hppc.sorting.IndirectComparator;
import com.carrotsearch.hppc.sorting.IndirectSort;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.matrix.DoubleMatrix1D;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.impl.DenseDoubleMatrix1D;
import org.apache.mahout.math.matrix.impl.DenseDoubleMatrix2D;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.core.IClusteringAlgorithm;
import org.carrot2.core.LanguageCode;
import org.carrot2.core.ProcessingComponentBase;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.CommonAttributes;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.text.clustering.IMonolingualClusteringAlgorithm;
import org.carrot2.text.clustering.MultilingualClustering;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.pipeline.BasicPreprocessingPipeline;
import org.carrot2.text.preprocessing.pipeline.IPreprocessingPipeline;
import org.carrot2.text.vsm.ReducedVectorSpaceModelContext;
import org.carrot2.text.vsm.TermDocumentMatrixBuilder;
import org.carrot2.text.vsm.TermDocumentMatrixReducer;
import org.carrot2.text.vsm.VectorSpaceModelContext;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.Output;
import org.carrot2.util.attribute.Required;
import org.carrot2.util.attribute.constraint.ImplementingClasses;
import org.carrot2.util.attribute.constraint.IntRange;

@Bindable(prefix="BisectingKMeansClusteringAlgorithm", inherit={CommonAttributes.class})
public class BisectingKMeansClusteringAlgorithm
extends ProcessingComponentBase
implements IClusteringAlgorithm {
    private static final String GROUP_KMEANS = "K-means";
    @Processing
    @Input
    @Required
    @Internal
    @Attribute(key="documents", inherit=true)
    public List<Document> documents;
    @Processing
    @Output
    @Internal
    @Attribute(key="clusters", inherit=true)
    public List<Cluster> clusters = null;
    @Processing
    @Input
    @Attribute
    @IntRange(min=2)
    @Group(value="Clusters")
    @Level(value=AttributeLevel.BASIC)
    @Label(value="Cluster count")
    public int clusterCount = 25;
    @Processing
    @Input
    @Attribute
    @IntRange(min=1)
    @Group(value="K-means")
    @Level(value=AttributeLevel.BASIC)
    @Label(value="Maximum iterations")
    public int maxIterations = 15;
    @Processing
    @Input
    @Attribute
    @Group(value="K-means")
    @Level(value=AttributeLevel.BASIC)
    @Label(value="Use dimensionality reduction")
    public boolean useDimensionalityReduction = true;
    @Processing
    @Input
    @Attribute
    @IntRange(min=2, max=10)
    @Group(value="K-means")
    @Level(value=AttributeLevel.BASIC)
    @Label(value="Partition count")
    public int partitionCount = 2;
    @Processing
    @Input
    @Attribute
    @IntRange(min=1, max=10)
    @Group(value="Clusters")
    @Level(value=AttributeLevel.BASIC)
    @Label(value="Label count")
    public int labelCount = 3;
    @Init
    @Input
    @Attribute
    @Internal
    @ImplementingClasses(classes={}, strict=false)
    @Level(value=AttributeLevel.ADVANCED)
    public IPreprocessingPipeline preprocessingPipeline = new BasicPreprocessingPipeline();
    public final TermDocumentMatrixBuilder matrixBuilder = new TermDocumentMatrixBuilder();
    public final TermDocumentMatrixReducer matrixReducer = new TermDocumentMatrixReducer();
    public final LabelFormatter labelFormatter = new LabelFormatter();
    public final MultilingualClustering multilingualClustering = new MultilingualClustering();
    private static final Comparator<IntArrayList> BY_SIZE_DESCENDING = new Comparator<IntArrayList>(){

        @Override
        public int compare(IntArrayList intArrayList, IntArrayList intArrayList2) {
            return intArrayList2.size() - intArrayList.size();
        }
    };

    public void process() throws ProcessingException {
        List<Document> list = this.documents;
        this.clusters = this.multilingualClustering.process(this.documents, new IMonolingualClusteringAlgorithm(){

            public List<Cluster> process(List<Document> list, LanguageCode languageCode) {
                BisectingKMeansClusteringAlgorithm.this.documents = list;
                BisectingKMeansClusteringAlgorithm.this.cluster(languageCode);
                return BisectingKMeansClusteringAlgorithm.this.clusters;
            }
        });
        this.documents = list;
    }

    protected void cluster(LanguageCode languageCode) {
        PreprocessingContext preprocessingContext = this.preprocessingPipeline.preprocess(this.documents, null, languageCode);
        int[] nArray = preprocessingContext.allStems.mostFrequentOriginalWordIndex;
        short[] sArray = preprocessingContext.allWords.type;
        IntArrayList intArrayList = new IntArrayList(nArray.length);
        int n = 0;
        while (n < nArray.length) {
            short s = sArray[nArray[n]];
            if ((s & 0x3002) == 0) {
                intArrayList.add(nArray[n]);
            }
            ++n;
        }
        preprocessingContext.allLabels.featureIndex = intArrayList.toArray();
        preprocessingContext.allLabels.firstPhraseIndex = -1;
        this.clusters = Lists.newArrayList();
        if (preprocessingContext.hasLabels()) {
            Object object;
            IntIntCursor intIntCursor2;
            VectorSpaceModelContext vectorSpaceModelContext = new VectorSpaceModelContext(preprocessingContext);
            ReducedVectorSpaceModelContext reducedVectorSpaceModelContext = new ReducedVectorSpaceModelContext(vectorSpaceModelContext);
            this.matrixBuilder.buildTermDocumentMatrix(vectorSpaceModelContext);
            this.matrixBuilder.buildTermPhraseMatrix(vectorSpaceModelContext);
            IntIntHashMap intIntHashMap = new IntIntHashMap();
            for (IntIntCursor intIntCursor2 : vectorSpaceModelContext.stemToRowIndex) {
                intIntHashMap.put(intIntCursor2.value, intIntCursor2.key);
            }
            if (this.useDimensionalityReduction && this.clusterCount * 2 < preprocessingContext.documents.size()) {
                this.matrixReducer.reduce(reducedVectorSpaceModelContext, this.clusterCount * 2);
                intIntCursor2 = reducedVectorSpaceModelContext.coefficientMatrix.viewDice();
            } else {
                intIntCursor2 = vectorSpaceModelContext.termDocumentMatrix;
            }
            Iterator iterator = new IntArrayList(intIntCursor2.columns());
            int n2 = 0;
            while (n2 < intIntCursor2.columns()) {
                iterator.add(n2);
                ++n2;
            }
            ArrayList arrayList = Lists.newArrayList();
            arrayList.addAll(this.split(this.partitionCount, (DoubleMatrix2D)intIntCursor2, (IntArrayList)iterator, this.maxIterations));
            Collections.sort(arrayList, BY_SIZE_DESCENDING);
            int n3 = 0;
            while (arrayList.size() < this.clusterCount && n3 < arrayList.size()) {
                IntArrayList intArrayList2 = (IntArrayList)arrayList.get(n3);
                if (intArrayList2.size() <= this.partitionCount * 2) break;
                object = this.split(this.partitionCount, (DoubleMatrix2D)intIntCursor2, intArrayList2, this.maxIterations);
                if (object.size() > 1) {
                    arrayList.remove(n3);
                    arrayList.addAll(object);
                    Collections.sort(arrayList, BY_SIZE_DESCENDING);
                    n3 = 0;
                    continue;
                }
                ++n3;
            }
            int n4 = 0;
            while (n4 < arrayList.size()) {
                object = new Cluster();
                IntArrayList intArrayList3 = (IntArrayList)arrayList.get(n4);
                if (intArrayList3.size() > 1) {
                    object.addPhrases(this.getLabels(intArrayList3, vectorSpaceModelContext.termDocumentMatrix, intIntHashMap, preprocessingContext.allStems.mostFrequentOriginalWordIndex, preprocessingContext.allWords.image));
                    int n5 = 0;
                    while (n5 < intArrayList3.size()) {
                        object.addDocuments(new Document[]{this.documents.get(intArrayList3.get(n5))});
                        ++n5;
                    }
                    this.clusters.add((Cluster)object);
                }
                ++n4;
            }
        }
        Collections.sort(this.clusters, Cluster.BY_REVERSED_SIZE_AND_LABEL_COMPARATOR);
        Cluster.appendOtherTopics(this.documents, this.clusters);
    }

    private List<String> getLabels(IntArrayList intArrayList, DoubleMatrix2D doubleMatrix2D, IntIntHashMap intIntHashMap, int[] nArray, char[][] cArray) {
        ArrayList arrayList2;
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(doubleMatrix2D.rows());
        for (ArrayList arrayList2 : intArrayList) {
            denseDoubleMatrix1D.assign(doubleMatrix2D.viewColumn(((IntCursor)arrayList2).value), Functions.PLUS);
        }
        arrayList2 = Lists.newArrayListWithCapacity((int)this.labelCount);
        Object object = IndirectSort.mergesort((int)0, (int)denseDoubleMatrix1D.size(), (IndirectComparator)new IndirectComparator((DoubleMatrix1D)denseDoubleMatrix1D){
            private final /* synthetic */ DoubleMatrix1D val$centroid;
            {
                this.val$centroid = doubleMatrix1D;
            }

            public int compare(int n, int n2) {
                double d;
                double d2 = this.val$centroid.get(n);
                return d2 < (d = this.val$centroid.get(n2)) ? -1 : (d2 > d ? 1 : 0);
            }
        });
        double d = denseDoubleMatrix1D.get((int)object[((Object)object).length - Math.min(this.labelCount, ((Object)object).length)]);
        int n = 0;
        while (n < denseDoubleMatrix1D.size()) {
            if (denseDoubleMatrix1D.getQuick(n) >= d) {
                arrayList2.add(LabelFormatter.format((char[][])new char[][]{cArray[nArray[intIntHashMap.get(n)]]}, (boolean[])new boolean[1], (boolean)false));
            }
            ++n;
        }
        return arrayList2;
    }

    private List<IntArrayList> split(int n, DoubleMatrix2D doubleMatrix2D, IntArrayList intArrayList, int n2) {
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.viewSelection(null, intArrayList.toArray()).copy();
        IntIntHashMap intIntHashMap = new IntIntHashMap(doubleMatrix2D2.columns());
        int n3 = 0;
        while (n3 < intArrayList.size()) {
            intIntHashMap.put(n3, intArrayList.get(n3));
            ++n3;
        }
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = null;
        int n4 = 0;
        while (n4 < n) {
            arrayList.add(new IntArrayList(doubleMatrix2D2.columns()));
            ++n4;
        }
        n4 = 0;
        while (n4 < doubleMatrix2D2.columns()) {
            ((IntArrayList)arrayList.get(n4 % n)).add(n4);
            ++n4;
        }
        DoubleMatrix2D doubleMatrix2D3 = new DenseDoubleMatrix2D(doubleMatrix2D2.rows(), n).assign(doubleMatrix2D2.viewPart(0, 0, doubleMatrix2D2.rows(), n));
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n, doubleMatrix2D2.columns());
        int n5 = 0;
        while (n5 < n2) {
            int n6 = 0;
            while (n6 < arrayList.size()) {
                IntArrayList intArrayList2 = (IntArrayList)arrayList.get(n6);
                int n7 = 0;
                while (n7 < doubleMatrix2D2.rows()) {
                    double d = 0.0;
                    int n8 = 0;
                    while (n8 < intArrayList2.size()) {
                        d += doubleMatrix2D2.get(n7, intArrayList2.get(n8));
                        ++n8;
                    }
                    doubleMatrix2D3.setQuick(n7, n6, d / (double)intArrayList2.size());
                    ++n7;
                }
                ++n6;
            }
            arrayList2 = arrayList;
            arrayList = Lists.newArrayList();
            n6 = 0;
            while (n6 < n) {
                arrayList.add(new IntArrayList(doubleMatrix2D2.columns()));
                ++n6;
            }
            doubleMatrix2D3.zMult(doubleMatrix2D2, (DoubleMatrix2D)denseDoubleMatrix2D, 1.0, 0.0, true, false);
            n6 = 0;
            while (n6 < denseDoubleMatrix2D.columns()) {
                int n9 = 0;
                double d = denseDoubleMatrix2D.get(0, n6);
                int n10 = 1;
                while (n10 < denseDoubleMatrix2D.rows()) {
                    if (d < denseDoubleMatrix2D.get(n10, n6)) {
                        d = denseDoubleMatrix2D.get(n10, n6);
                        n9 = n10;
                    }
                    ++n10;
                }
                ((IntArrayList)arrayList.get(n9)).add(n6);
                ++n6;
            }
            if (ObjectUtils.equals((Object)arrayList2, (Object)arrayList)) break;
            ++n5;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            IntArrayList intArrayList3 = (IntArrayList)iterator.next();
            if (intArrayList3.isEmpty()) {
                iterator.remove();
                continue;
            }
            int n11 = 0;
            while (n11 < intArrayList3.size()) {
                intArrayList3.set(n11, intIntHashMap.get(intArrayList3.get(n11)));
                ++n11;
            }
        }
        return arrayList;
    }
}

