/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.clustering.kmeans;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.core.attribute.CommonAttributesDescriptor;
import org.carrot2.text.clustering.MultilingualClusteringDescriptor;
import org.carrot2.text.preprocessing.LabelFormatterDescriptor;
import org.carrot2.text.preprocessing.pipeline.IPreprocessingPipeline;
import org.carrot2.text.vsm.TermDocumentMatrixBuilderDescriptor;
import org.carrot2.text.vsm.TermDocumentMatrixReducerDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;

public final class BisectingKMeansClusteringAlgorithmDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.clustering.kmeans.BisectingKMeansClusteringAlgorithm";
    public final String prefix = "BisectingKMeansClusteringAlgorithm";
    public final String title = "A very simple implementation of bisecting k-means clustering";
    public final String label = "";
    public final String description = "Unlike other algorithms in Carrot2, this one creates hard clusterings (one document belongs only to one cluster). On the other hand, the clusters are labeled only with individual words that may not always fully correspond to all documents in the cluster.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    static {
        HashSet<AttributeInfo> hashSet = new HashSet<AttributeInfo>();
        hashSet.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.clusterCount);
        hashSet.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.clusters);
        hashSet.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.documents);
        hashSet.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.labelCount);
        hashSet.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.maxIterations);
        hashSet.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.partitionCount);
        hashSet.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.preprocessingPipeline);
        hashSet.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.useDimensionalityReduction);
        HashSet<AttributeInfo> hashSet2 = new HashSet<AttributeInfo>();
        hashSet2.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.clusterCount);
        hashSet2.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.clusters);
        hashSet2.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.documents);
        hashSet2.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.labelCount);
        hashSet2.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.maxIterations);
        hashSet2.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.partitionCount);
        hashSet2.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.preprocessingPipeline);
        hashSet2.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.useDimensionalityReduction);
        allAttributes = Collections.unmodifiableSet(hashSet2);
        ownAttributes = Collections.unmodifiableSet(hashSet);
        HashMap<String, AttributeInfo> hashMap = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> hashMap2 = new HashMap<String, AttributeInfo>();
        for (AttributeInfo attributeInfo : hashSet2) {
            hashMap.put(attributeInfo.key, attributeInfo);
            hashMap2.put(attributeInfo.fieldName, attributeInfo);
        }
        allAttributesByKey = Collections.unmodifiableMap(hashMap);
        allAttributesByFieldName = Collections.unmodifiableMap(hashMap2);
    }

    public static AttributeBuilder attributeBuilder(Map<String, Object> map) {
        return new AttributeBuilder(map);
    }

    public String getPrefix() {
        return "BisectingKMeansClusteringAlgorithm";
    }

    public String getTitle() {
        return "A very simple implementation of bisecting k-means clustering";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "Unlike other algorithms in Carrot2, this one creates hard clusterings (one document belongs only to one cluster). On the other hand, the clusters are labeled only with individual words that may not always fully correspond to all documents in the cluster.";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder clusterCount(int n) {
            this.map.put("BisectingKMeansClusteringAlgorithm.clusterCount", n);
            return this;
        }

        public AttributeBuilder clusterCount(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("BisectingKMeansClusteringAlgorithm.clusterCount", iObjectFactory);
            return this;
        }

        public List<Cluster> clusters() {
            return (List)this.map.get("clusters");
        }

        public AttributeBuilder documents(List<Document> list) {
            this.map.put("documents", list);
            return this;
        }

        public AttributeBuilder documents(IObjectFactory<? extends List<Document>> iObjectFactory) {
            this.map.put("documents", iObjectFactory);
            return this;
        }

        public AttributeBuilder labelCount(int n) {
            this.map.put("BisectingKMeansClusteringAlgorithm.labelCount", n);
            return this;
        }

        public AttributeBuilder labelCount(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("BisectingKMeansClusteringAlgorithm.labelCount", iObjectFactory);
            return this;
        }

        public AttributeBuilder maxIterations(int n) {
            this.map.put("BisectingKMeansClusteringAlgorithm.maxIterations", n);
            return this;
        }

        public AttributeBuilder maxIterations(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("BisectingKMeansClusteringAlgorithm.maxIterations", iObjectFactory);
            return this;
        }

        public AttributeBuilder partitionCount(int n) {
            this.map.put("BisectingKMeansClusteringAlgorithm.partitionCount", n);
            return this;
        }

        public AttributeBuilder partitionCount(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("BisectingKMeansClusteringAlgorithm.partitionCount", iObjectFactory);
            return this;
        }

        public AttributeBuilder preprocessingPipeline(IPreprocessingPipeline iPreprocessingPipeline) {
            this.map.put("BisectingKMeansClusteringAlgorithm.preprocessingPipeline", iPreprocessingPipeline);
            return this;
        }

        public AttributeBuilder preprocessingPipeline(Class<?> clazz) {
            this.map.put("BisectingKMeansClusteringAlgorithm.preprocessingPipeline", clazz);
            return this;
        }

        public AttributeBuilder preprocessingPipeline(IObjectFactory<? extends IPreprocessingPipeline> iObjectFactory) {
            this.map.put("BisectingKMeansClusteringAlgorithm.preprocessingPipeline", iObjectFactory);
            return this;
        }

        public AttributeBuilder useDimensionalityReduction(boolean bl) {
            this.map.put("BisectingKMeansClusteringAlgorithm.useDimensionalityReduction", bl);
            return this;
        }

        public AttributeBuilder useDimensionalityReduction(IObjectFactory<? extends Boolean> iObjectFactory) {
            this.map.put("BisectingKMeansClusteringAlgorithm.useDimensionalityReduction", iObjectFactory);
            return this;
        }

        public LabelFormatterDescriptor.AttributeBuilder labelFormatter() {
            return LabelFormatterDescriptor.attributeBuilder(this.map);
        }

        public TermDocumentMatrixBuilderDescriptor.AttributeBuilder matrixBuilder() {
            return TermDocumentMatrixBuilderDescriptor.attributeBuilder(this.map);
        }

        public TermDocumentMatrixReducerDescriptor.AttributeBuilder matrixReducer() {
            return TermDocumentMatrixReducerDescriptor.attributeBuilder(this.map);
        }

        public MultilingualClusteringDescriptor.AttributeBuilder multilingualClustering() {
            return MultilingualClusteringDescriptor.attributeBuilder(this.map);
        }
    }

    public static final class Attributes {
        public final AttributeInfo clusterCount = new AttributeInfo("BisectingKMeansClusteringAlgorithm.clusterCount", "org.carrot2.clustering.kmeans.BisectingKMeansClusteringAlgorithm", "clusterCount", "The number of clusters to create. The algorithm will create at most the specified\nnumber of clusters.", "Cluster count", "The number of clusters to create", "The algorithm will create at most the specified number of clusters.", "Clusters", AttributeLevel.BASIC, null);
        public final AttributeInfo clusters;
        public final AttributeInfo documents;
        public final AttributeInfo labelCount;
        public final AttributeInfo maxIterations;
        public final AttributeInfo partitionCount;
        public final AttributeInfo preprocessingPipeline;
        public final AttributeInfo useDimensionalityReduction;
        public final LabelFormatterDescriptor.Attributes labelFormatter;
        public final TermDocumentMatrixBuilderDescriptor.Attributes matrixBuilder;
        public final TermDocumentMatrixReducerDescriptor.Attributes matrixReducer;
        public final MultilingualClusteringDescriptor.Attributes multilingualClustering;

        private Attributes() {
            this.clusters = new AttributeInfo("clusters", "org.carrot2.clustering.kmeans.BisectingKMeansClusteringAlgorithm", "clusters", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.clusters);
            this.documents = new AttributeInfo("documents", "org.carrot2.clustering.kmeans.BisectingKMeansClusteringAlgorithm", "documents", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.documents);
            this.labelCount = new AttributeInfo("BisectingKMeansClusteringAlgorithm.labelCount", "org.carrot2.clustering.kmeans.BisectingKMeansClusteringAlgorithm", "labelCount", "Label count. The minimum number of labels to return for each cluster.", "Label count", "Label count", "The minimum number of labels to return for each cluster.", "Clusters", AttributeLevel.BASIC, null);
            this.maxIterations = new AttributeInfo("BisectingKMeansClusteringAlgorithm.maxIterations", "org.carrot2.clustering.kmeans.BisectingKMeansClusteringAlgorithm", "maxIterations", "The maximum number of k-means iterations to perform.", "Maximum iterations", "The maximum number of k-means iterations to perform", null, "K-means", AttributeLevel.BASIC, null);
            this.partitionCount = new AttributeInfo("BisectingKMeansClusteringAlgorithm.partitionCount", "org.carrot2.clustering.kmeans.BisectingKMeansClusteringAlgorithm", "partitionCount", "Partition count. The number of partitions to create at each k-means clustering\niteration.", "Partition count", "Partition count", "The number of partitions to create at each k-means clustering iteration.", "K-means", AttributeLevel.BASIC, null);
            this.preprocessingPipeline = new AttributeInfo("BisectingKMeansClusteringAlgorithm.preprocessingPipeline", "org.carrot2.clustering.kmeans.BisectingKMeansClusteringAlgorithm", "preprocessingPipeline", "Common preprocessing tasks handler.", null, "Common preprocessing tasks handler", null, null, AttributeLevel.ADVANCED, null);
            this.useDimensionalityReduction = new AttributeInfo("BisectingKMeansClusteringAlgorithm.useDimensionalityReduction", "org.carrot2.clustering.kmeans.BisectingKMeansClusteringAlgorithm", "useDimensionalityReduction", "Use dimensionality reduction. If <code>true</code>, k-means will be applied on the\ndimensionality-reduced term-document matrix with the number of dimensions being\nequal to twice the number of requested clusters. If the number of dimensions is \nlower than the number of input documents, reduction will not be performed.\nIf <code>false</code>, the k-means will\nbe performed directly on the original term-document matrix.", "Use dimensionality reduction", "Use dimensionality reduction", "If <code>true</code>, k-means will be applied on the dimensionality-reduced term-document matrix with the number of dimensions being equal to twice the number of requested clusters. If the number of dimensions is lower than the number of input documents, reduction will not be performed. If <code>false</code>, the k-means will be performed directly on the original term-document matrix.", "K-means", AttributeLevel.BASIC, null);
            this.labelFormatter = LabelFormatterDescriptor.attributes;
            this.matrixBuilder = TermDocumentMatrixBuilderDescriptor.attributes;
            this.matrixReducer = TermDocumentMatrixReducerDescriptor.attributes;
            this.multilingualClustering = MultilingualClusteringDescriptor.attributes;
        }
    }

    public static class Keys {
        public static final String CLUSTER_COUNT = "BisectingKMeansClusteringAlgorithm.clusterCount";
        public static final String CLUSTERS = "clusters";
        public static final String DOCUMENTS = "documents";
        public static final String LABEL_COUNT = "BisectingKMeansClusteringAlgorithm.labelCount";
        public static final String MAX_ITERATIONS = "BisectingKMeansClusteringAlgorithm.maxIterations";
        public static final String PARTITION_COUNT = "BisectingKMeansClusteringAlgorithm.partitionCount";
        public static final String PREPROCESSING_PIPELINE = "BisectingKMeansClusteringAlgorithm.preprocessingPipeline";
        public static final String USE_DIMENSIONALITY_REDUCTION = "BisectingKMeansClusteringAlgorithm.useDimensionalityReduction";

        protected Keys() {
        }
    }
}

