/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.idol;

import com.sun.syndication.fetcher.FeedFetcher;
import com.sun.syndication.fetcher.impl.HttpURLFeedFetcher;
import java.net.URL;
import java.net.URLEncoder;
import java.util.concurrent.Callable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.MultipageSearchEngine;
import org.carrot2.source.MultipageSearchEngineMetadata;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.opensearch.RomeFetcherUtils;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.Required;
import org.carrot2.util.attribute.constraint.IntRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Bindable(prefix="IdolDocumentSource")
public class IdolDocumentSource
extends MultipageSearchEngine {
    static final Logger logger = LoggerFactory.getLogger(IdolDocumentSource.class);
    private static final int MAX_CONCURRENT_THREADS = 10;
    @Input
    @Processing
    @Init
    @Attribute
    @Required
    @Label(value="IDOL server address")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Service")
    public String idolServerName;
    @Input
    @Processing
    @Init
    @Attribute
    @Required
    @Label(value="IDOL server port")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Service")
    public int idolServerPort;
    @Input
    @Processing
    @Init
    @Attribute
    @Required
    @Label(value="IDOL XSL template name")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Service")
    public String xslTemplateName;
    @Input
    @Processing
    @Init
    @Attribute
    @Label(value="Other IDOLSearch attributes")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Service")
    public String otherSearchAttributes;
    @Input
    @Processing
    @Init
    @Attribute
    @Required
    @IntRange(min=1)
    @Label(value="Results per page")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Service")
    public int resultsPerPage = 50;
    @Input
    @Processing
    @Init
    @Attribute
    @IntRange(min=1)
    @Label(value="Minimum score")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Service")
    public int minScore = 50;
    @Input
    @Processing
    @Init
    @Attribute
    @IntRange(min=1)
    @Label(value="Maximum results")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Service")
    public int maximumResults = 100;
    @Input
    @Init
    @Processing
    @Attribute
    @Label(value="User agent")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Service")
    public String userAgent = null;
    @Input
    @Processing
    @Attribute
    @Label(value="User name")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Service")
    public String userName;
    private MultipageSearchEngineMetadata metadata;
    private FeedFetcher feedFetcher;

    public void beforeProcessing() {
        this.metadata = new MultipageSearchEngineMetadata(this.resultsPerPage, this.maximumResults, false);
        this.feedFetcher = new HttpURLFeedFetcher();
        if (StringUtils.isNotBlank((String)this.userAgent)) {
            this.feedFetcher.setUserAgent(this.userAgent);
        }
    }

    public void process() throws ProcessingException {
        super.process(this.metadata, this.getSharedExecutor(10, ((Object)((Object)this)).getClass()));
    }

    protected Callable<SearchEngineResponse> createFetcher(MultipageSearchEngine.SearchRange searchRange) {
        return new MultipageSearchEngine.SearchEngineResponseCallable(this){

            public SearchEngineResponse search() throws Exception {
                String string = IdolDocumentSource.this.getURL();
                logger.debug("Fetching URL: " + string);
                return RomeFetcherUtils.fetchUrl((String)string, (FeedFetcher)IdolDocumentSource.this.feedFetcher);
            }
        };
    }

    private String getURL() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("http://");
        stringBuilder.append(this.idolServerName);
        stringBuilder.append(":");
        stringBuilder.append(this.idolServerPort);
        stringBuilder.append("/action=Query&");
        stringBuilder.append("Text=" + this.query + "&");
        stringBuilder.append("MinScore=" + this.minScore + "&");
        stringBuilder.append("maxresults=" + this.maximumResults + "&");
        stringBuilder.append("template=" + this.xslTemplateName + "&");
        stringBuilder.append(this.otherSearchAttributes);
        if (this.userName != null && (string = this.getSecurityToken()) != "") {
            stringBuilder.append("&SecurityInfo=" + string);
        }
        return stringBuilder.toString();
    }

    private String getSecurityToken() {
        String string = "";
        try {
            String string2 = "http://" + this.idolServerName + ":" + this.idolServerPort + "/" + "action=userread&username=" + this.userName + "&securityinfo=true";
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new URL(string2).openStream());
            string = URLEncoder.encode(this.getSecurityInfo(document), "UTF-8");
        }
        catch (Exception exception) {
            logger.error("Could not get security token", (Throwable)exception);
        }
        return string;
    }

    private String getSecurityInfo(Document document) {
        String string = "";
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("responsedata");
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                Element element2 = (Element)node;
                string = IdolDocumentSource.getTagValue("autn:securityinfo", element2);
            }
            ++n;
        }
        return string;
    }

    private static String getTagValue(String string, Element element) {
        NodeList nodeList = element.getElementsByTagName(string).item(0).getChildNodes();
        Node node = nodeList.item(0);
        return node.getNodeValue();
    }
}

