/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.idol;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.source.MultipageSearchEngineDescriptor;
import org.carrot2.source.SearchEngineBaseDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;

public final class IdolDocumentSourceDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.idol.IdolDocumentSource";
    public final String prefix = "IdolDocumentSource";
    public final String title = "A <code>IDocumentSource</code> fetching <code>Document</code>s (search results) from an IDOL Search Engine";
    public final String label = "";
    public final String description = "Please note that you will need to install an XSLT stylesheet in your IDOL instance that transforms the search results into the OpenSearch format. The XSLT stylesheet is available under the <tt>org.carrot2.source.idol</tt> package, next to the binaries of this class. <p> Based on code donated by Julien Nioche. Autonomy IDOL support contributed by James Sealey. </p>";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    static {
        HashSet<AttributeInfo> hashSet = new HashSet<AttributeInfo>();
        hashSet.add(IdolDocumentSourceDescriptor.attributes.idolServerName);
        hashSet.add(IdolDocumentSourceDescriptor.attributes.idolServerPort);
        hashSet.add(IdolDocumentSourceDescriptor.attributes.maximumResults);
        hashSet.add(IdolDocumentSourceDescriptor.attributes.minScore);
        hashSet.add(IdolDocumentSourceDescriptor.attributes.otherSearchAttributes);
        hashSet.add(IdolDocumentSourceDescriptor.attributes.resultsPerPage);
        hashSet.add(IdolDocumentSourceDescriptor.attributes.userAgent);
        hashSet.add(IdolDocumentSourceDescriptor.attributes.userName);
        hashSet.add(IdolDocumentSourceDescriptor.attributes.xslTemplateName);
        HashSet<AttributeInfo> hashSet2 = new HashSet<AttributeInfo>();
        hashSet2.add(IdolDocumentSourceDescriptor.attributes.idolServerName);
        hashSet2.add(IdolDocumentSourceDescriptor.attributes.idolServerPort);
        hashSet2.add(IdolDocumentSourceDescriptor.attributes.maximumResults);
        hashSet2.add(IdolDocumentSourceDescriptor.attributes.minScore);
        hashSet2.add(IdolDocumentSourceDescriptor.attributes.otherSearchAttributes);
        hashSet2.add(IdolDocumentSourceDescriptor.attributes.resultsPerPage);
        hashSet2.add(IdolDocumentSourceDescriptor.attributes.userAgent);
        hashSet2.add(IdolDocumentSourceDescriptor.attributes.userName);
        hashSet2.add(IdolDocumentSourceDescriptor.attributes.xslTemplateName);
        hashSet2.add(MultipageSearchEngineDescriptor.attributes.searchMode);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.compressed);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.documents);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.query);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.results);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.resultsTotal);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.start);
        allAttributes = Collections.unmodifiableSet(hashSet2);
        ownAttributes = Collections.unmodifiableSet(hashSet);
        HashMap<String, AttributeInfo> hashMap = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> hashMap2 = new HashMap<String, AttributeInfo>();
        for (AttributeInfo attributeInfo : hashSet2) {
            hashMap.put(attributeInfo.key, attributeInfo);
            hashMap2.put(attributeInfo.fieldName, attributeInfo);
        }
        allAttributesByKey = Collections.unmodifiableMap(hashMap);
        allAttributesByFieldName = Collections.unmodifiableMap(hashMap2);
    }

    public static AttributeBuilder attributeBuilder(Map<String, Object> map) {
        return new AttributeBuilder(map);
    }

    public String getPrefix() {
        return "IdolDocumentSource";
    }

    public String getTitle() {
        return "A <code>IDocumentSource</code> fetching <code>Document</code>s (search results) from an IDOL Search Engine";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "Please note that you will need to install an XSLT stylesheet in your IDOL instance that transforms the search results into the OpenSearch format. The XSLT stylesheet is available under the <tt>org.carrot2.source.idol</tt> package, next to the binaries of this class. <p> Based on code donated by Julien Nioche. Autonomy IDOL support contributed by James Sealey. </p>";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    public static class AttributeBuilder
    extends MultipageSearchEngineDescriptor.AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            super(map);
            this.map = map;
        }

        public AttributeBuilder idolServerName(String string) {
            this.map.put("IdolDocumentSource.idolServerName", string);
            return this;
        }

        public AttributeBuilder idolServerName(IObjectFactory<? extends String> iObjectFactory) {
            this.map.put("IdolDocumentSource.idolServerName", iObjectFactory);
            return this;
        }

        public AttributeBuilder idolServerPort(int n) {
            this.map.put("IdolDocumentSource.idolServerPort", n);
            return this;
        }

        public AttributeBuilder idolServerPort(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("IdolDocumentSource.idolServerPort", iObjectFactory);
            return this;
        }

        public AttributeBuilder maximumResults(int n) {
            this.map.put("IdolDocumentSource.maximumResults", n);
            return this;
        }

        public AttributeBuilder maximumResults(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("IdolDocumentSource.maximumResults", iObjectFactory);
            return this;
        }

        public AttributeBuilder minScore(int n) {
            this.map.put("IdolDocumentSource.minScore", n);
            return this;
        }

        public AttributeBuilder minScore(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("IdolDocumentSource.minScore", iObjectFactory);
            return this;
        }

        public AttributeBuilder otherSearchAttributes(String string) {
            this.map.put("IdolDocumentSource.otherSearchAttributes", string);
            return this;
        }

        public AttributeBuilder otherSearchAttributes(IObjectFactory<? extends String> iObjectFactory) {
            this.map.put("IdolDocumentSource.otherSearchAttributes", iObjectFactory);
            return this;
        }

        public AttributeBuilder resultsPerPage(int n) {
            this.map.put("IdolDocumentSource.resultsPerPage", n);
            return this;
        }

        public AttributeBuilder resultsPerPage(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("IdolDocumentSource.resultsPerPage", iObjectFactory);
            return this;
        }

        public AttributeBuilder userAgent(String string) {
            this.map.put("IdolDocumentSource.userAgent", string);
            return this;
        }

        public AttributeBuilder userAgent(IObjectFactory<? extends String> iObjectFactory) {
            this.map.put("IdolDocumentSource.userAgent", iObjectFactory);
            return this;
        }

        public AttributeBuilder userName(String string) {
            this.map.put("IdolDocumentSource.userName", string);
            return this;
        }

        public AttributeBuilder userName(IObjectFactory<? extends String> iObjectFactory) {
            this.map.put("IdolDocumentSource.userName", iObjectFactory);
            return this;
        }

        public AttributeBuilder xslTemplateName(String string) {
            this.map.put("IdolDocumentSource.xslTemplateName", string);
            return this;
        }

        public AttributeBuilder xslTemplateName(IObjectFactory<? extends String> iObjectFactory) {
            this.map.put("IdolDocumentSource.xslTemplateName", iObjectFactory);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo idolServerName = new AttributeInfo("IdolDocumentSource.idolServerName", "org.carrot2.source.idol.IdolDocumentSource", "idolServerName", "URL of the IDOL Server.", "IDOL server address", "URL of the IDOL Server", null, "Service", AttributeLevel.BASIC, null);
        public final AttributeInfo idolServerPort = new AttributeInfo("IdolDocumentSource.idolServerPort", "org.carrot2.source.idol.IdolDocumentSource", "idolServerPort", "IDOL Server Port.", "IDOL server port", "IDOL Server Port", null, "Service", AttributeLevel.BASIC, null);
        public final AttributeInfo maximumResults = new AttributeInfo("IdolDocumentSource.maximumResults", "org.carrot2.source.idol.IdolDocumentSource", "maximumResults", "Maximum number of results. The maximum number of results the document source can\ndeliver.", "Maximum results", "Maximum number of results", "The maximum number of results the document source can deliver.", "Service", AttributeLevel.BASIC, null);
        public final AttributeInfo minScore = new AttributeInfo("IdolDocumentSource.minScore", "org.carrot2.source.idol.IdolDocumentSource", "minScore", "Minimum IDOL Score. The minimum score of the results returned by IDOL.", "Minimum score", "Minimum IDOL Score", "The minimum score of the results returned by IDOL.", "Service", AttributeLevel.BASIC, null);
        public final AttributeInfo otherSearchAttributes = new AttributeInfo("IdolDocumentSource.otherSearchAttributes", "org.carrot2.source.idol.IdolDocumentSource", "otherSearchAttributes", "Any other search attributes (separated by &amp;) from the Autonomy Query Search\nAPI's Ensure all the attributes are entered to satisfy XSL that will be applied.", "Other IDOLSearch attributes", "Any other search attributes (separated by &amp;) from the Autonomy Query Search API's Ensure all the attributes are entered to satisfy XSL that will be applied", null, "Service", AttributeLevel.ADVANCED, null);
        public final AttributeInfo resultsPerPage = new AttributeInfo("IdolDocumentSource.resultsPerPage", "org.carrot2.source.idol.IdolDocumentSource", "resultsPerPage", "Results per page. The number of results per page the document source will expect\nthe feed to return.", "Results per page", "Results per page", "The number of results per page the document source will expect the feed to return.", "Service", AttributeLevel.ADVANCED, null);
        public final AttributeInfo userAgent = new AttributeInfo("IdolDocumentSource.userAgent", "org.carrot2.source.idol.IdolDocumentSource", "userAgent", "User agent header. The contents of the User-Agent HTTP header to use when making\nrequests to the feed URL. If empty or <code>null</code> value is provided, the\nfollowing User-Agent will be sent:\n<code>Rome Client (http://tinyurl.com/64t5n) Ver: UNKNOWN</code>.", "User agent", "User agent header", "The contents of the User-Agent HTTP header to use when making requests to the feed URL. If empty or <code>null</code> value is provided, the following User-Agent will be sent: <code>Rome Client (http://tinyurl.com/64t5n) Ver: UNKNOWN</code>.", "Service", AttributeLevel.ADVANCED, null);
        public final AttributeInfo userName = new AttributeInfo("IdolDocumentSource.userName", "org.carrot2.source.idol.IdolDocumentSource", "userName", "User name to use for authentication.", "User name", "User name to use for authentication", null, "Service", AttributeLevel.MEDIUM, null);
        public final AttributeInfo xslTemplateName = new AttributeInfo("IdolDocumentSource.xslTemplateName", "org.carrot2.source.idol.IdolDocumentSource", "xslTemplateName", "IDOL XSL Template Name. The Reference of an IDOL XSL template that outputs the\nresults in OpenSearch format.", "IDOL XSL template name", "IDOL XSL Template Name", "The Reference of an IDOL XSL template that outputs the results in OpenSearch format.", "Service", AttributeLevel.ADVANCED, null);

        private Attributes() {
        }
    }

    public static class Keys
    extends MultipageSearchEngineDescriptor.Keys {
        public static final String IDOL_SERVER_NAME = "IdolDocumentSource.idolServerName";
        public static final String IDOL_SERVER_PORT = "IdolDocumentSource.idolServerPort";
        public static final String MAXIMUM_RESULTS = "IdolDocumentSource.maximumResults";
        public static final String MIN_SCORE = "IdolDocumentSource.minScore";
        public static final String OTHER_SEARCH_ATTRIBUTES = "IdolDocumentSource.otherSearchAttributes";
        public static final String RESULTS_PER_PAGE = "IdolDocumentSource.resultsPerPage";
        public static final String USER_AGENT = "IdolDocumentSource.userAgent";
        public static final String USER_NAME = "IdolDocumentSource.userName";
        public static final String XSL_TEMPLATE_NAME = "IdolDocumentSource.xslTemplateName";

        protected Keys() {
        }
    }
}

