/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.pubmed;

import com.carrotsearch.hppc.IntStack;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class PathTrackingHandler
implements ContentHandler {
    private final StringBuilder text = new StringBuilder();
    private final StringBuilder path = new StringBuilder();
    private final IntStack pathSegments = new IntStack();
    private final HashMap<String, Trigger> triggers = Maps.newHashMap();

    PathTrackingHandler() {
    }

    protected PathTrackingHandler addTrigger(String string, Trigger trigger) {
        if (this.triggers.containsKey(string)) {
            throw new IllegalArgumentException("Trigger already bound to path: " + string);
        }
        this.triggers.put(string, trigger);
        return this;
    }

    protected PathTrackingHandler addTrigger(List<String> list, Trigger trigger) {
        for (String string : list) {
            this.addTrigger(string, trigger);
        }
        return this;
    }

    @Override
    public void startDocument() throws SAXException {
        this.text.setLength(0);
        this.path.setLength(0);
        this.pathSegments.clear();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.pathSegments.push(this.path.length());
        this.path.append('/').append(string2);
        this.text.setLength(0);
        String string4 = this.path.toString();
        if (this.triggers.containsKey(string4)) {
            this.triggers.get(string4).onElement(string2, string4, attributes);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = this.path.toString();
        if (this.triggers.containsKey(string4)) {
            this.triggers.get(string4).afterElement(string2, string4, this.text.toString());
        }
        this.path.setLength(this.pathSegments.pop());
        this.text.setLength(0);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.text.append(cArray, n, n2);
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public abstract class Trigger {
        public void onElement(String string, String string2, Attributes attributes) {
        }

        public void afterElement(String string, String string2, String string3) {
        }
    }
}

