/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.pubmed;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import org.carrot2.core.Document;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.pubmed.PathTrackingHandler;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class PubMedContentHandler
extends PathTrackingHandler {
    private SearchEngineResponse response;

    public PubMedContentHandler() {
        super.addTrigger(Arrays.asList("/PubmedArticleSet/PubmedArticle", "/PubmedArticleSet/PubmedBookArticle"), new PathTrackingHandler.Trigger(this){
            String pmid;
            String title;
            StringBuilder body = new StringBuilder();
            {
                PubMedContentHandler.this.addTrigger(Arrays.asList("/PubmedArticleSet/PubmedArticle/MedlineCitation/PMID", "/PubmedArticleSet/PubmedBookArticle/BookDocument/PMID"), new PathTrackingHandler.Trigger(pathTrackingHandler){

                    @Override
                    public void afterElement(String string, String string2, String string3) {
                        if (!$assertionsDisabled && pmid != null) {
                            throw new AssertionError();
                        }
                        pmid = string3;
                    }
                });
                PubMedContentHandler.this.addTrigger(Arrays.asList("/PubmedArticleSet/PubmedArticle/MedlineCitation/Article/ArticleTitle", "/PubmedArticleSet/PubmedBookArticle/BookDocument/Book/ArticleTitle"), new PathTrackingHandler.Trigger(pathTrackingHandler){

                    @Override
                    public void afterElement(String string, String string2, String string3) {
                        if (!$assertionsDisabled && title != null) {
                            throw new AssertionError();
                        }
                        title = string3;
                    }
                });
                PubMedContentHandler.this.addTrigger(Arrays.asList("/PubmedArticleSet/PubmedArticle/MedlineCitation/Article/Abstract/AbstractText", "/PubmedArticleSet/PubmedBookArticle/BookDocument/Book/Abstract/AbstractText"), new PathTrackingHandler.Trigger(pathTrackingHandler){
                    Set<String> skipLabels = Sets.newHashSet((Object[])new String[]{"CONCLUSIONS", "METHODS", "RESULTS", "DIAGNOSIS/TESTING", "MANAGEMENT", "GENETIC COUNSELING"});
                    String label;

                    @Override
                    public void onElement(String string, String string2, Attributes attributes) {
                        this.label = attributes.getValue("", "NlmCategory");
                    }

                    @Override
                    public void afterElement(String string, String string2, String string3) {
                        if (this.label == null || !this.skipLabels.contains(this.label)) {
                            if (body.length() > 0) {
                                body.append(" ... ");
                            }
                            body.append(string3);
                        }
                    }
                });
            }

            @Override
            public void onElement(String string, String string2, Attributes attributes) {
                this.title = null;
                this.pmid = null;
                this.body.setLength(0);
            }

            @Override
            public void afterElement(String string, String string2, String string3) {
                if (this.pmid != null) {
                    ((PubMedContentHandler)PubMedContentHandler.this).response.results.add(new Document(this.title, this.body.toString(), "http://www.ncbi.nlm.nih.gov/pubmed/" + this.pmid, null, this.pmid));
                } else {
                    LoggerFactory.getLogger(PubMedContentHandler.class).warn("No PMID on a <PubmedArticle>?");
                }
            }
        });
    }

    @Override
    public void startDocument() throws SAXException {
        this.response = new SearchEngineResponse();
    }

    public SearchEngineResponse getResponse() {
        return this.response;
    }
}

