/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.pubmed;

import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.http.client.RedirectStrategy;
import org.carrot2.core.Document;
import org.carrot2.core.LanguageCode;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.SimpleSearchEngine;
import org.carrot2.source.pubmed.EmptyEntityResolver;
import org.carrot2.source.pubmed.PubMedContentHandler;
import org.carrot2.source.pubmed.PubMedIdSearchHandler;
import org.carrot2.util.StringUtils;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.constraint.IntRange;
import org.carrot2.util.httpclient.HttpRedirectStrategy;
import org.carrot2.util.httpclient.HttpUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@Bindable(prefix="PubMedDocumentSource")
public class PubMedDocumentSource
extends SimpleSearchEngine {
    public static final String E_SEARCH_URL = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi";
    public static final String E_FETCH_URL = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi";
    public static final int PUBMED_TIMEOUT = 24000;
    @Init
    @Input
    @Attribute
    @Label(value="EUtils Registered Tool Name")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Search query")
    public String toolName = "Carrot Search";
    @Processing
    @Input
    @Attribute
    @IntRange(min=1)
    @Internal(configuration=true)
    @Label(value="Maximum results")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Search query")
    public int maxResults = 150;
    @Input
    @Processing
    @Attribute
    @Label(value="HTTP redirect strategy")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Service")
    @Internal
    public HttpRedirectStrategy redirectStrategy = HttpRedirectStrategy.NO_REDIRECTS;

    protected SearchEngineResponse fetchSearchResponse() throws Exception {
        PubMedIdSearchHandler pubMedIdSearchHandler = this.getPubMedIds(this.query, this.results);
        SearchEngineResponse searchEngineResponse = this.getPubMedAbstracts(pubMedIdSearchHandler.getPubMedPrimaryIds());
        searchEngineResponse.metadata.put("resultsTotal", pubMedIdSearchHandler.getMatchCount());
        return searchEngineResponse;
    }

    protected void afterFetch(SearchEngineResponse searchEngineResponse) {
        for (Document document : searchEngineResponse.results) {
            document.setLanguage(LanguageCode.ENGLISH);
        }
    }

    private PubMedIdSearchHandler getPubMedIds(String string, int n) throws Exception {
        XMLReader xMLReader = PubMedDocumentSource.newXmlReader();
        PubMedIdSearchHandler pubMedIdSearchHandler = new PubMedIdSearchHandler();
        xMLReader.setContentHandler(pubMedIdSearchHandler);
        String string2 = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?db=pubmed&usehistory=n&&term=" + StringUtils.urlEncodeWrapException((String)string, (String)"UTF-8") + "&retmax=" + Integer.toString(Math.min(n, this.maxResults)) + "&tool=" + StringUtils.urlEncodeWrapException((String)this.toolName, (String)"UTF-8");
        HttpUtils.Response response = HttpUtils.doGET((String)string2, null, null, null, null, (int)24000, (RedirectStrategy)this.redirectStrategy.value());
        if (response.status != 200) {
            throw new IOException("PubMed returned HTTP Error: " + response.status + ", HTTP payload: " + new String(response.payload, "iso8859-1"));
        }
        xMLReader.parse(new InputSource(response.getPayloadAsStream()));
        return pubMedIdSearchHandler;
    }

    private SearchEngineResponse getPubMedAbstracts(List<String> list) throws Exception {
        if (list.isEmpty()) {
            return new SearchEngineResponse();
        }
        XMLReader xMLReader = PubMedDocumentSource.newXmlReader();
        PubMedContentHandler pubMedContentHandler = new PubMedContentHandler();
        xMLReader.setContentHandler(pubMedContentHandler);
        String string = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=pubmed&retmode=xml&rettype=abstract&id=" + this.getIdsString(list) + "&tool=" + StringUtils.urlEncodeWrapException((String)this.toolName, (String)"UTF-8");
        HttpUtils.Response response = HttpUtils.doGET((String)string, null, null, null, null, (int)24000, (RedirectStrategy)this.redirectStrategy.value());
        if (response.status != 200) {
            throw new IOException("PubMed returned HTTP Error: " + response.status + ", HTTP payload: " + new String(response.payload, "iso8859-1"));
        }
        xMLReader.parse(new InputSource(response.getPayloadAsStream()));
        return pubMedContentHandler.getResponse();
    }

    static XMLReader newXmlReader() throws SAXException, ParserConfigurationException {
        XMLReader xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        xMLReader.setFeature("http://xml.org/sax/features/validation", false);
        xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
        xMLReader.setEntityResolver(new EmptyEntityResolver());
        return xMLReader;
    }

    private String getIdsString(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string);
            stringBuilder.append(",");
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        return "";
    }
}

